{ Sample Turbo Pascal 5.5 program demonstrating use of object libraries.
  Uses Object Professional objects for windows, menus.  }

{$D-,L-,S-,R-}

unit FILEOBJ;

interface

uses EmpObj, OpRoot;

const
  idprogrammer = 0;
  idclerk = 1;
  idsalesman = 2;

type

  EmpRecord = record
    number       : Integer;
    name         : String[30];
    address      : String[30];
    city         : String[15];
    state        : String[2];
    zip          : Integer;
    phone        : String[14];
    title        : Integer;
    salary       : Real;
    regRate      : Real;
    otRate       : Real;
    regHours     : Real;
    otHours      : Real;
    commission   : Real;
    fedTax       : Real;
    stateTax     : Real;
    ficaTax      : Real;
  end;

  EmpNodePtr = ^EmpNode;

  EmpNode = object(DoubleListNode)
    EmpRecPtr : EmployeePtr;           {Each node object contains a
                                        single ivar, viz., a pointer
                                        to an employee object.}
    constructor Init(ERP : EmployeePtr);
    function GetEmpRec : EmployeePtr; virtual;
  end;

  MasterFile = object
    constructor Init;
    constructor Open;
    function ReadFirst : EmployeePtr; virtual;
    function ReadNext : EmployeePtr; virtual;
    function ReadPrev : EmployeePtr; virtual;
    function ConvRecToObj(ER : EmpRecord) : EmployeePtr; virtual;
    procedure Write(ER : EmpRecord); virtual;
    procedure Replace(ER : EmpRecord); virtual;
    procedure Delete(EN : Integer); virtual;
    procedure Close; virtual;
    destructor Done; virtual;
  end;

var
  EmpList : DoubleList;                {A doubly linked list of pointers
                                        to employee objects.}
  ENP : EmpNodePtr;                    {A pointer to a node in EmpList.}
  PP : ProgrammerPtr;
  CP : ClerkPtr;
  SP : SalesmanPtr;

implementation

constructor EmpNode.Init(ERP : EmployeePtr);
begin
  EmpRecPtr := ERP;
end;

function EmpNode.GetEmpRec : EmployeePtr;

begin
  GetEmpRec := EmpRecPtr;
end;

constructor MasterFile.Init;           {Create a MasterFile object}
begin

  EmpList.Init;                        {Start a new linked list}
                                       {Add 3 test data records}

  New(PP, Init);                       {Make a Programmer object}
  PP^.EmpNum := 1001;
  PP^.EmpName := 'Sam';
  PP^.EmpTitle := 0;
  PP^.Salary := 1000.00;
  PP^.FedTax := 100.00;
  PP^.StateTax := 50.00;
  PP^.FicaTax := 100.00;
  New(ENP, Init(PP));                  {Make a new node which contains}
  EmpList.Append(ENP);                 {a pointer to an employee object.}
                                       {Append it to EmpList.}

  New(CP, Init);                       {Make a Clerk object}
  CP^.EmpNum := 1002;
  CP^.EmpName := 'Fred';
  CP^.EmpTitle := 1;
  CP^.RegHours := 40;
  CP^.RegRate := 12.00;
  CP^.OtHours := 10;
  CP^.OtRate := 18.00;
  CP^.FedTax := 80.00;
  CP^.StateTax := 20.00;
  CP^.FicaTax := 75.00;
  New(ENP, Init(CP));
  EmpList.Append(ENP);

  New(SP, Init);                       {Make a Salesman object}
  SP^.EmpNum := 1003;
  SP^.EmpName := 'Phil';
  SP^.EmpTitle := 2;
  SP^.Salary := 1200.00;
  SP^.Commission := 100.00;
  SP^.FedTax := 120.00;
  SP^.StateTax := 60.00;
  SP^.FicaTax := 100.00;
  New(ENP, Init(SP));
  EmpList.Append(ENP);

  ENP := EmpNodePtr(EmpList.Head);     {Get pointer to head of list.
                                        Typecast to EmpNodePtr.}

end;

constructor MasterFile.Open;
begin
  MasterFile.Init;
end;

function MasterFile.ReadFirst : EmployeePtr;
begin
  ENP := EmpNodePtr(EmpList.Head);
  if ENP <> nil then
    ReadFirst := ENP^.GetEmpRec
  else
    ReadFirst := nil;
end;

function MasterFile.ReadNext : EmployeePtr;
begin
  ENP := EmpNodePtr(EmpList.Next(ENP));
  if ENP <> nil then
    ReadNext := ENP^.GetEmpRec
  else
    ReadNext := nil;
end;

function MasterFile.ReadPrev : EmployeePtr;
begin
  ENP := EmpNodePtr(EmpList.Prev(ENP));
  if ENP <> nil then
    ReadPrev := ENP^.GetEmpRec
  else
    ReadPrev := nil;
end;

function MasterFile.ConvRecToObj(ER : EmpRecord) : EmployeePtr;
var
  TP : EmployeePtr;                    {Temporary Pointer}
begin
  case ER.title of
    idprogrammer :
      begin
        New(PP, Init);
        TP := PP;
      end;
    idclerk      :
      begin
        New(CP, Init);
        TP := CP;
      end;
    idsalesman   :
      begin
        New(SP, Init);
        TP := SP;
      end;
  end; {case}
  TP^.EmpNum := ER.number;
  TP^.EmpName := ER.name;
  TP^.EmpAddr := ER.address;
  TP^.EmpCity := ER.city;
  TP^.EmpState := ER.state;
  TP^.EmpZip := ER.zip;
  TP^.EmpPhone := ER.phone;
  TP^.EmpTitle := ER.title;
  TP^.Salary := ER.salary;
  TP^.RegRate := ER.regRate;
  TP^.OtRate := ER.otRate;
  TP^.RegHours := ER.regHours;
  TP^.OtHours := ER.otHours;
  TP^.Commission := ER.commission;
  TP^.FedTax := ER.fedTax;
  TP^.StateTax := ER.stateTax;
  TP^.FicaTax := ER.ficaTax;
  ConvRecToObj := TP;
end;

procedure MasterFile.Write(ER : EmpRecord);
var
  TP : EmployeePtr;
begin
  TP := MasterFile.ConvRecToObj(ER);
  New(ENP, Init(TP));
  EmpList.Append(ENP);
end;

procedure MasterFile.Replace(ER : EmpRecord);
var
  EP, TP : EmployeePtr;
begin
  TP := MasterFile.ConvRecToObj(ER);
  New(ENP, Init(TP));
  EP := MasterFile.ReadFirst;
  while EP^.EmpNum <> TP^.EmpNum do
    EP := MasterFile.ReadNext;
  EP^ := TP^;
end;

procedure MasterFile.Delete(EN : integer);
var
  Finished : boolean;
  TP : EmployeePtr;
begin
  Finished := False;
  ENP := EmpNodePtr(EmpList.Head);
  repeat
    if ENP <> nil then
      begin
        TP := ENP^.GetEmpRec;
        if TP^.EmpNum = EN then
           begin
             EmpList.Delete(ENP);  { also delete the employee }
             Finished := True;
           end
        else
           ENP := EmpNodePtr(EmpList.Next(ENP));
      end
    else
      Finished := True;
  until Finished = True;
end;

procedure MasterFile.Close;
begin
  MasterFile.Done;
end;

destructor MasterFile.Done;
begin
  ENP := EmpNodePtr(EmpList.Head);
  while ENP <> nil do
  begin
    EmpList.Delete(ENP);
    ENP := EmpNodePtr(EmpList.Head)
  end;
  EmpList.Done;
end;

end.
