{ Pamain.Pas        -- main program unit called by Payroll.pas
                    -- made into separate unit to allow easy compiling
}

{$D+,L+,V-,R-,S-}
{I OPDEFINE.INC}

unit PayMain;

interface

uses
  Dos,
  OpInline,
  OpString,
  OpRoot,
  OpCrt,
  OpColor,
  OpFrame,
  OpCmd,
  OpWindow,
  OpMenu,
  FileObj,
  PayScr,
  PayReg,
  Dialogs;

procedure Main;

implementation

{Color set used by menu system}
const
  MenuColors : ColorSet = (
    TextColor       : YellowOnBlue;       TextMono        : LtGrayOnBlack;
    CtrlColor       : YellowOnBlue;       CtrlMono        : WhiteOnBlack;
    FrameColor      : CyanOnBlue;         FrameMono       : LtGrayOnBlack;
    HeaderColor     : WhiteOnCyan;        HeaderMono      : BlackOnLtGray;
    ShadowColor     : DkGrayOnBlack;      ShadowMono      : WhiteOnBlack;
    HighlightColor  : WhiteOnRed;         HighlightMono   : BlackOnLtGray;
    PromptColor     : BlackOnCyan;        PromptMono      : LtGrayOnBlack;
    SelPromptColor  : BlackOnCyan;        SelPromptMono   : LtGrayOnBlack;
    ProPromptColor  : BlackOnCyan;        ProPromptMono   : LtGrayOnBlack;
    FieldColor      : YellowOnBlue;       FieldMono       : LtGrayOnBlack;
    SelFieldColor   : BlueOnCyan;         SelFieldMono    : WhiteOnBlack;
    ProFieldColor   : LtGrayOnBlue;       ProFieldMono    : LtGrayOnBlack;
    ScrollBarColor  : CyanOnBlue;         ScrollBarMono   : LtGrayOnBlack;
    SliderColor     : CyanOnBlue;         SliderMono      : WhiteOnBlack;
    HotSpotColor    : BlackOnCyan;        HotSpotMono     : BlackOnLtGray;
    BlockColor      : YellowOnCyan;       BlockMono       : WhiteOnBlack;
    MarkerColor     : WhiteOnMagenta;     MarkerMono      : BlackOnLtGray;
    DelimColor      : BlueOnCyan;         DelimMono       : WhiteOnBlack;
    SelDelimColor   : BlueOnCyan;         SelDelimMono    : WhiteOnBlack;
    ProDelimColor   : BlueOnCyan;         ProDelimMono    : WhiteOnBlack;
    SelItemColor    : YellowOnCyan;       SelItemMono     : BlackOnLtGray;
    ProItemColor    : LtGrayOnBlue;       ProItemMono     : LtGrayOnBlack;
    HighItemColor   : WhiteOnBlue;        HighItemMono    : WhiteOnBlack;
    AltItemColor    : WhiteOnBlue;        AltItemMono     : WhiteOnBlack;
    AltSelItemColor : WhiteOnCyan;        AltSelItemMono  : BlackOnLtGray;
    FlexAHelpColor  : WhiteOnBlue;        FlexAHelpMono   : WhiteOnBlack;
    FlexBHelpColor  : WhiteOnBlue;        FlexBHelpMono   : WhiteOnBlack;
    FlexCHelpColor  : LtCyanOnBlue;       FlexCHelpMono   : BlackOnLtGray;
    UnselXrefColor  : YellowOnBlue;       UnselXrefMono   : LtBlueOnBlack;
    SelXrefColor    : WhiteOnMagenta;     SelXrefMono     : BlackOnLtGray;
    MouseColor      : WhiteOnRed;         MouseMono       : BlackOnLtGray
  );

{Menu item constants}
const
  miUpdate        = 1;
  miAdd           = 4;
  miChange        = 5;
  miDelete        = 6;
  miQuit          = 7;
  miPay           = 2;
  miHelp          = 3;

var
  Finished : boolean;
  EmpMastFile : MasterFile;

{$F+}
procedure ErrorHandler(UnitCode : Byte; var ErrCode : Word; Msg : string);
  {-Report errors}
begin
  RingBell;
end;

procedure DisplayHelp(UnitCode : Byte; IdPtr : Pointer; HelpIndex : Word);
  {-Display context sensitive help}
begin
end;

procedure CustomizeItemString(var Name : String; Key : LongInt;
                              Selected, Highlighted : Boolean;
                              WPtr : RawWindowPtr);
  {-Customize menu item strings}
begin
end;
{$F-}

function InitMenu(var M : Menu) : Word;
  {-Initialize menu system generated by MAKEMENU}
const
  {Frame constants}
  Frame1 : FrameArray = 'Ըͳ';
begin
  with M do begin
    if not InitCustom(2, 2, 79, 2, MenuColors,
                      wBordered+wClear+wUserContents+wCoversOnDemand,
                      Horizontal) then begin
      InitMenu := InitStatus;
      Exit;
    end;
    mnOptionsOn(mnAlphaMatch+mnSelectOnMatch+mnAllowPending+mnArrowSelect+
                mnAllHotSpots);
    mnOptionsOff(mnPopOnSelect+mnUseItemForTopic+mnSelectOnClick);
    wFrame.SetFrameType(Frame1);
    AddHeader(' Payroll Program ', heTC);
    AddShadow(shBR, shSeeThru);
    AddSeparator('', '', '', 64);
    AddItem('Update', 2, 1, miUpdate);
      AddFramedSubMenu(4, 4, 11, 8, Vertical, Frame1);
      AddShadow(shBR, shSeeThru);
      AddSeparator('', '', '', 4);
      AddItem('Add', 1, 1, miAdd);
      AddItem('Change', 2, 1, miChange);
      AddItem('Delete', 3, 1, miDelete);
      AddItem('Quit', 5, 1, miQuit);
      ItemsDone;
    AddItem('Pay', 12, 1, miPay);
    AddItemHelp('Help', 70, 1, miHelp,
      'Use UPDATE to ADD, CHANGE or DELETE employees.  Use PAY to run payroll.');
    ItemsDone;

    SetErrorProc(ErrorHandler);
    MenuCommands.SetHelpProc(DisplayHelp);
    SetCustomStringProc(CustomizeItemString);

    InitMenu := RawError;
  end;
end;

function InitHelpLine(var H : RawWindow) : Word;
  {-Initialize window for the help line}
var
  Row : Byte;
begin
  Row := 24;
  if not H.InitCustom(1, Row, ScreenWidth, Row,
                      MenuColors, wClear) then begin
    InitHelpLine := InitStatus;
    Exit;
  end;
  H.SetTextAttr(YellowOnBlue, LtGrayOnBlack);
  InitHelpLine := 0;
end;

{*** sample test code follows ***}

var
  Status : Word;
  M      : Menu;      {menu system}
  H      : RawWindow; {item help window}

{$F+}
procedure UpdateHelpLine(CurrentItem : MenuItemNodePtr; MPtr : MenuPtr);
  {-Update HelpLine for each menu item}
var
  S : String;
begin
  if CurrentItem = nil then
    S := ''
  else
    S := CurrentItem^.HelpString;
  H.wFastText(Pad(S, H.Width), 1, 1);
end;
{$F-}

procedure AddEmployee;
begin
  ShowAddScr(EmpMastFile);
end;

procedure ChgEmployee;
begin
  RunChangeDialog(EmpMastFile);
end;

procedure DelEmployee;
begin
  RunDeleteDialog(EmpMastFile);
end;

procedure PayEmployees;
begin
  RunPayroll(EmpMastFile);
end;

procedure Main;
begin
  ClrScr;

  Status := InitMenu(M);
  if Status <> 0 then begin
    WriteLn('Error initializing menu: ', Status);
    Halt(1);
  end;

  Status := InitHelpLine(H);
  if Status <> 0 then begin
    WriteLn('Error initializing help line: ', Status);
    Halt(1);
  end;
  M.SetCurrentItemProc(UpdateHelpLine);

  H.Draw;
  M.Draw;

  EmpMastFile.Open;

  Finished := False;
  repeat
    M.Process;
    if M.GetLastCommand = ccSelect then
      case M.MenuChoice of
        miAdd    : AddEmployee;
        miChange : ChgEmployee;
        miDelete : DelEmployee;
        miQuit   : Finished := True;
        miPay    : PayEmployees;
        miHelp   : ;
     end;
  until Finished;
  M.Erase;
  H.Erase;
  WriteLn('Item ', M.MenuChoice);
  WriteLn('Command ', M.GetLastCommand);
  H.Done;
  M.Done;

  EmpMastFile.Close;

end; { Main }

end.
