{ Sample Turbo Pascal 5.5 program demonstrating use of object libraries.
  Uses Object Professional objects for windows, menus.  }

{$V-,D-,L-}

unit PAYSCR;

interface

uses FileObj, EmpObj;

procedure ShowAddScr(var EmpMastFile : MasterFile);
procedure ShowChgScr(var EmpMastFile : MasterFile; EN : integer);

implementation

{$I OPDEFINE.INC}

uses
  Dos,
  OpInline,
  OpString,
  OpRoot,
  OpCrt,
  OpColor,
  {$IFDEF UseMouse}
  OpMouse,
  {$ENDIF}
  OpAbsFld,
  OpCmd,
  OpField,
  OpFrame,
  OpWindow,
  OpSelect,
  OpEntry;

{$IFDEF UseMouse}
const
  MouseChar  : Char = #04;
{$ENDIF}

{Color set used by entry screen}
const
  EsColors : ColorSet = (
    TextColor       : YellowOnBlue;       TextMono        : WhiteOnBlack;
    CtrlColor       : YellowOnBlue;       CtrlMono        : WhiteOnBlack;
    FrameColor      : WhiteOnBlue;        FrameMono       : WhiteOnBlack;
    HeaderColor     : WhiteOnCyan;        HeaderMono      : BlackOnLtGray;
    ShadowColor     : DkGrayOnBlack;      ShadowMono      : WhiteOnBlack;
    HighlightColor  : WhiteOnRed;         HighlightMono   : BlackOnLtGray;
    PromptColor     : LtGrayOnBlue;       PromptMono      : LtGrayOnBlack;
    SelPromptColor  : LtGrayOnBlue;       SelPromptMono   : LtGrayOnBlack;
    ProPromptColor  : LtGrayOnBlue;       ProPromptMono   : LtGrayOnBlack;
    FieldColor      : YellowOnBlue;       FieldMono       : LtGrayOnBlack;
    SelFieldColor   : BlueOnCyan;         SelFieldMono    : WhiteOnBlack;
    ProFieldColor   : LtGrayOnBlue;       ProFieldMono    : LtGrayOnBlack;
    ScrollBarColor  : CyanOnBlue;         ScrollBarMono   : LtGrayOnBlack;
    SliderColor     : CyanOnBlue;         SliderMono      : WhiteOnBlack;
    HotSpotColor    : BlackOnCyan;        HotSpotMono     : BlackOnLtGray;
    BlockColor      : YellowOnCyan;       BlockMono       : WhiteOnBlack;
    MarkerColor     : WhiteOnCyan;        MarkerMono      : BlackOnLtGray;
    DelimColor      : YellowOnBlue;       DelimMono       : WhiteOnBlack;
    SelDelimColor   : BlueOnCyan;         SelDelimMono    : WhiteOnBlack;
    ProDelimColor   : YellowOnBlue;       ProDelimMono    : WhiteOnBlack;
    SelItemColor    : YellowOnCyan;       SelItemMono     : BlackOnLtGray;
    ProItemColor    : LtGrayOnBlue;       ProItemMono     : LtGrayOnBlack;
    HighItemColor   : WhiteOnBlue;        HighItemMono    : WhiteOnBlack;
    AltItemColor    : WhiteOnBlue;        AltItemMono     : WhiteOnBlack;
    AltSelItemColor : WhiteOnCyan;        AltSelItemMono  : BlackOnLtGray;
    FlexAHelpColor  : WhiteOnBlue;        FlexAHelpMono   : WhiteOnBlack;
    FlexBHelpColor  : WhiteOnBlue;        FlexBHelpMono   : WhiteOnBlack;
    FlexCHelpColor  : LtCyanOnBlue;       FlexCHelpMono   : BlackOnLtGray;
    UnselXrefColor  : YellowOnBlue;       UnselXrefMono   : LtBlueOnBlack;
    SelXrefColor    : WhiteOnCyan;        SelXrefMono     : BlackOnLtGray;
    MouseColor      : WhiteOnRed;         MouseMono       : BlackOnLtGray
  );

{Entry field constants}
const
  idnumber               = 0;
  idname                 = idnumber + 1;
  idaddress              = idname + 1;
  idcity                 = idaddress + 1;
  idstate                = idcity + 1;
  idzip                  = idstate + 1;
  idphone                = idzip + 1;
  idtitle                = idphone + 1;
  idsalary               = idtitle +1;
  idregRate              = idsalary + 1;
  idotRate               = idregRate + 1;
  idregHours             = idotRate + 1;
  idotHours              = idregHours + 1;
  idcommission           = idotHours + 1;
  idfedTax               = idcommission + 1;
  idstateTax             = idfedTax + 1;
  idficaTax              = idstateTax + 1;

{Help index constants}
const
  hinumber               = 1;
  hiname                 = hinumber + 1;
  hiaddress              = hiname + 1;
  hicity                 = hiaddress + 1;
  histate                = hicity + 1;
  hizip                  = histate + 1;
  hiphone                = hizip + 1;
  hititle                = hiphone + 1;
  hisalary               = hititle + 1;
  hiregRate              = hisalary + 1;
  hiotRate               = hiregRate + 1;
  hiregHours             = hiotRate + 1;
  hiotHours              = hiregHours + 1;
  hicommission           = hiotHours + 1;
  hifedTax               = hicommission + 1;
  histateTax             = hifedTax + 1;
  hificaTax              = histateTax + 1;

var
  ES         : EntryScreen;
  ER         : EmpRecord;
  Status     : Word;
  AcceptIt   : Boolean;
  Finished   : Boolean;
  ShouldFill : Boolean;

procedure DisplayCentered(S : string; Row : byte);
begin
  with ESColors do
    FastWrite(Center(S, 80), Row, 1, ColorMono(TextColor, TextMono));
end;

{$F+}
procedure PreEdit(ESP : EntryScreenPtr);
{Called just before a field is edited}
var
  S : string[80];
begin
  with ESP^ do
    case GetCurrentID of
      idnumber          : S := 'Enter 4 digit I.D.';
      idname            : S := 'Enter first and last name';
      idaddress         : S := 'Enter street address or P.O.Box';
      idcity            : S := 'Enter city';
      idstate           : S := 'Enter 2 character state code';
      idzip             : S := 'Enter 5 digit zip code';
      idphone           : S := 'Enter phone number with area code';
      idtitle           : S := '0 = programmer, 1 = clerk, 2 = salesman';
      idsalary          : S := 'Enter salary (programmers and salesmen only)';
      idregRate         : S := 'Enter regular rate (clerks only)';
      idotRate          : S := 'Enter overtime rate (clerks only)';
      idregHours        : S := 'Enter regular hours worked (clerks only)';
      idotHours         : S := 'Enter overtime hours worked (clerks only)';
      idcommission      : S := 'Enter earned comission (salesmen only)';
      idfedTax          : S := 'Enter federal income tax to be withheld';
      idstateTax        : S := 'Enter state income tax to be withheld';
      idficaTax         : S := 'Enter social security to be withheld';
    end;
    DisplayCentered(S, 24);
end;

procedure PostEdit(ESP : EntryScreenPtr);
{Called just after a field has been edited - not used in this program}
begin
  with ESP^ do
    case GetCurrentID of
      idnumber               : ;
      idname                 : ;
      idaddress              : ;
      idcity                 : ;
      idstate                : ;
      idzip                  : ;
      idphone                : ;
      idtitle                : ;
      idsalary               : ;
      idregRate              : ;
      idotRate               : ;
      idregHours             : ;
      idotHours              : ;
      idcommission           : ;
      idfedTax               : ;
      idstateTax             : ;
      idficaTax              : ;
    end;
end;

procedure IncChoice(var Value; ID : Word; Factor : Integer; var St : string);
  {-Increment a multiple choice field value and convert it to a string}
begin
end;

procedure ErrorHandler(UnitCode : Byte; var ErrCode : Word; Msg : string);
  {-Report errors}
begin
  RingBell;
end;

procedure DisplayHelp(UnitCode : Byte; IdPtr : Pointer; HelpIndex : Word);
  {-Display context sensitive help}
begin
end;
{$F-}

function InitEntryScreen : Word;
  {-Initialize entry screen generated by MAKESCRN}
const
  Frame1 = 'Ըͳ';
  WinOptions = wBordered+wClear+wUserContents;
begin
  with ES do begin
    if not InitCustom(10, 2, 65, 22, EsColors, WinOptions) then begin
      InitEntryScreen := InitStatus;
      Exit;
    end;

    wFrame.SetFrameType(Frame1);
    wFrame.AddShadow(shBR, shSeeThru);
    wFrame.AddHeader(' Employee Information ', heTC);
    SetWrapMode(WrapAtEdges);

    SetPreEditProc(PreEdit);
    SetPostEditProc(PostEdit);
    SetErrorProc(ErrorHandler);
    EntryCommands.SetHelpProc(DisplayHelp);

  {idnumber - a required field:}
    esFieldOptionsOn(efRequired);
    AddIntField(
      'number:', 2, 17,
      '9999', 2, 25,
      hinumber, 0, 9999, ER.number);
    esFieldOptionsOff(efRequired);

  {idname - a required field:}
    esFieldOptionsOn(efRequired);
    AddStringField(
      'name:', 3, 19,
      CharStr('X', 30), 3, 25, 30,
      hiname, ER.name);
    esFieldOptionsOff(efRequired);

  {idaddress:}
    AddStringField(
      'address:', 4, 16,
      CharStr('X', 30), 4, 25, 30,
      hiaddress, ER.address);

  {idcity:}
    AddStringField(
      'city:', 5, 19,
      'XXXXXXXXXXXXXXX', 5, 25, 15,
      hicity, ER.city);

  {idstate:}
    AddStringField(
      'state:', 6, 18,
      'XX', 6, 25, 2,
      histate, ER.state);

  {idzip:}
    AddIntField(
      'zip code:', 7, 15,
      '99999', 7, 25,
      hizip, -32768, 32767, ER.zip);

  {idphone:}
    AddStringField(
      'phone:', 8, 18,
      '(999) 999-9999', 8, 25, 14,
      hiphone, ER.phone);

  {idtitle - a required field:}
    esFieldOptionsOn(efRequired);
    AddIntField(
      'title:', 9, 18,
      '9', 9, 25,
      hinumber, 0, 2, ER.title);
    esFieldOptionsOff(efRequired);

  {idsalary:}
    esFieldOptionsOn(efRightJustify);
    AddRealField(
      'salary:', 11, 17,
      '9,999,999.99', 11, 25,
      hisalary, -1.5E+0038,  1.5E+0038, 0, ER.salary);
    esFieldOptionsOff(efRightJustify);

  {idregRate:}
    esFieldOptionsOn(efRightJustify);
    AddRealField(
      'regular rate:', 12, 11,
      '999.99', 12, 25,
      hiregRate, -1.5E+0038,  1.5E+0038, 0, ER.regRate);
    esFieldOptionsOff(efRightJustify);

  {idotRate:}
    esFieldOptionsOn(efRightJustify);
    AddRealField(
      'overtime rate:', 13, 10,
      '999.99', 13, 25,
      hiotRate, -1.5E+0038,  1.5E+0038, 0, ER.otRate);
    esFieldOptionsOff(efRightJustify);

  {idregHours:}
    esFieldOptionsOn(efRightJustify);
    AddRealField(
      'regular hours worked:', 14, 3,
      '99.99', 14, 25,
      hiregHours, -1.5E+0038,  1.5E+0038, 0, ER.regHours);
    esFieldOptionsOff(efRightJustify);

  {idotHours:}
    esFieldOptionsOn(efRightJustify);
    AddRealField(
      'overtime hours worked:', 15, 2,
      '99.99', 15, 25,
      hiotHours, -1.5E+0038,  1.5E+0038, 0, ER.otHours);
    esFieldOptionsOff(efRightJustify);

  {idcommission:}
    esFieldOptionsOn(efRightJustify);
    AddRealField(
      'commission:', 16, 13,
      '9,999.99', 16, 25,
      hicommission, -1.5E+0038,  1.5E+0038, 0, ER.commission);
    esFieldOptionsOff(efRightJustify);

  {idfedTax:}
    esFieldOptionsOn(efRightJustify);
    AddRealField(
      'federal income tax:', 18, 5,
      '99,999.99', 18, 25,
      hifedTax, -1.5E+0038,  1.5E+0038, 0, ER.fedTax);
    esFieldOptionsOff(efRightJustify);

  {idstateTax:}
    esFieldOptionsOn(efRightJustify);
    AddRealField(
      'state income tax:', 19, 7,
      '99,999.99', 19, 25,
      histateTax, -1.5E+0038,  1.5E+0038, 0, ER.stateTax);
    esFieldOptionsOff(efRightJustify);

  {idficaTax:}
    esFieldOptionsOn(efRightJustify);
    AddRealField(
      'social security:', 20, 8,
      '99,999.99', 20, 25,
      hificaTax, -1.5E+0038,  1.5E+0038, 0, ER.ficaTax);
    esFieldOptionsOff(efRightJustify);

    InitEntryScreen := RawError;
  end;

end;

procedure FillScreen(var EmpMastFile : MasterFile; EN : integer);
var
  EP : EmployeePtr;
  Finished : boolean;
begin
  Finished := False;
  EP := EmpMastFile.ReadFirst;
  while Finished = False do
    begin
      if EP = nil then
        Finished := True
      else
        if EP^.EmpNum = EN then
          begin
            ER.number := EN;
            ER.name := EP^.EmpName;
            ER.address := EP^.EmpAddr;
            ER.city := EP^.EmpCity;
            ER.state := EP^.EmpState;
            ER.zip := EP^.EmpZip;
            ER.phone := EP^.EmpPhone;
            ER.title := EP^.EmpTitle;
            ER.salary := EP^.Salary;
            ER.regRate := EP^.RegRate;
            ER.otRate := EP^.OtRate;
            ER.regHours := EP^.RegHours;
            ER.otHours := EP^.OtHours;
            ER.commission := EP^.Commission;
            ER.fedTax := EP^.FedTax;
            ER.stateTax := EP^.StateTax;
            ER.ficaTax := EP^.FicaTax;
            ES.ResetScreen;
            Finished := True;
          end
        else
          EP := EmpMastFile.ReadNext;
    end; {while}
end;

procedure ShowPerScr;
begin

  {$IFDEF UseMouse}
  if MouseInstalled then
    with EsColors do begin
      {activate mouse cursor}
      SoftMouseCursor($0000, (ColorMono(MouseColor, MouseMono) shl 8)+
                             Byte(MouseChar));
      ShowMouse;
      {enable mouse support}
      EntryCommands.cpOptionsOn(cpEnableMouse);
    end;
  {$ENDIF}

  {initialize entry screen}
  Status := InitEntryScreen;
  if Status <> 0 then begin
    WriteLn('Error initializing entry screen: ', Status);
    Halt(1);
  end;

  {initialize user record}
  FillChar(ER, SizeOf(ER), 0);

end;

procedure GetData(var EmpMastFile : MasterFile);
begin

  AcceptIt := False;
  Finished := False;
  repeat
    ES.Process;
    case ES.GetLastCommand of
      ccDone :                         { ctrl-Enter }
        begin
          AcceptIt := True;
          Finished := True;
        end;
      ccQuit :                         { esc }
        begin
          Finished := True;
        end;
      ccError :
        begin
          Writeln('Fatal error ', ES.GetLastError);
          Finished := True;
        end;
    end;
  until Finished;

  ES.Erase;

  {show exit command}
  WriteLn('Exit command = ', ES.GetLastCommand);
  ES.Done;

  {$IFDEF UseMouse}
  HideMouse;
  {$ENDIF}

end;

procedure ShowAddScr(var EmpMastFile : MasterFile);
begin
  ShowPerScr;
  GetData(EmpMastFile);
  if AcceptIt = True then
    EmpMastFile.Write(ER);
end;

procedure ShowChgScr(var EmpMastFile : MasterFile; EN : integer);
begin
  ShowPerScr;
  FillScreen(EmpMastFile, EN);
  GetData(EmpMastFile);
  if AcceptIt = True then
    EmpMastFile.Replace(ER);
end;

end.
