{ PTypes.pas      --Defines the Point, Rect types
                  --these types are used in the Chart program.
                  --Written by Zack Urlocker
                    Copyright 1990, The Whitewater Group.
                    All rights reserved.
                  --mzu 06/01/90
}

unit PTypes;

interface

uses
   Graph;

type

Point = object              { A point has x, y Object fields }
{ Object fields }
  X : Integer;
  Y : Integer;
{ Procedures and functions }
  constructor Init(i, j : Integer);
  function getX : Integer;
  function getY : Integer;
  procedure SetX(i : Integer);
  procedure SetY(i : Integer);
end;  { Point }


Rect = object               { A rectangle has two points }
{ Object fields }
  UpLeft : Point;
  LowRight : Point;
{ Procedures and functions }
  constructor Init(l, t, r, b : Integer);
  procedure SetLoc(l, t, r, b : Integer);
  procedure Draw;
  function Empty : Boolean;
  function Left : Integer;
  function Top : Integer;
  function Right : Integer;
  function Bottom : Integer;
  function Width : Integer;
  function Height : Integer;
end; { Rect }


implementation

{ ********** Point ********* }

constructor Point.Init(i, j : Integer);
 begin
  X := i;
  Y := j;
end;

function Point.GetX : Integer;
begin
  GetX := X;
end;

function Point.GetY : Integer;
begin
  GetY := Y;
end;

procedure Point.SetX(i : Integer);
begin
  X := i;
end;

procedure Point.SetY(i : Integer);
begin
  Y := i;
end;


{ ********** Rect ********* }


constructor Rect.Init(l, t, r, b : Integer);
begin
  UpLeft.Init(l, t);
  LowRight.Init(r, b);
end;


procedure Rect.SetLoc(l, t, r, b : Integer);
begin
  UpLeft.Init(l, t);
  LowRight.Init(r, b);
end;

procedure Rect.Draw;
begin
  rectangle(Left, Top, Right, Bottom);
end;

function Rect.Empty : Boolean;
begin
  Empty := (Left = 0) and (Right = 0)
       and (Top = 0)  and (Bottom = 0);
end;


function Rect.Left : Integer;
begin
  Left := UpLeft.GetX;
end;

function Rect.Top : Integer;
begin
  Top := UpLeft.GetY;
end;

function Rect.Right : Integer;
begin
  Right := LowRight.GetX;
end;

function Rect.Bottom : Integer;
begin
  Bottom := LowRight.GetY;
end;

function Rect.Width : Integer;
begin
  Width := abs(self.Right - self.Left);
end;

function Rect.Height : Integer;
begin
  Height := abs(self.Top - self.Bottom);
end;


{ no initialization }

end.
