                   CHAPTER 2 - Getting started in Pascal


                         YOUR FIRST PASCAL PROGRAM

            Lets  get right into a program that really does  nothing 
        but  is an example of the most trivial Pascal program.  Load 
        Turbo  Pascal,  select TRIVIAL as a Work  file,  and  select 
        Edit. This assumes that you have been successful in learning 
        how to use the TURBO Pascal system.

            You  should  now  have the most trivial  Pascal  program 
        possible  on your display,  and we can take a look  at  each 
        part to define what it does.

            The  first  line  is  required in  the  standard  Pascal 
        definition and is the program name which can be any name you 
        like,  as  long  as it follows the rules for  an  identifier 
        given  in  the  next  paragraph.  It  can  have  no  blanks, 
        otherwise  it would be considered as two words and it  would 
        confuse the compiler. The first word PROGRAM is the first of 
        the reserved words mentioned earlier and it is the indicator 
        to the Pascal compiler that this is the name of the program. 
        Notice that the line ends with a semicolon.  Pascal uses the 
        semicolon  as  the  statement  separator  and  although  all 
        statements do not actually end in a semicolon,  most do, and 
        use of the semicolon will clear up later in your mind. TURBO 
        Pascal does not require the PROGRAM statement, but to remain 
        compatible with standard Pascal,  it will simply ignore  the 
        entire  statement.  I like to include a program name both to 
        keep  me thinking in standard Pascal,  and to add  a  little 
        more indication of the purpose of each program.

                          WHAT IS AN IDENTIFIER?

            All identifiers,  including program name,  procedure and 
        function names,  type definitions, and constant and variable 
        names,  will  start  with an alphabetical character  and  be 
        composed  of  any  combination  of  alphabetic  and  numeric 
        characters  with  no embedded blanks.  Upper or  lower  case 
        alphabetic  characters are not significant and may be  mixed 
        at  will.  (If  you find this definition confusing  at  this 
        point,  don't worry about it,  it will be clear later but it 
        must  be defined early).  The standard definition of  Pascal 
        requires that any implementation (i.e.  any compiler written 
        by  some  company)  must use at least 8  characters  of  the 
        identifier  as  significant  and may  ignore  the  remaining 
        characters  if more are used.  Most implementations use  far 
        more  than 8.  TURBO Pascal uses up to 127 characters in  an 
        identifier  as  being significant.  Since nearly all  Pascal 
        compilers use the underline as an allowable character in  an 
        identifier, it will be freely used throughout this tutorial. 
        The  underline is used in the program name "puppy_dog" which 
        should be on your display at this time.


                                 Page 6









                   CHAPTER 2 - Getting started in Pascal



            Returning  to the example program,  the next line  is  a 
        blank  line which is ignored by all Pascal  compilers.  More 
        will be said about that at the end of this chapter.

                            NOW FOR THE PROGRAM

            The  next two lines comprise the actual Pascal  program, 
        which  in  this  case  does absolutely  nothing.  It  is  an 
        illustration  of the minimum Pascal program.  The two  words 
        BEGIN  and  END  are the next two  reserved  words  we  will 
        consider.  Any  logical  grouping  of  Pascal  code  can  be 
        isolated  by bracketing it with the two reserved words BEGIN 
        and END. You will use this construct repeatedly as you write 
        Pascal code so it is well to learn it thoroughly. Code to be 
        executed by conditional jumps will be bracketed by BEGIN and 
        END, as will code within a loop, and code contained within a 
        subroutine (although they are called PROCEDURES in  Pascal), 
        and  in many other ways.  In the present program,  the BEGIN 
        and  END  are  used to bracket the main  program  and  every 
        Pascal  program will have the main program bracketed by  the 
        BEGIN  and END statement.  Since there is nothing to  do  in 
        this program, there are no statements.

            Finally,  although  it could be very easily  overlooked, 
        there  is one more very important part of the  program,  the 
        period  following  END.  The  period is the  signal  to  the 
        compiler  that  it  has reached the end  of  the  executable 
        statements and is therefore finished compiling. Every Pascal 
        program  will have one,  and only one period in it and  that 
        one period will be at the end of the program. I must qualify 
        that  statement  in  this regard,  a period can be  used  in 
        comments,  and in text to be output.  In fact there are some 
        data  formats that require using a period as part  of  their 
        structure.  The statement is true however that there is only 
        one period in the executable part of a Pascal program. Think 
        of  a Pascal program as one long sentence with one period at 
        the end.

            That should pretty well describe our first program.  Now 
        it is time to compile and run it. To do so you must exit the 
        editor,   using  Ctrl-K-D,  unless  you  modified  the  exit 
        command.  Then compile the program,  and finally run it  and 
        observe the result.

            Since  that  program  didn't do much,  it was  not  very 
        interesting, so let's get one that does something.






                                 Page 7









                   CHAPTER 2 - Getting started in Pascal


                       A PROGRAM THAT DOES SOMETHING

            Load the Pascal program WRITESM and edit it.   The  name 
        is  sort  of  cryptic for "Write Some" and it  will  give  a 
        little   output  to  the  monitor.   The  program  name   is 
        "kitty_cat"  which says nothing about the program itself but 
        is  any identifier we choose to make it.  We still have  the 
        BEGIN  and END to define the main program area  followed  by 
        the period.  However,  now we have two additional statements 
        between the BEGIN and END.  WRITELN is another reserved word 
        and  it is probably not surprising that it means to write  a 
        line of data somewhere. Without a modifier, (to be explained 
        in due time),  it will write to the default device which, in 
        the  case of our IBM compatible,  is the video display.  The 
        data within the parentheses is the data to be output to  the 
        display and although there are many possibilities of display 
        information,  we will restrict ourselves to the simplest for 
        the time being.  Any data between apostrophes will simply be 
        output as text information.

            Notice  the semicolon at the end of each line.  This  is 
        the statement separator referred to earlier and tells Pascal 
        that  this  line is complete as it stands,  nothing more  is 
        coming that could be considered part of this statement. This 
        program will output the two lines of text and stop.  Now  it 
        is time to go try it.  Exit the editor, then compile and run 
        the program.

            You  should  now get the two lines output to  the  video 
        display  every  time  you run it.  When you  grow  bored  of 
        running WRITESM lets go on to another example.

                     ANOTHER PROGRAM WITH MORE OUTPUT

            Load and edit WRITEMR.  This new program has three lines 
        of  output  but the first two are different because  another 
        reserved  word  is introduced to  us,  namely  WRITE.  WRITE 
        causes  the text to be output in exactly the same manner  as 
        WRITELN, but WRITE does not cause a carriage return. WRITELN 
        causes its output to take place then returns the  "carriage" 
        to  the first character of the next line.  The end result is 
        that all three of the lines will be output on the same  line 
        when the program is run. Notice that there is a blank at the 
        end  of  each of the first two lines so that the  formatting 
        will look nice. Exit the editor now and try the new program.

            It is time to confess to a little lie. WRITELN and WRITE 
        are   not  actually  reserved  words,   they  are   actually 
        predefined  functions which we have not discussed  yet.  For 
        the time being,  it is easiest to think of them as  reserved 



                                 Page 8









                   CHAPTER 2 - Getting started in Pascal


        words.  When  we get to the proper point,  we will  redefine 
        them properly.

            Now  might be a good time for you to go back to  editing 
        WRITEMR and add a few more output commands to see if they do 
        what  you think they should do.  When you tire of  that,  we 
        will  go on to the next file and learn about comments within 
        your Pascal program.

                      ADDING COMMENTS IN THE PROGRAM

            The  file named PASCOMS is similar to the others  except 
        that  comments  have  been added to  illustrate  their  use. 
        Pascal  defines  comments as anything between (* and  *)  or 
        anything  between  {  and  }.  Originally  only  the  wiggly 
        brackets  were defined but since many keyboards didn't  have 
        them available, the parenthesis star combination was defined 
        as an extension and is probably universal by now, so you can 
        use either. Most of the comments are self explanatory except 
        for the one within the code. Since comments can go from line 
        to line, the two lines that would print "send money" are not 
        Pascal code but are commented out. Try compiling and running 
        this  program,  then  edit the comments out  so  that  "send 
        money" is printed also.

            When  you have successfully modified and run the program 
        with  comments,  we  will go on to explain  good  formatting 
        practice  and  how  Pascal actually  searches  through  your 
        source file (Pascal program) for its executable statements.

                         GOOD FORMATTING PRACTICE

            Edit  GOODFORM now to see an example of good  formatting 
        style.  It  is important to note that Pascal doesn't give  a 
        hoot  where you put carriage returns or how many blanks  you 
        put  in when a blank is called for as  a  delimiter.  Pascal 
        only  uses  the  combination of reserved words  and  end-of-
        statement  semicolons to determine the logical structure  of 
        the  program.   Since  we  have  really  only  covered   two 
        executable  statements,  I  have used them to build  a  nice 
        looking  program that can be easily understood at a  glance. 
        Compile and run this program to see that it really does what 
        you think it should do. 

                       VERY POOR FORMATTING PRACTICE

            Edit   UGLYFORM  now  to  see  an  example  of  terrible 
        formatting style.  It is not really apparent at a glance but 
        the  program you are looking at is exactly the same  program 
        as the last one. Pascal doesn't care which one you ask it to 
        run because to Pascal,  they are identical.  To you they are 


                                 Page 9









                   CHAPTER 2 - Getting started in Pascal


        considerably different,  and the second one would be a  mess 
        to try to modify or maintain sometime in the future.

            UGLYFORM  should be a good indication to you that Pascal 
        doesn't  care about programming style or form.  Pascal  only 
        cares  about  the structure,  including reserved  words  and 
        delimiters such as blanks and semicolons.  Carriage  returns 
        are  completely  ignored as are extra blanks.  You  can  put 
        extra blanks nearly anywhere except within reserved words or 
        variable  names.  You  should pay attention  to  programming 
        style  but don't get too worried about it yet.  As time goes 
        by you will develop a style of statement indentation, adding 
        blank  lines  for clarity,  and clear commenting  of  Pascal 
        source  code.  Programs  are available to read  your  source 
        code,  and  put  it in a "pretty" format,  but that  is  not 
        important now.

            Not only is the form of the program important, the names 
        used  for variables can be very helpful or hindering  as  we 
        can see in the next chapter. Feel free to move things around 
        and modify the format of any of the programs we have covered 
        so far and when you are ready, we will start on variables in 
        the next chapter.

             Be sure you compile and run UGLYFORM.

                           PROGRAMMING EXERCISES

        1.  Write  a  program that displays your name on  the  video 
            monitor. 

        2.  Modify  your program to display your name and address on 
            one  line,  then  modify it by changing the  WRITE's  to 
            WRITELN's so that the name and address are on  different 
            lines.


















                                 Page 10

