           CHAPTER 4 - The Pascal loops and control structures


            Every program we have examined to this point has been  a 
        simple  one pass through with no statements being  repeated.  
        As in all other languages, Pascal has extensive capabilities 
        to  do looping and conditional branching.   We will look  at 
        these now.

                               THE FOR LOOP

            We  will start with what may be the easiest structure to 
        understand,  the FOR loop.   This is used to repeat a single 
        Pascal  statement  any  number of  times  we  desire.   Load 
        LOOPDEMO and we will discuss the loops presented there. 

            The first example is the simplest and is simply a repeat 
        of  a WRITELN 7 times.   We have three new  reserved  words, 
        FOR,  TO,  and  DO  which  are used as  shown.   Any  simple 
        variable of type INTEGER,  BYTE, or CHAR can be used for the 
        loop  index  and  it must be defined  in  a  VAR  statement.  
        Following   the  DO  reserved  word  is  any  single  Pascal 
        statement  that  will be repeated the  specified  number  of 
        times.   Note  that  the  loop is an incrementing  loop  but 
        substitution  of DOWNTO for TO will make it  a  decrementing 
        loop as is illustrated in the last example in this program.

                        A COMPOUND PASCAL STATEMENT

            The  second  example contains our first compound  Pascal 
        statement.  It was mentioned in Chapter 1 that the BEGIN END 
        pair of reserved words could be used to mark the limits of a 
        compound  statement.   In this case,  the  single  statement 
        starting  with the BEGIN and extending through and including 
        the  END statement is the single Pascal statement that  will 
        be  executed 10 times.   A second variable "total" has  been 
        introduced to simply add another operation to the loop.  Any 
        valid Pascal operation can be performed within the BEGIN END 
        pair, including another loop, thus resulting in nested loops 
        to whatever depth you desire. 

            The  third example shows how the CHAR variable could  be 
        used in a FOR loop.  Pascal requires that the loop variable, 
        the starting point,  and the ending point all be of the same 
        type or it will generate an error message.

            The  fourth example is a decrementing loop as  mentioned 
        earlier.

                             THE IF STATEMENT

            Now   we   will  look  at  the   conditional   branching 
        capability, or at least one of them, the IF statement.  Load 
        IFDEMO for an onscreen look at the IF THEN pair of  reserved 


                                Page 15









           CHAPTER 4 - The Pascal loops and control structures


        words.   Any  condition  that  can be reduced to  a  boolean 
        answer  is put between the IF THEN pair of  words.   If  the 
        resulting  expression resolves to TRUE,  then the  following 
        single  Pascal statement is executed,  and if it resolves to 
        FALSE,  then the following single statement is skipped over.  
        Of course,  you can probably guess that the single statement 
        can  be replaced with a compound statement bracketed with  a 
        BEGIN END pair and you are correct.  Study example 1 and you 
        will  see  that  the line will always  be  printed  in  this 
        particular fragment.  It is very difficult to come up with a 
        good   example   without  combining  some  of  the   control 
        structures which we will do in the next file.

            The second example is similar to the first but with  the 
        single  statement  replaced  with a compound  statement  and 
        should be easy to understand.

            The  third example contains a new reserved  word,  ELSE.  
        When  the  IF condition is FALSE,  the single  statement  is 
        skipped and if a semicolon is encountered,  the IF clause is 
        totally complete.   If instead of a semicolon,  the reserved 
        word ELSE is encountered,  then the single Pascal  statement 
        following ELSE is executed.   One and only one of the single 
        statements  will be executed every time the IF statement  is 
        encountered  in  the  program.   Examination  of  the  third 
        example should clear this up in your mind.

                         THE IF-THEN-ELSE "block"

            Put  on your thinking cap because the next principle  is 
        difficult  to grasp at first but will suddenly clear up  and 
        be  one  of  the most useful facts  of  Pascal  programming.  
        Since  the  entire IF THEN ELSE "block" of code is itself  a 
        single  Pascal  statement,  by definition,  it can  be  used 
        anywhere that an executable statement is legal without BEGIN 
        END separators.   This is shown in the fourth example of the 
        IFDEMO Pascal example program.   The IF THEN ELSE  construct 
        is  one of the most used,  most useful,  and therefore  most 
        important  aspects  of PASCAL.   For this reason you  should 
        become very familiar with it.

            Try  changing  some  of the conditions  in  the  example 
        program to see if you can get it to print when you expect it 
        to just for your own practice and enjoyment.   When you  are 
        ready, we will go on to a program with loops and conditional 
        statements.

                          LOOPS AND IFS TOGETHER

            Load  LOOPIF  and  observe it for  a  few  minutes.   It 
        contains  most of what you have studied so far and should be 


                                Page 16









           CHAPTER 4 - The Pascal loops and control structures


        understandable  to you at this point.   It contains  a  loop 
        with  two IF statements within it,  and another loop  within 
        one of the IF statements.

            An easily made error should be pointed out at this time.  
        If an extraneous semicolon were put at the end of the second 
        IF statement,  the code following the statement would always 
        be  executed  because  the  "null"  statement  (the  nothing 
        statement  between the THEN and the semicolon) would be  the 
        conditional  statement.   The compiler would not generate an 
        error and you would get no warning.   Add a semicolon  after 
        the IF statement to see the error.

                       FINALLY, A MEANINGFUL PROGRAM

            Load  TEMPCONV and study its structure.   Run it and you 
        will  have  a list of Centigrade to  Fahrenheit  temperature 
        conversions with a few added notes.   Load, examine, and run 
        DUMBCONV  for a good example of poor variable  naming.   The 
        structure  of the program is identical to the  last  program 
        and  when you run it,  you will see that it is identical  in 
        output,  but  it is difficult to understand what it does  by 
        studying the listing.   These programs should both be easily 
        understood  by  you  by now,  so we will go on to  our  next 
        Pascal control structure.

                           THE REPEAT UNTIL LOOP

            The next two Pascal structures are very similar  because 
        they  are both indefinite loops (indefinite because they are 
        not executed a fixed number of times).   One of the loops is 
        evaluated at the top and the other at the bottom.   It  will 
        probably  be easier to start with the REPEAT UNTIL structure 
        which is the loop that is evaluated at the bottom.

            Retrieve  the file REPEATLP to see a repeat  loop.   Two 
        more  reserved  words are defined here,  namely  REPEAT  and 
        UNTIL.   This  rather  simple construct simply  repeats  all 
        statements between the two reserved words until the  boolean 
        expression following the UNTIL is found to be TRUE.  This is 
        the  only  expression I know of that operates on a range  of 
        statements  rather  than a single statement  and  BEGIN  END 
        delimiters are not required.   A word of caution is in order 
        here.   Since  the  loop  is executed until  some  condition 
        becomes TRUE,  it is possible that the condition will  never 
        be TRUE and the loop will never terminate.

                              THE WHILE LOOP

            The  file  WHILELP  contains an example of  another  new 
        construct,  the WHILE loop.  This uses the WHILE DO reserved 


                                Page 17









           CHAPTER 4 - The Pascal loops and control structures


        words and will execute one Pascal statement (or one compound 
        statement  bounded  with BEGIN END) continuously  until  the 
        boolean  expression  between the two  words  becomes  FALSE.  
        This  loop is also indeterminate and could,  like the REPEAT 
        UNTIL,  never terminate.  You should therefore exercise care 
        in using it. 

                            THE CASE STATEMENT

            The  final  control  structure  introduces  yet  another 
        reserved word,  CASE.  The CASE construct actually should be 
        included  with  the IF statement since it is  a  conditional 
        execution statement, but I chose to save it for last because 
        it is rather unusual and will probably be used less than the 
        others we have discussed in this chapter.

            The  CASE  statement  is  used to  select  one  of  many 
        possible  simple Pascal statements to execute based  on  the 
        value  of  a simple variable.   Load the file  CASEDEMO  and 
        observe the program for an example of a case statement.  The 
        variable  between  the  CASE and OF reserved  words  is  the 
        variable  used to make the selection.   Following that,  the 
        various selections are given in the form of a possible value 
        or  range,  a  colon,  a  single  Pascal  statement,  and  a 
        semicolon.  Following the list of selections, an ELSE can be 
        added  to cover the possibility that none of the  selections 
        were  executed.   Finally,  an  END;  statement is  used  to 
        terminate the case construct.   Note that this is one of the 
        few  places  in  Pascal  that  an  END  is  used  without  a 
        corresponding BEGIN.

            The example file uses "count" for a variable and  prints 
        the numbers one through five in text form, and declares that 
        numbers  outside  this range are not in the allowable  list.  
        The  program should be self explanatory beyond  that  point.  
        This  is  admittedly  a very brief explanation of  the  CASE 
        statement  but  you will have no trouble using it  when  you 
        have need for it.  You can study it in detail at that time.

            This brings us to the end of chapter 4 and you now  have 
        enough  information to write essentially any program desired 
        in  Pascal.   There  would  be a  few  difficulties  if  you 
        attempted  to  try  to program without  the  further  topics 
        coming up in the next chapters.   The additional topics will 
        greatly  add  to the flexibility of Pascal and will  greatly 
        ease programming in it.







                                Page 18









           CHAPTER 4 - The Pascal loops and control structures


                           PROGRAMMING EXERCISES

        1.  Write a program that lists the numbers from 1 to 12  and 
            writes a special message beside the number  representing 
            your month of birth.

        2.  Write  a program that lists all of the numbers from 1 to 
            12 except for the numbers 2 and 9.













































                                Page 19

