            CHAPTER 6 - Arrays, types, constants, and labels


                                  ARRAYS

            Having covered nearly all of the programming statements, 
        we  must  now  go  back and fill in some gaps  in  our  data 
        definition.

           One  of  the most useful data structures  is  the  ARRAY, 
        which is,  in the simplest terms,  a group of many identical 
        terms.   Lets go directly to an example to see what an array 
        looks  like.   Edit the Pascal program ARRAYS and notice the 
        third  line  starting  with  the  word  "automobiles".   The 
        variable "automobiles" is defined as an integer variable but 
        in addition,  it is defined to have twelve different integer 
        variables,    namely    "automobile[1]",    "automobile[2]", 
        "automobile[3]", .. "automobile[12]".  The square braces are 
        used in Pascal to denote a subscript for an array  variable.  
        The  array  definition  given  in line  3  is  the  standard 
        definition for an array,  namely a variable name followed by 
        a  colon and the reserved word ARRAY,  with the range of the 
        array given in square brackets followed by another  reserved 
        word OF and finally the type of variable.

            In using the elements of the array in a program, each of 
        the elements of the array are required to be used in exactly 
        the same manner as any simple variable having the same type.  
        Each  time  one of the variables is used,  it must have  the 
        subscript  since the subscript is now part of  the  variable 
        name.   The subscript moreover,  must be of the type used in 
        the definition and it must be within the range defined or it 
        will be listed as an error.

            Now  consider the program itself.   As "index" is varied 
        from 1 to 12, the range of the variable "automobile", the 12 
        variables  are set to the series of values 11  to  22.   Any 
        integer values could be used, this was only a convenient way 
        to set the values to some numbers.   With the values stored, 
        a  header  is  now printed and finally the  list  of  values 
        contained in the array.   Note carefully that,  although the 
        subscripts are limited to 1 through 12, the values stored in 
        each  of  the 12 variables are limited only by the range  of 
        integers,  namely -32768 to 32767.  Review this material and 
        this program as long as needed to fully understand it, as it 
        is very important.

                           DOUBLY INDEXED ARRAYS

            After understanding the above,  load the program ARRAYS2 
        to see the next level of complexity of arrays.  You will see 
        that "checkerboard" is defined as an array from 1 to 8,  but 
        instead of it being a simple data type, it is itself another 
        array from 1 to 8 of INTEGER.   The variable  "checkerboard" 


                                Page 27









            CHAPTER 6 - Arrays, types, constants, and labels


        is  actually  composed  of 8 elements,  each of which  is  8 
        elements,  leading to a total of 64 elements,  each of which 
        is  a  simple INTEGER variable.   This is  called  a  doubly 
        subscripted  array  and it can be envisioned in exactly  the 
        same  manner  as a real checker board,  an 8  by  8  matrix.  
        Another  way to achieve the same end is to define the double 
        array  as in the next line of the program where  "value"  is 
        defined as a total of 64 elements.

            To use either of the two variables in a program, we must 
        add  two subscripts to the variable name to tell the program 
        which  element of the 64 we desire to  use.   Examining  the 
        program will reveal two loops,  one nested within the other, 
        and both ranging in value from 1 to 8.  The two loop indices 
        can  therefore  be used as subscripts of the  defined  array 
        variables.   The  variable "checkerboard" is subscripted  by 
        both  of  the loop indices and each of the 64  variables  is 
        assigned a value as a function of the indices.  The assigned 
        value  has  no real meaning other than to illustrate to  you 
        how  it is done.   Since the value of "checkerboard" is  now 
        available,  it is used to define some values to be used  for 
        the variable "value".

            After  defining all of those variables,  and you  should 
        understand  that we have defined a total of 128 variables in 
        the double loop,  they can be printed out.  The next section 
        of  the  program does just that,  by  using  another  doubly 
        nested  loop,  with a WRITE statement in the  center.   Each 
        time  we  go  through the center of the loop we tell  it  to 
        print  out  one of the 64 variables  in  the  "checkerboard" 
        matrix  with the indices "index" and "count" defining  which 
        of  the variables to write each time.   Careful study of the 
        loop should reveal its exact operation.

            After  printing out the matrix defined by  the  variable 
        "checkerboard"  we  still  have the matrix  defined  by  the 
        variable  "value"  intact  (In fact,  we still have  all  of 
        "checkerboard"  available because we haven't changed any  of 
        it).   Before  printing out the matrix defined  by  "value", 
        let's  change  a few of the elements just to see how  it  is 
        done.   The  next  three  lines simply change three  of  the 
        variables  to illustrate that you can operate on all of  the 
        matrix  in  loops,  or on any part of the matrix  in  simple 
        assignment statements.  Notice especially the third line, in 
        which  "value[3,6]" (which was just set to the value of  3), 
        is used as a subscript.  This is perfectly legal since it is 
        defined as a simple integer variable and is within the range 
        of 1 to 8,  which is the requirement for a subscript of  the 
        variable  "value".   The  last  part of the  program  simply 
        prints  out  the 64 values of the variable "value"   in  the 



                                Page 28









            CHAPTER 6 - Arrays, types, constants, and labels


        same manner as above.  Notice that when you run the program, 
        the three values are in fact changed as expected.

                            ARRAYS ARE FLEXIBLE

            A  few  more words about arrays before we  go  on.   The 
        arrays  in the last program were both defined to be  square, 
        namely  8 by 8 but that choice was  purely  arbitrary.   The 
        subscripts were chosen to go from 1 to 8 but they could have 
        been  chosen to go from 101 to 108 or any other range needed 
        to clearly define the problem at hand.  And, as you may have 
        guessed,  you are not limited to a doubly subscripted matrix 
        but you can define a variable with as many subscripts as you 
        need  to  achieve your desired end.   There is  a  practical 
        limit  to  the  number of subscripts because  you  can  very 
        quickly  use up all of your available memory with one  large 
        subscripted variable.

                            THE TYPE DEFINITION

            Now  that  you understand arrays,  lets look at  a  more 
        convenient  way to define them by examining the Pascal  file 
        TYPES.   You  will notice a new section at the beginning  of 
        the listing with the heading TYPE.  TYPE is another reserved 
        word  which  is used at the beginning of a section  used  to 
        define  "user-defined  types".   Beginning with  the  simple 
        predefined TYPES we studied earlier, we can build up as many 
        new  types  as  we need and they can be  as  complex  as  we 
        desire.   The  six names (from "array_def" to "boat") in the 
        TYPE section are not variables,  but are defined to be TYPES 
        and  can be used in the same manner as  can  INTEGER,  BYTE, 
        REAL, etc.

            This  is a very difficult concept,  but a very important 
        one.   The Pascal compiler is very picky about the  variable 
        types  you  use in the program,  doing lots of  checking  to 
        insure  that  you do not use the wrong type anywhere in  the 
        program.   Because  it is picky,  you could do  very  little 
        without  the  ability to define new types when  needed,  and 
        that is the reason that you can define new types to solve  a 
        particular problem.

            Some of these types are used in the VAR declaration part 
        of the program.  Notice that since "airplane" is an array of 
        "dog_food"  and  "dog_food" is in turn an array of  BOOLEAN, 
        then  "airplane" defines a doubly  subscripted  array,  each 
        element being a boolean variable.   This does not define any 
        variables, only a TYPE, which can be used in a VAR to define 
        a matrix of boolean variables.   This is in fact done in the 
        definition of "puppies", which is an array composed of 72 (6 
        times 12) boolean variables.  In the same manner, "stuff" is 


                                Page 29









            CHAPTER 6 - Arrays, types, constants, and labels


        composed of an array of 14 variables,  each being an integer 
        variable.   The  elements  of the  array  are,  "stuff[12]", 
        "stuff[13]",  ..  "stuff[25]".  Notice also that "stuff2" is 
        also defined in exactly the same manner and is also composed 
        of 14 variables.

            Careful  inspection  will  reveal that  "kitties"  is  a 
        variable  which  has the same definition as  "puppies".   It 
        would  probably be poor programming practice to define  them 
        in  different  manners  unless they  were  in  fact  totally 
        disassociated.   In  this  example  program,  it  serves  to 
        illustrate  some  of  the  ways user-defined  types  can  be 
        defined.

            In  a tiny program like this example,  the value of  the 
        TYPE declaration part cannot be appreciated,  but in a large 
        program  with many variables,  the TYPE declaration  can  be 
        used to great advantage.  This will be illustrated later.

                         THE CONSTANT DECLARATION

            Examining  the Pascal example program CONSTANT will give 
        us an example of a constant definition.   The reserved  word 
        CONST is the beginning of the section that is used to define 
        constants  that can be used anyplace in the program as  long 
        as  they  are  consistent  with  the  required  data  typing 
        limitations.   In  this example,  "max_size" is defined as a 
        constant  with the value of 12.  This is not a variable  and 
        cannot  be  changed  in the program,  but is  still  a  very 
        valuable  number.   For  the  moment  ignore  the  next  two 
        constant definitions.   As we inspect the TYPE declarations, 
        we see two user-defined types,  both of which are arrays  of 
        size  1 to 12 since "max_size" is defined as 12.   Then when 
        we get to the VAR declaration part,  we find five  different 
        variables,  all  defined  as arrays from 1 to 12  (some  are 
        INTEGER and some are CHAR).   When we come to the program we 
        find  that  it is one big loop which we go through 12  times 
        because the loop is executed "max_size" times.

            In the above definition,  there seems to be no advantage 
        to  using the constant,  and there is none,  until you  find 
        that  for some reason you wish to increase the range of  all 
        arrays from 12 to 18.   In order to do so,  you only need to 
        redefine the value of the constant, recompile, and the whole 
        job  is done.   Without the constant definition,  you  would 
        have had to change all TYPE declarations and the upper limit 
        of the loop in the program.  Of course that would not be too 
        bad in the small example program,  but could be a real  mess 
        in  a 2000 line program,  especially if you missed  changing 
        one  of the 12's to an 18.   That would be a good example of 
        data in and garbage out.   That should give you a good  idea 


                                Page 30









            CHAPTER 6 - Arrays, types, constants, and labels


        of  what  the constant can be used for,  and as you  develop 
        good  programming  techniques,  you will  use  the  constant 
        declaration to your advantage.

                      THE TURBO PASCAL TYPED CONSTANT

            We   skipped   over  the  second  and   third   constant 
        declaration  for a very good reason,  they are not  constant 
        declarations.   TURBO  Pascal has defined,  as an extension, 
        the "typed constant".  Using the syntax shown, "index_start" 
        is defined as an INTEGER variable and is initialized to  the 
        value  of  49.   This is a true variable and can be used  as 
        such  in the program.   The same effect can be  achieved  by 
        simply  defining  "index_start"  as an INTEGER  in  the  VAR 
        declaration  part  and setting it to the value of 49 in  the 
        program itself.  Since it does not really fit the definition 
        of  a  constant,  it's  use is discouraged  until  you  gain 
        experience  as  a Pascal programmer.   Until  then  it  will 
        probably  only  be  confusing  to  you.    In  like  manner, 
        "check_it_out"  is  a  boolean variable initialized  to  the 
        value "true".  It is not a constant.

                           THE LABEL DECLARATION

            Finally,  the example program LABELS will illustrate the 
        use  of  labels.   In the Pascal definition,  a LABEL  is  a 
        number from 0 to 9999 that is used to define a point in  the 
        program  to  which  you wish to jump.   All labels  must  be 
        defined  in the LABEL definition part of the program  before 
        they can be used.   Then a new reserved word GOTO is used to 
        jump to that point in the program.   The best way to see how 
        the  GOTO  is  used with labels is to  examine  the  program 
        before you.   TURBO Pascal has an extension for labels.  Any 
        valid identifier, such as used for variables, can be used as 
        a label in addition to the values from 0 to 9999.  These are 
        illustrated in the example program.

                             THE PACKED ARRAY

            When  Pascal  was first defined in  1971,  many  of  the 
        computers in use at that time used very large words, 60 bits 
        being  a typical word size.   Memory was very expensive,  so 
        large memories were not too common.   A Pascal program  that 
        used  arrays  was inefficient because only one variable  was 
        stored  in each word.   Most of the bits in each  word  were 
        totally  wasted,  so  the PACKED ARRAY was defined in  which 
        several  variables  were stored in each  word.   This  saved 
        storage space but took extra time to unpack each word to use 
        the data.  The programmer was given a choice of using a fast 
        scheme  that wasted memory,  the ARRAY,  or a slower  scheme 
        that used memory more efficiently, the PACKED ARRAY.


                                Page 31









            CHAPTER 6 - Arrays, types, constants, and labels



            The modern microcomputer has the best of both schemes, a 
        short word, usually 16 bits, and a large memory.  The PACKED 
        ARRAY  is therefore not even implemented in  many  compilers 
        and will be ignored during compilation.


                           PROGRAMMING EXERCISES

        1.  Write  a program to store the integers 201 to 212 in  an 
            array then display them on the monitor.

        2.  Write a program to store a 10 by 10 array containing the 
            products  of  the indices,  therefore  a  multiplication 
            table. Display the matrix on the video monitor.

        3.  Modify  the program in 2 above to include a constant  so 
            that  by simply changing the constant,  the size of  the 
            matrix and the range of the table will be changed.


































                                Page 32

