                CHAPTER 8 - Scalars, subranges, and sets.


                              PASCAL SCALARS

            A scalar,  also called an enumerated type,  is a list of 
        values  which a variable of that type may assume.   Look  at 
        the  Pascal program ENTYPES for an example of some  scalars.  
        The  first  type declaration defines "days" as being a  type 
        which can take on any one of seven  values.   Since,  within 
        the  VAR declaration,  "day" is assigned the type of "days", 
        then  "day" is a variable which can assume any one of  seven 
        different values.   Moreover "day" can be assigned the value 
        "mon",  or  "tue",  etc.   This makes the program easier  to 
        follow and understand.  Internally, Pascal does not actually 
        assign the value "mon" to the variable "day", but it uses an 
        integer  representation  for each of  the  names.   This  is 
        important to understand because you need to realize that you 
        cannot print out "mon",  "tue",  etc., but can only use them 
        for indexing control statements.

            The   second   line  of  the  type  definition   defines 
        "time_of_day"  as another scalar which can have any of  four 
        different values,  namely those listed.  The variable "time" 
        can only be assigned one of four values since it is  defined 
        as  the  type "time_of_day".   It should be clear that  even 
        though   it  can  be  "morning",   it  cannot  be   assigned 
        "morning_time"  or  any other variant spelling  of  morning, 
        since  it  is simply another identifier which must  have  an 
        exact spelling to be understood by the compiler.

            Several  real  variables  are defined  to  allow  us  to 
        demonstrate the use of the scalar variables.   After writing 
        a header for our output,  the real variables are initialized 
        to  some values that are probably not real life values,  but 
        will serve to illustrate the scalar variable.

                        A BIG SCALAR VARIABLE LOOP

            The  remainder  of the program is one large  loop  being 
        controlled  by the variable "day" as it goes through all  of 
        its values,  one at a time.   Note that the loop could  have 
        gone  from  "tue" to "sat" or whatever portion of the  range 
        desired, it does not have to go through all of the values of 
        "day".  Using "day" as the case variable, the name of one of 
        the days of the week is written out each time we go  through 
        the  loop.   Another  loop controlled by "time" is  executed 
        four  times,  once for each value of "time".   The two  CASE 
        statements  within the inner loop are used to calculate  the 
        total pay rate for each time period and each day.   The data 
        is  formatted carefully to make a nice looking table of  pay 
        rates as a function of "time" and "day".




                                 Page 35









                CHAPTER 8 - Scalars, subranges, and sets.


            Take  careful  notice  of  the  fact  that  the   scalar 
        variables never entered into the calculations, and they were 
        not printed out.  They were only used to control the flow of 
        logic. It was much neater than trying to remember that "mon" 
        is represented by a 0, "tue" is represented by a 1, etc.  In 
        fact, those numbers are used for the internal representation 
        of  the scalars but we can relax and let Pascal worry  about 
        the internal representation of our scalars.

                        LETS LOOK AT SOME SUBRANGES

            Examine   the   program  SUBRANGE  for  an  example   of 
        subranges.   It  may be expedient to define  some  variables 
        that  only  cover a part of the full range as defined  in  a 
        scalar  type.   Notice that "days" is declared a scalar type 
        as in the last program,  and "work" is declared a type  with 
        an  even  more restricted range.   In the  VAR  declaration, 
        "day"  is once again defined as the days of the week and can 
        be  assigned any of the days by the program.   The  variable 
        "workday",  however,  is assigned the type "work",  and  can 
        only  be  assigned  the days "mon"  through  "fri".   If  an 
        attempt  is  made  to assign "workday" the  value  "sat",  a 
        runtime  error  will  be  generated.   A  carefully  written 
        program  will  never  attempt  that,  and  it  would  be  an 
        indication  that something is wrong with either the  program 
        or the data.   This is one of the advantages of Pascal  over 
        older languages.

            Further examination will reveal that "index" is assigned 
        the  range of integers from 1 through 12.   During execution 
        of the program,  if an attempt is made to assign "index" any 
        value  outside  of  that range,  a run time  error  will  be 
        generated.   Suppose  the variable "index" was  intended  to 
        refer  to  your  employees,  and you have only  12.   If  an 
        attempt was made to refer to employee number 27, or employee 
        number -8,  there is clearly an error somewhere in the  data 
        and  you  would want to stop running the payroll to fix  the 
        problem.  Pascal would have saved you a lot of grief.

                   SOME STATEMENTS WITH ERRORS IN THEM.

            In  order to have a program that would  compile  without 
        errors,  and  yet  show some errors,  the first part of  the 
        program  is  not really a part of the program  since  it  is 
        within a comment area.  This is a trick to remember when you 
        are debugging a program, a troublesome part can be commented 
        out  until  you are ready to include it in  the  rest.   The 
        errors are self explanatory.

            There  are  seven assignment statements as  examples  of 
        subrange  variable use.   Notice that the variable "day" can 


                                 Page 36









                CHAPTER 8 - Scalars, subranges, and sets.


        always  be  assigned  the  value  of  either  "workday"   or 
        "weekend",  but  the  reverse is not true because "day"  can 
        assume values that would be illegal for the others.

                        THREE VERY USEFUL FUNCTIONS

            The last section of the example program demonstrates the 
        use  of three very important functions when  using  scalars.  
        The  first is the "succ" function that returns the value  of 
        the successor to the scalar used as an argument, that is the 
        next value.   If the argument is the last value,  a run time 
        error  is  generated.   The  next  function  is  the  "pred" 
        function that returns the predecessor to the argument of the 
        function.   Finally  the  "ord" function which  returns  the 
        ordinal  value of the scalar.   All scalars have an internal 
        representation starting at 0 and increasing by one until the 
        end is reached.   In our example program, "ord(day)" is 5 if 
        "day"  has been assigned "sat",  but "ord(weekend)" is 0  if 
        "weekend" has been assigned "sat".   As you gain  experience 
        in programming with scalars and subranges,  you will realize 
        the value of these three functions.

            A  few more thoughts about subranges are in order before 
        we go on to another topic.   A subrange is always defined by 
        two  predefined  constants,  and  is always  defined  in  an 
        ascending order.   A variable defined as a subrange type  is 
        actually  a  variable defined with a restricted  range,  and 
        should  be  used as often as possible in  order  to  prevent 
        garbage  data.   There are actually very few variables  ever 
        used  that cannot be restricted by some amount.   The limits 
        may give a hint at what the program is doing and can help in 
        understanding  the program operation.   Subrange  types  can 
        only be constructed using the simple types,  INTEGER,  CHAR, 
        or scalar.

                                   SETS

            Now for a new topic, sets.  Examining the example Pascal 
        program  SETS will reveal some sets.   A scalar variable  is 
        defined first, in this case the scalar type named "goodies".  
        A  set  is  then  defined with the  reserved  words  SET  OF 
        followed by a predefined scalar type.  Several variables are 
        defined   as   sets  of  "treat",   after  which  they   can 
        individually be assigned portions of the entire set.

            Consider  the variable "ice_cream_cone" which  has  been 
        defined as a set of type "treat".  This variable is composed 
        of as many elements of "goodies" as we care to assign to it.  
        In   the  program,   we  define  it  as  being  composed  of 
        "ice_cream",   and  "cone".   The  set  "ice_cream_cone"  is 
        therefore composed of two elements,  and it has no numerical 


                                 Page 37









                CHAPTER 8 - Scalars, subranges, and sets.


        or   alphabetic   value  as  most  other   variables   have.  
        Continuing  in the program,  you will see 4  more  delicious 
        deserts  defined as sets of their components.   Notice  that 
        the banana split is first defined as a range of terms,  then 
        another  term is added to the group.   All five are combined 
        in  the set named "mixed",  then "mixed" is subtracted  from 
        the entire set of values to form the set of ingredients that 
        are not used in any of the deserts.  Each ingredient is then 
        checked  to see if it is IN the set of  unused  ingredients, 
        and printed out if it is.  Running the program will reveal a 
        list of unused elements.

            In this example,  better programming practice would have 
        dictated   defining   a  new   variable,   possibly   called 
        "remaining" for the ingredients unused.  It was desirable to 
        illustrate  that "mixed" could be assigned a value based  on 
        subtracting itself from the entire set, so the poor variable 
        name was used.

            This  example  resulted  in some  nonsense  results  but 
        hopefully it led your thinking toward the fact that sets can 
        be  used for inventory control,  possibly a parts allocation 
        scheme, or some other useful system.

                            SEARCHING WITH SETS

            The Pascal program FINDCHRS is more useful than the last 
        one.  In it we start with a short sentence and search it for 
        all lower case alphabetic letters and write a list of  those 
        used.  Since we are using a portion of the complete range of 
        CHAR,  we do not need to define a scalar before defining the 
        set,  we  can define the set using the range 'a'..'z'.   The 
        set  "data_set" is assigned the value of no elements in  the 
        first statement of the program,  and the print string, named 
        "print_group",  is set to blank in the next.   The  variable 
        "storage" is assigned the sentence to search, and the search 
        loop  is  begun.   Each time through the loop,  one  of  the 
        characters  is  checked.   It is either declared as  a  non-
        lower-case character,  is a repeat of one already found,  or 
        is a new one added to the list.

            You  are  left to decipher the details of  the  program, 
        which  should be no problem since there is nothing new here.  
        Run  the  program and observe how the list  grows  with  new 
        letters as the sentence is scanned.

                           PROGRAMMING EXERCISE

        1. Modify FINDCHRS to search for upper-case letters.




                                 Page 38

