{ Draw_Pcs.Pas -- Pieces drawing unit for 146-10, The Pascal Team }

{ Contains all piece drawing procedures, as well as a procedure to
  draw a blank square and the entire board (with the starting positions) }

{ Author : Mark A. Friedman }

unit
	Draw_Pcs;

interface

Uses
	Crt,Graph,Globals ;

	Procedure	Draw_Square  (xFile:char;Rank:integer) ;
	Procedure	Draw_Pawn	 (xFile:char;Rank:integer;Color:integer) ;
	Procedure	Draw_Rook	 (xFile:char;Rank:integer;Color:integer) ;
	Procedure	Draw_Knight  (xFile:char;Rank:integer;Color:integer) ;
	Procedure	Draw_Bishop  (xFile:char;Rank:integer;Color:integer) ;
	Procedure	Draw_Queen   (xFile:char;Rank:integer;Color:integer) ;
	Procedure	Draw_King	 (xFile:char;Rank:integer;Color:integer) ;

	Procedure	Draw_Board   (Game_State:Game_State_Type) ;

implementation

{ ------------------------------------------------------------- }

Procedure Draw_Square
		  (  xFile : char      ; {* file letter *}
			  Rank  : integer ) ; {* rank number *}
	{
		Draw a square, pixel by pixel onto a 30 deep by 35 wide matrix.
		The square colors are set globally by constants.
	}

Var
	Col,Row : integer ;  {* coordinates *}
	c,r     : integer ;  {* counters *}
	color   : integer ;  {* color constant *}

begin
	{* Convert input coordinates into screen coordinates *}

		Row := Convert_File(xFile) ; Col := Convert_Rank(Rank) ;

	{* Draw square *}

		If (	(xFile in ['b','d','f','h']) and
			(odd(Rank)                 ) or
		   ( (xFile in ['a','c','e','g']) and
			(odd(Rank+1)              )) )
		then
			color := White_S
		else
			color := Black_S ;

                SetLineStyle(0,0,1);
                SetColor(Color);

		For r := 1 to 29 do
                   Line(Col+1, Row+r, Col+34, Row+ r);
                color := brown;
                setcolor(brown);
                Rectangle(Col, Row, Col+35, Row+30);

	{* Draw border *}

{		For c := 0 to 34 do	PutPixel(Col+ c, Row   , brown);
		For c := 0 to 34 do	PutPixel(Col+ c, Row+30, brown);
		For r := 0 to 29 do	PutPixel(Col   , Row+ r, brown);
		For r := 0 to 29 do	PutPixel(Col+35, Row+ r, brown);
}
end; {* Draw_Square *}


{ ------------------------------------------------------------- }

Procedure Draw_Pawn

		(  XFile   : char      ; {* file letter *}
		   Rank    : integer   ; {* rank number *}
		   Color   : integer ) ; {* piece color *}
	{
		Draw a pawn, pixel by pixel onto a 30 deep by 35 wide matrix.
		The piece colors are set globally by constants.
	}

Var
	Row,Col	: integer ;  {* Upper left bounds *}
	r  ,c		: integer ;  {* counters *}

begin
	{* Convert input coordinates into screen coordinates *}

		Row := Convert_File(XFile) ; Col := Convert_Rank(Rank) ;

		SetColor(Color) ; SetLineStyle(SolidLn, 0, NormWidth) ;

		Line(Col+16, Row+ 2, Col+18, Row+ 2) ;
		Line(Col+14, Row+ 3, Col+20, Row+ 3) ;
		Line(Col+13, Row+ 4, Col+21, Row+ 4) ;
		Line(Col+12, Row+ 5, Col+22, Row+ 5) ;
		Line(Col+12, Row+ 6, Col+22, Row+ 6) ;
		Line(Col+13, Row+ 7, Col+21, Row+ 7) ;
		Line(Col+14, Row+ 8, Col+20, Row+ 8) ;
		Line(Col+15, Row+ 9, Col+19, Row+ 9) ;
		Line(Col+15, Row+10, Col+19, Row+10) ;
		Line(Col+12, Row+11, Col+22, Row+11) ;
		Line(Col+11, Row+12, Col+23, Row+12) ;
		Line(Col+12, Row+13, Col+22, Row+13) ;
		Line(Col+15, Row+14, Col+19, Row+14) ;
		Line(Col+14, Row+15, Col+20, Row+15) ;
		Line(Col+14, Row+16, Col+20, Row+16) ;
		Line(Col+14, Row+17, Col+20, Row+17) ;
		Line(Col+14, Row+18, Col+20, Row+18) ;
		Line(Col+14, Row+19, Col+20, Row+19) ;
		Line(Col+13, Row+20, Col+21, Row+20) ;
		Line(Col+13, Row+21, Col+21, Row+21) ;
		Line(Col+13, Row+22, Col+21, Row+22) ;
		Line(Col+ 5, Row+23, Col+29, Row+23) ;
		Line(Col+ 4, Row+24, Col+30, Row+24) ;
		Line(Col+ 4, Row+25, Col+30, Row+25) ;
		Line(Col+ 4, Row+26, Col+30, Row+26) ;
		Line(Col+ 5, Row+27, Col+29, Row+27) ;

end; {* Draw_Pawn *}

{ ------------------------------------------------------------- }

Procedure Draw_Rook

		(  XFile   : char      ; {* file letter *}
		   Rank    : integer   ; {* rank number *}
		   Color   : integer ) ; {* piece color *}

	{
		Draw a rook, pixel by pixel onto a 30 deep by 35 wide matrix.
		The piece colors are set globally by constants.
	}

Var
	Row,Col	: integer ;	{* Upper left bounds *}
	c  ,r 	: integer ; {* counters *}

begin
	{* Convert input coordinates into screen coordinates *}

		Row := Convert_File(XFile) ; Col := Convert_Rank(Rank) ;

	{* Draw piece *}

		SetColor(Color) ; SetLineStyle(SolidLn, 0, NormWidth) ;

		Line(Col+ 5, Row+ 2, Col+ 9, Row+ 2) ;
		Line(Col+15, Row+ 2, Col+19, Row+ 2) ;
		Line(Col+25, Row+ 2, Col+29, Row+ 2) ;
		Line(Col+ 5, Row+ 3, Col+ 9, Row+ 3) ;
		Line(Col+15, Row+ 3, Col+19, Row+ 3) ;
		Line(Col+25, Row+ 3, Col+29, Row+ 3) ;
		Line(Col+ 5, Row+ 4, Col+ 9, Row+ 4) ;
		Line(Col+15, Row+ 4, Col+19, Row+ 4) ;
		Line(Col+25, Row+ 4, Col+29, Row+ 4) ;
		Line(Col+ 5, Row+ 5, Col+ 9, Row+ 5) ;
		Line(Col+15, Row+ 5, Col+19, Row+ 5) ;
		Line(Col+25, Row+ 5, Col+29, Row+ 5) ;
		Line(Col+ 5, Row+ 6, Col+29, Row+ 6) ;
		Line(Col+ 5, Row+ 7, Col+29, Row+ 7) ;
		Line(Col+ 5, Row+ 8, Col+29, Row+ 8) ;
		Line(Col+ 6, Row+ 9, Col+28, Row+ 9) ;
		Line(Col+ 7, Row+10, Col+27, Row+10) ;
		Line(Col+10, Row+11, Col+24, Row+11) ;
		Line(Col+10, Row+12, Col+24, Row+12) ;
		Line(Col+10, Row+13, Col+24, Row+13) ;
		Line(Col+10, Row+14, Col+24, Row+14) ;
		Line(Col+10, Row+15, Col+24, Row+15) ;
		Line(Col+10, Row+16, Col+24, Row+16) ;
		Line(Col+10, Row+17, Col+24, Row+17) ;
		Line(Col+10, Row+18, Col+24, Row+18) ;
		Line(Col+10, Row+19, Col+24, Row+19) ;
		Line(Col+10, Row+20, Col+24, Row+20) ;
		Line(Col+ 9, Row+21, Col+25, Row+21) ;
		Line(Col+ 8, Row+22, Col+26, Row+22) ;
		Line(Col+ 5, Row+23, Col+29, Row+23) ;
		Line(Col+ 4, Row+24, Col+30, Row+24) ;
		Line(Col+ 4, Row+25, Col+30, Row+25) ;
		Line(Col+ 4, Row+26, Col+30, Row+26) ;
		Line(Col+ 5, Row+27, Col+29, Row+27) ;

end; {* Draw_Rook *}

{ ------------------------------------------------------------- }

Procedure Draw_Knight

		(  XFile   : char      ; {* file letter *}
		   Rank    : integer   ; {* rank number *}
		   Color   : integer ) ; {* piece color *}

	{
		Draw a knight, pixel by pixel onto a 30 deep by 35 wide matrix.
		The piece colors are set globally by constants.
	}

Var
	Row,Col	: integer ;	{* Upper left bounds *}
	c  ,r 	: integer ; {* counters *}

begin
	{* Convert input coordinates into screen coordinates *}

		Row := Convert_File(XFile) ; Col := Convert_Rank(Rank) ;

	{* Draw piece *}

		SetColor(Color) ; SetLineStyle(SolidLn, 0, NormWidth) ;

		Line(Col+11, Row+ 2, Col+12, Row+ 2) ;
		Line(Col+ 7, Row+ 3, Col+ 8, Row+ 3) ;
		Line(Col+11, Row+ 3, Col+13, Row+ 3) ;
		Line(Col+ 7, Row+ 4, Col+13, Row+ 4) ;
		Line(Col+16, Row+ 4, Col+20, Row+ 4) ;
		Line(Col+ 8, Row+ 5, Col+23, Row+ 5) ;
		Line(Col+ 8, Row+ 6, Col+25, Row+ 6) ;
		Line(Col+ 8, Row+ 7, Col+27, Row+ 7) ;
		Line(Col+ 7, Row+ 8, Col+10, Row+ 8) ;
		Line(Col+14, Row+ 8, Col+28, Row+ 8) ;
		Line(Col+ 7, Row+ 9, Col+10, Row+ 9) ;
		Line(Col+14, Row+ 9, Col+29, Row+ 9) ;
		Line(Col+ 6, Row+10, Col+29, Row+10) ;
		Line(Col+ 6, Row+11, Col+30, Row+11) ;
		Line(Col+ 5, Row+12, Col+30, Row+12) ;
		Line(Col+ 4, Row+13, Col+13, Row+13) ;
		Line(Col+16, Row+13, Col+30, Row+13) ;
		Line(Col+ 5, Row+14, Col+11, Row+14) ;
		Line(Col+16, Row+14, Col+30, Row+14) ;
		Line(Col+ 5, Row+15, Col+10, Row+15) ;
		Line(Col+15, Row+15, Col+30, Row+15) ;
		Line(Col+ 6, Row+16, Col+ 9, Row+16) ;
		Line(Col+13, Row+16, Col+30, Row+16) ;
		Line(Col+12, Row+17, Col+30, Row+17) ;
		Line(Col+11, Row+18, Col+29, Row+18) ;
		Line(Col+10, Row+19, Col+29, Row+19) ;
		Line(Col+10, Row+20, Col+28, Row+20) ;
		Line(Col+ 9, Row+21, Col+27, Row+21) ;
		Line(Col+ 8, Row+22, Col+26, Row+22) ;
		Line(Col+ 5, Row+23, Col+30, Row+23) ;
		Line(Col+ 4, Row+24, Col+30, Row+24) ;
		Line(Col+ 4, Row+25, Col+30, Row+25) ;
		Line(Col+ 4, Row+26, Col+30, Row+26) ;
		Line(Col+ 5, Row+27, Col+29, Row+27) ;

end; {* Draw_Knight *}

{ ------------------------------------------------------------- }

Procedure Draw_Bishop

		(  XFile   : char      ; {* file letter *}
		   Rank    : integer   ; {* rank number *}
		   Color   : integer ) ; {* piece color *}

	{
		Draw a bishop, pixel by pixel onto a 30 deep by 35 wide matrix.
		The piece colors are set globally by constants.
	}

Var
	Row,Col	: integer ;	{* Upper left bounds *}
	c  ,r 	: integer ; {* counters *}

begin
	{* Convert input coordinates into screen coordinates *}

		Row := Convert_File(XFile) ; Col := Convert_Rank(Rank) ;

	{* Draw piece *}

		SetColor(Color) ; SetLineStyle(SolidLn, 0, NormWidth) ;

		Line(Col+16, Row+ 2, Col+18, Row+ 2) ;
		Line(Col+15, Row+ 3, Col+19, Row+ 3) ;
		Line(Col+16, Row+ 4, Col+18, Row+ 4) ;
		Line(Col+15, Row+ 5, Col+19, Row+ 5) ;
		Line(Col+13, Row+ 6, Col+13, Row+ 6) ;
		Line(Col+16, Row+ 6, Col+21, Row+ 6) ;
		Line(Col+12, Row+ 7, Col+14, Row+ 7) ;
		Line(Col+17, Row+ 7, Col+22, Row+ 7) ;
		Line(Col+12, Row+ 8, Col+14, Row+ 8) ;
		Line(Col+17, Row+ 8, Col+22, Row+ 8) ;
		Line(Col+11, Row+ 9, Col+23, Row+ 9) ;
		Line(Col+11, Row+10, Col+23, Row+10) ;
		Line(Col+11, Row+11, Col+23, Row+11) ;
		Line(Col+11, Row+12, Col+23, Row+12) ;
		Line(Col+12, Row+13, Col+22, Row+13) ;
		Line(Col+12, Row+14, Col+22, Row+14) ;
		Line(Col+13, Row+15, Col+21, Row+15) ;
		Line(Col+14, Row+16, Col+20, Row+16) ;
		Line(Col+15, Row+17, Col+19, Row+17) ;
		Line(Col+16, Row+18, Col+18, Row+18) ;
		Line(Col+13, Row+19, Col+21, Row+19) ;
		Line(Col+13, Row+20, Col+21, Row+20) ;
		Line(Col+16, Row+21, Col+18, Row+21) ;
		Line(Col+16, Row+22, Col+18, Row+22) ;
		Line(Col+ 5, Row+23, Col+29, Row+23) ;
		Line(Col+ 4, Row+24, Col+30, Row+24) ;
		Line(Col+ 4, Row+25, Col+30, Row+25) ;
		Line(Col+ 4, Row+26, Col+30, Row+26) ;
		Line(Col+ 5, Row+27, Col+29, Row+27) ;

end; {* Draw_Bishop *}

{ ------------------------------------------------------------- }

Procedure Draw_Queen

		(  XFile   : char      ; {* file letter *}
		   Rank    : integer   ; {* rank number *}
		   Color   : integer ) ; {* piece color *}

	{
		Draw a queen, pixel by pixel onto a 30 deep by 35 wide matrix.
		The piece colors are set globally by constants.
	}

Var
	Row,Col	: integer ;	{* Upper left bounds *}
	c  ,r 	: integer ; {* counters *}

begin
	{* Convert input coordinates into screen coordinates *}

		Row := Convert_File(XFile) ; Col := Convert_Rank(Rank) ;

	{* Draw piece *}

		SetColor(Color) ; SetLineStyle(SolidLn, 0, NormWidth) ;

		Line(Col+ 4, Row+ 3, Col+ 6, Row+ 3) ;
		Line(Col+12, Row+ 3, Col+14, Row+ 3) ;
		Line(Col+20, Row+ 3, Col+22, Row+ 3) ;
		Line(Col+28, Row+ 3, Col+30, Row+ 3) ;
		Line(Col+ 3, Row+ 4, Col+ 7, Row+ 4) ;
		Line(Col+11, Row+ 4, Col+15, Row+ 4) ;
		Line(Col+19, Row+ 4, Col+23, Row+ 4) ;
		Line(Col+27, Row+ 4, Col+31, Row+ 4) ;
		Line(Col+ 3, Row+ 5, Col+ 7, Row+ 5) ;
		Line(Col+11, Row+ 5, Col+15, Row+ 5) ;
		Line(Col+19, Row+ 5, Col+23, Row+ 5) ;
		Line(Col+27, Row+ 5, Col+31, Row+ 5) ;
		Line(Col+ 4, Row+ 6, Col+ 6, Row+ 6) ;
		Line(Col+12, Row+ 6, Col+14, Row+ 6) ;
		Line(Col+20, Row+ 6, Col+22, Row+ 6) ;
		Line(Col+28, Row+ 6, Col+30, Row+ 6) ;
		Line(Col+ 5, Row+ 7, Col+ 5, Row+ 7) ;
		Line(Col+13, Row+ 7, Col+13, Row+ 7) ;
		Line(Col+21, Row+ 7, Col+21, Row+ 7) ;
		Line(Col+29, Row+ 7, Col+29, Row+ 7) ;
		Line(Col+ 4, Row+ 8, Col+ 7, Row+ 8) ;
		Line(Col+12, Row+ 8, Col+15, Row+ 8) ;
		Line(Col+19, Row+ 8, Col+22, Row+ 8) ;
		Line(Col+27, Row+ 8, Col+30, Row+ 8) ;
		Line(Col+ 4, Row+ 9, Col+ 7, Row+ 9) ;
		Line(Col+12, Row+ 9, Col+15, Row+ 9) ;
		Line(Col+19, Row+ 9, Col+22, Row+ 9) ;
		Line(Col+27, Row+ 9, Col+30, Row+ 9) ;
		Line(Col+ 5, Row+10, Col+ 8, Row+10) ;
		Line(Col+12, Row+10, Col+15, Row+10) ;
		Line(Col+19, Row+10, Col+22, Row+10) ;
		Line(Col+26, Row+10, Col+29, Row+10) ;
		Line(Col+ 5, Row+11, Col+ 8, Row+11) ;
		Line(Col+13, Row+11, Col+15, Row+11) ;
		Line(Col+19, Row+11, Col+21, Row+11) ;
		Line(Col+26, Row+11, Col+29, Row+11) ;
		Line(Col+ 6, Row+12, Col+ 9, Row+12) ;
		Line(Col+13, Row+12, Col+15, Row+12) ;
		Line(Col+19, Row+12, Col+21, Row+12) ;
		Line(Col+25, Row+12, Col+28, Row+12) ;
		Line(Col+ 6, Row+13, Col+ 9, Row+13) ;
		Line(Col+13, Row+13, Col+15, Row+13) ;
		Line(Col+19, Row+13, Col+21, Row+13) ;
		Line(Col+25, Row+13, Col+28, Row+13) ;
		Line(Col+ 7, Row+14, Col+10, Row+14) ;
		Line(Col+14, Row+14, Col+16, Row+14) ;
		Line(Col+18, Row+14, Col+20, Row+14) ;
		Line(Col+24, Row+14, Col+27, Row+14) ;
		Line(Col+ 8, Row+15, Col+10, Row+15) ;
		Line(Col+14, Row+15, Col+16, Row+15) ;
		Line(Col+18, Row+15, Col+20, Row+15) ;
		Line(Col+24, Row+15, Col+26, Row+15) ;
		Line(Col+ 8, Row+16, Col+11, Row+16) ;
		Line(Col+14, Row+16, Col+20, Row+16) ;
		Line(Col+23, Row+16, Col+26, Row+16) ;
		Line(Col+ 9, Row+17, Col+25, Row+17) ;
		Line(Col+ 9, Row+18, Col+25, Row+18) ;
		Line(Col+ 9, Row+19, Col+25, Row+19) ;
		Line(Col+ 9, Row+20, Col+25, Row+20) ;
		Line(Col+13, Row+21, Col+21, Row+21) ;
		Line(Col+13, Row+22, Col+21, Row+22) ;
		Line(Col+ 5, Row+23, Col+29, Row+23) ;
		Line(Col+ 4, Row+24, Col+30, Row+24) ;
		Line(Col+ 4, Row+25, Col+30, Row+25) ;
		Line(Col+ 4, Row+26, Col+30, Row+26) ;
		Line(Col+ 5, Row+27, Col+29, Row+27) ;

end; {* Draw_Queen *}

{ ------------------------------------------------------------- }

Procedure Draw_King

		(  XFile   : char      ; {* file letter *}
		   Rank    : integer   ; {* rank number *}
		   Color   : integer ) ; {* piece color *}

	{
		Draw a king, pixel by pixel onto a 30 deep by 35 wide matrix.
		The piece colors are set globally by constants.
	}

Var
	Row,Col	: integer ;	{* Upper left bounds *}
	c  ,r 	: integer ; {* counters *}

begin
	{* Convert input coordinates into screen coordinates *}

		Row := Convert_File(XFile) ; Col := Convert_Rank(Rank) ;

	{* Draw piece *}

		SetColor(Color) ; SetLineStyle(SolidLn, 0, NormWidth) ;

		Line(Col+17, Row+ 2, Col+17, Row+ 2) ;
		Line(Col+16, Row+ 3, Col+18, Row+ 3) ;
		Line(Col+15, Row+ 4, Col+19, Row+ 4) ;
		Line(Col+16, Row+ 5, Col+18, Row+ 5) ;
		Line(Col+ 8, Row+ 6, Col+11, Row+ 6) ;
		Line(Col+17, Row+ 6, Col+17, Row+ 6) ;
		Line(Col+23, Row+ 6, Col+26, Row+ 6) ;
		Line(Col+ 6, Row+ 7, Col+13, Row+ 7) ;
		Line(Col+17, Row+ 7, Col+17, Row+ 7) ;
		Line(Col+21, Row+ 7, Col+28, Row+ 7) ;
		Line(Col+ 5, Row+ 8, Col+15, Row+ 8) ;
		Line(Col+17, Row+ 8, Col+17, Row+ 8) ;
		Line(Col+19, Row+ 8, Col+29, Row+ 8) ;
		Line(Col+ 4, Row+ 9, Col+30, Row+ 9) ;
		Line(Col+ 3, Row+10, Col+31, Row+10) ;
		Line(Col+ 3, Row+11, Col+31, Row+11) ;
		Line(Col+ 3, Row+12, Col+ 8, Row+12) ;
		Line(Col+12, Row+12, Col+22, Row+12) ;
		Line(Col+25, Row+12, Col+31, Row+12) ;
		Line(Col+ 3, Row+13, Col+ 8, Row+13) ;
		Line(Col+12, Row+13, Col+22, Row+13) ;
		Line(Col+25, Row+13, Col+31, Row+13) ;
		Line(Col+ 3, Row+14, Col+31, Row+14) ;
		Line(Col+ 3, Row+15, Col+31, Row+15) ;
		Line(Col+ 4, Row+16, Col+30, Row+16) ;
		Line(Col+ 5, Row+17, Col+29, Row+17) ;
		Line(Col+ 6, Row+18, Col+28, Row+18) ;
		Line(Col+ 7, Row+19, Col+27, Row+19) ;
		Line(Col+ 8, Row+20, Col+26, Row+20) ;
		Line(Col+10, Row+21, Col+24, Row+21) ;
		Line(Col+10, Row+22, Col+24, Row+22) ;
		Line(Col+ 5, Row+23, Col+29, Row+23) ;
		Line(Col+ 4, Row+24, Col+30, Row+24) ;
		Line(Col+ 4, Row+25, Col+30, Row+25) ;
		Line(Col+ 4, Row+26, Col+30, Row+26) ;
		Line(Col+ 5, Row+27, Col+29, Row+27) ;

end; {* Draw_King *}

{ ------------------------------------------------------------- }

Procedure	Draw_Board   (Game_State:Game_State_Type) ;

	{
		Draw the board, square by square based on the current
      Game state board positions.
		The square colors are set globally by constants.
	}

Var
	XFile    : char    ;  {* File letter *}
	Rank     : byte    ;  {* Rank number *}
   color    : byte    ;  {* piece color *}

begin

with Game_State do
  begin

		For XFile := 'a' to 'h' do
			For Rank := 1 to 8 do
				begin
               {* Determine piece color *}
               If Board[xFile,Rank].Side = white
               then
                  color := White_P
               else
                  color := Black_P ;

               Draw_Square(xFile,Rank) ;

               Case (Board[xFile,Rank].Piece) of
                  pawn   : Draw_Pawn   (xFile,Rank,color) ;
                  rook   : Draw_Rook   (xFile,Rank,color) ;
                  knight : Draw_Knight (xFile,Rank,color) ;
                  bishop : Draw_Bishop (xFile,Rank,color) ;
                  queen  : Draw_Queen  (xFile,Rank,color) ;
                  king   : Draw_King   (xFile,Rank,color) ;
               end;

				end;

  end; {* with Game_State *}

end; {* Draw_Board *}
{ ------------------------------------------------------------- }

Begin {* Main *}
End.  {* Main *}

