
 {$A+,B-,D-,E-,F-,I+,N-,O-,R-,S-,V+}
 {$M 1024, 0,0}

program TestQwriterUnit;
uses
  Qwriter;

var
  Loop1,           (* Loop control variables.                               *)
  Loop2,
  KeyChoice : word; (* User's key choice variable.                          *)

BEGIN
                   (* If we're in a color text-mode then...                 *)
  if ColorMode then
    ClearScr($27)

                   (* Else, we're in a monochrome text-mode.                *)
  else
    ClearScr(RevAttr);

                   (* Hide the cursor.                                      *)
  HideCursor(true);

                   (* Draw a menu on the screen.                            *)
  Qwrite('ͻ', 24, 6, RevAttr);
  Qwrite('      MENU CHOICE NUMBER 1      ', 24, 7, RevAttr);
  Qwrite('      MENU CHOICE NUMBER 2      ', 24, 8, RevAttr);
  Qwrite('      MENU CHOICE NUMBER 3      ', 24, 9, RevAttr);
  Qwrite('      MENU CHOICE NUMBER 4      ', 24,10, RevAttr);
  Qwrite('      MENU CHOICE NUMBER 5      ', 24,11, RevAttr);
  Qwrite('             EXIT               ', 24,12, RevAttr);
  Qwrite('ͼ', 24,13, RevAttr);
  Qwrite(' Use cursor-arrow keys to make your choice, then press <ENTER> ',
         10, 15, RevAttr);

                   (* Get the User's menu choice.                           *)
  KeyChoice := PickIt(7, 12, 25, 32, RevAttr, NormAttr);

                   (* Display the User's menu choice.                       *)
  Qwrite(' Your KeyChoice = ' + Int2Str(KeyChoice, 2) + ' ', 30, 18, RevAttr);

                   (* Prompt to continue this demo.                         *)
  Qwrite(' Press <ESC> key to continue demo ', 24, 20, RevAttr);

                   (* Wait until the User presses the <ESC> key.            *)
  Pause(EscapeKey);

                   (* Clear the screen using the pre-set normal attribute.  *)
  ClearScr(NormAttr);

                   (* Check if we're in color mode again.                   *)
  if NOT ColorMode then

                   (* Bzzzzzzzzttt!  We're in monochrome mode.              *)
    begin

                   (* Explain why the program is halting.                   *)
      Qwrite(' THIS SECTION NEEDS TO BE IN COLOR ', 23, 3, RevAttr);

                   (* Prompt for a key press.                               *)
      Qwrite(' Press <ESC> key to quit ', 28, 5, RevAttr);

                   (* Wait until the <ESC> key is pressed.                  *)
      Pause(EscapeKey);

                   (* Show the cursor again.                                *)
      HideCursor(false);

                   (* Clear the screen with the preset normal attribute.    *)
      ClearScr(NormAttr);

                   (* Halt the program.                                     *)
      halt
    end

                   (* Else, Yes!!!  We're in a color text-mode.             *)
  else
    begin
                   (* Clear the screen to lightgray.                        *)
      ClearScr($70);

                   (* Draw the "color attribute" chart.                     *)
      VQwrite('                ', 14, 8, NormAttr);
      VQwrite('0123456789ABCDEF', 15, 8, $0F);
      VQwrite('                ', 16, 8, NormAttr);
      VQwrite('            ', 10, 10, NormAttr);
      VQwrite('FIRST NUMBER', 11, 10, NormAttr);
      VQwrite('            ', 12, 10, NormAttr);
      Qwrite(' HEXIDECIMAL TEXT ATTRIBUTE CHART ', 25, 2, $0F);
      Qwrite('SECOND NUMBER', 36, 4, NormAttr);
      Qwrite(' 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ', 19, 6, $0F);
      for Loop1 := 0 to 15 do
        for Loop2 := 0 to 15 do
          Qwrite(' X ', (19 + (Loop2 * 3)), (8 + Loop1),
                 (Loop2 + (Loop1 Shl 4)));

                   (* Display User prompt.                                  *)
      Qwrite(' PRESS <ENTER> KEY TO TURN BLINK-BIT OFF ', 22, 25, NormAttr);

                   (* Wait until the <ENTER> key is pressed.                *)
      Pause(EnterKey);

                   (* Turn the color video blink-bit off, to display more   *)
                   (* colors.                                               *)
      BlinkBit(Off);

                   (* Display prompt.                                       *)
      Qwrite('     PRESS <ESC> KEY TO QUIT PROGRAM     ', 22, 25, NormAttr);

                   (* Wait until <ESC> key is pressed.                      *)
      Pause(EscapeKey);

                   (* Turn the blink-bit back on.                           *)
      BlinkBit(On);

                   (* Show the cursor again.                                *)
      HideCursor(Off);

                   (* Clear the screen.                                     *)
      ClearScr($07)
    end
END.

