(*****************************************************************************)
(*                                                                           *)
(*        Filename        : SCRSAV.PAS                                       *)
(*        Autor           : Stefan Boether / Compuserve Id : 100023,275      *)
(*        System          : TURBO 6.00 / MS-DOS 3.2 / Netzwerk               *)
(*        Aenderung       :                                                  *)
(*        wann     was                                                wer    *)
(*---------------------------------------------------------------------------*)
(*****************************************************************************)
(*        Beschreibung:  Litte screensaver object like norton-commander      *)
(*                       If you enjoy this object send me your own objects   *)
(* The screensaving starts if one of these events reached :                  *)
(*    - The mouse was move to the upper-right corner of desktop              *)
(*    - 30.000 ticks without action gone                                     *)
(*    - The user sends a cmStartSave command to desktop ( from menu )        *)
(*****************************************************************************)
{Header-End}

(* !!! litte Example to uses the screen-save in an application

    TMain = OBJECT (TApplication)
       Saver     : PScreenSaver;
       CONSTRUCTOR Init;
       PROCEDURE   HandleEvent(VAR Event: TEvent); VIRTUAL;
       PROCEDURE   GetEvent(VAR Event : TEvent );  VIRTUAL;
       PROCEDURE   Idle;                           VIRTUAL;
    END;

    CONSTRUCTOR TMain.Init;
      VAR R        : TRect;
    BEGIN
      TApplication.Init;
      Saver := NEW( PScreenSaver, Init ( 30000 ));
      Insert( Saver );
    END;

    PROCEDURE TMain.GetEvent(VAR Event : TEvent );
    BEGIN
      TApplication.GetEvent( Event );
      Saver^.GetEvent( Event );
    END;

    PROCEDURE TMain.HandleEvent( var Event: TEvent );
    BEGIN
        TApplication.HandleEvent(Event);
        CASE Event.What = evCommand AND
             Event.Command = cmStartSaver THEN
            Saver^.StartIt;
    END;

    PROCEDURE TMain.Idle;
    BEGIN
      TApplication.Idle;
      IF NOT Saver^.Activ THEN
         BEGIN
           Clock^.Update;
           Heap^.Update;
         END;
    END;

*)

UNIT ScrSav;

INTERFACE

USES  Dos, Objects, Drivers, Views, App ;

TYPE

  PScreenSaver = ^TScreenSaver;
  TScreenSaver = OBJECT( TView )
    Activ       : BOOLEAN;                 (* Screen Saver aktiv ? *)
    MaxTicks    : WORD;                 (* Aktivieren nach n-Ticks *)
    TicksGone   : WORD;                        (* Vergangene Ticks *)
    CONSTRUCTOR Init( Ticks : WORD );
    PROCEDURE   GetEvent( VAR Event : TEvent );    VIRTUAL;
    PROCEDURE   Action;                            VIRTUAL;
    PROCEDURE   StartIt;                           VIRTUAL;
  END;

IMPLEMENTATION

(*****************************************************************************)

CONSTRUCTOR TScreenSaver.Init( Ticks : WORD );
  VAR R : TRect;
BEGIN
  Desktop^.GetExtent( R );
  R.A.X := PRED( R.B.X ); R.B.Y := SUCC( R.A.Y );
  TView.Init( R );
  Activ    := FALSE;
  MaxTicks := Ticks;
  TicksGone := 0;
END; (* TScreenSaver.Init *)

(*****************************************************************************)

PROCEDURE TScreenSaver.StartIt;
BEGIN
  TicksGone := MaxTicks;
END;

(*****************************************************************************)

PROCEDURE TScreenSaver.GetEvent( VAR Event : TEvent );
  (* Please call this method in your applicationsmethod GetEvent-Method *)
BEGIN
  IF ( Event.What = evNothing ) THEN
     IF NOT Activ THEN
        BEGIN
         INC( TicksGone );
         IF TicksGone > MaxTicks THEN
            BEGIN
             Activ := TRUE;
             DoneVideo;
            END;
        END
     ELSE Action
  ELSE
     BEGIN
       IF Event.What = evMouseMove THEN
          IF MouseInView( Event.Where ) THEN
             BEGIN
               StartIt;
               EXIT;
             END;
       IF Activ THEN
          BEGIN
            Activ := FALSE;
            InitVideo;
            Application^.ReDraw;
          END;
       TicksGone := 0;
     END;
END;  (* TScreenSaver.GetEvent *)

(*****************************************************************************)

PROCEDURE TScreenSaver.Action;
  VAR Reg : REGISTERS;
BEGIN
  WITH Reg DO
    BEGIN
      AH := $02;
      DH := RANDOM( ScreenHeight );
      DL := RANDOM( ScreenWidth );
      INTR( $10, Reg );
    END;
  IF RANDOM ( 100 ) < 2 THEN
     IF RANDOM( 4 ) < 2 THEN PrintStr( '*' )
                        ELSE PrintStr( '' )
  ELSE PrintStr( ' ' );
END; (* TScreenSaver.Action *)

END.