program TestColr;
{
             To test the SelectColors function of ShClrDef

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC
}

uses
  TpString,
  TpCrt,
  TpEdit,
  ShClrDef;

var
  EraseP,
  EraseC,
  WrapCursor,
  Quit      : boolean;
  C1        : char;
  MsgRow,
  YNcol,
  B1,B2,
  Xhi,Yhi,
  Xloc,Yloc : byte;
  MaxMem,
  AvailMem  : longint;
  XY        : word;
  ScrnBuf   : pointer;

function StopRun : boolean;
  begin
    StopRun := (not YesOrNo('Again?  ', MsgRow+2, YNcol, $70, 'Y'));
    end;

begin
  {Record the environment}
  {Un-comment the following lines if you wish to check that the heap is
   being completely restored. Also un-comment the lines at the end of the
   program file.}
(**)
  MaxMem := MemAvail;           {Total unused heap space}
  AvailMem := MaxAvail;         {Largest contiguous heap block};
(**)
  Xhi := ScreenWidth;
  Yhi := ScreenHeight;

  {Locate the panel}
  WriteLn('Locate the color panel where?');
  Write  ('     Row coordinate [0..',(ScreenHeight-17):2,', 255]   ');
  ReadLn(Yloc);
  Write  ('     Col coordinate [0..',(ScreenWidth -25):2,', 255]   ');
  ReadLn(Xloc);

  {Erase the panel on exit from SelectColors?}
  Write  ('Erase panel? [T/F]    '); C1 := UpCase(ReadKey);
  while not (C1 in ['T','F']) do begin
    Write(^G);
    C1 := UpCase(ReadKey);
    end;
  WriteLn(C1);
  EraseP := (C1 = 'T');

  if not EraseP then begin
    {Erase the Cursor on exit from SelectColors?}
    Write  ('Erase cursor? [T/F]   '); C1 := UpCase(ReadKey);
    while not (C1 in ['T','F']) do begin
      Write(^G);
      C1 := UpCase(ReadKey);
      end;
    WriteLn(C1);
    EraseC := (C1 = 'T');
    end;

  {Allow cursor wrap at window edges?}
  Write  ('Wrap cursor? [T/F]    '); C1 := UpCase(ReadKey);
  while not (C1 in ['T','F']) do begin
    Write(^G);
    C1 := UpCase(ReadKey);
    end;
  WriteLn(C1);
  WrapCursor := (C1 = 'T');

  {Locate the message row according to panel position.}
  if Yloc >= 4 then
    MsgRow := 1
  else
    MsgRow := ScreenHeight - 3;
  YNcol := (ScreenWidth shr 1) - 7;

  {Do the color selection}
  XY := WhereXY;
  if not
    SaveWindow(1, 1, ScreenWidth, ScreenHeight, true, ScrnBuf) then;
  ClrScr;
  B1 := BlackOnBlack;
  repeat
    B1 := SelectColors
          (Yloc,Xloc,B1,FrameChars,Vertical,
           EraseP,EraseC,WrapCursor,' Color Panel ');
    case B1 of
      $FF : begin
              B1 := B2;
              FastWrite(
              Center('Re-written in '+ColorName(B1), Xhi),
                      MsgRow, 1, B1);
              Quit := StopRun;
              FastWrite('                ', MsgRow+2, YNcol, BlackOnBlack);
              end;
      $F0 : FastWrite(
            Center('Error in MakeWindow', Xhi),
                    MsgRow, 1, $07);
      $F1 : FastWrite(
            Center('Error in DisplayWindow', Xhi),
                    MsgRow, 1, $07);
      $F2 : FastWrite(
            Center('Row parameter out of range', Xhi),
                    Yhi shr 1, 1, $07);
      $F3 : FastWrite(
            Center('Column parameter out of range', Xhi),
                    Yhi shr 1, 1, $07);
      else begin
             FastWrite(
               Center('Written in '+ColorName(B1), Xhi),
                       MsgRow, 1, B1);
             B2 := B1;
             Quit := StopRun;
             FastWrite('                ', MsgRow+2, YNcol, BlackOnBlack);
             end; {else}
      end; {case B1}
    until Quit or ((B1 >= $F0) and (B1 < $FF));

  {Kick out on any error}
  if (B1 >= $F0) and (B1 < $FF) then begin
    GoToXY(1, (Yhi shr 1) +2);
    Write(^G+TrimTrail(Center('Any key to return to DOS...  ', Xhi)));
    if ReadKey = '' then ;
    end;
  RestoreWindow(1, 1, ScreenWidth, ScreenHeight, true, ScrnBuf);
  GoToXYabs(lo(XY), hi(XY));
  {Display residual heap -- should be none}
  {Un-comment the following lines if you wish to check that the heap is
   being completely restored.}
(**)
  WriteLn('Total heap at start = ',MaxMem);
  WriteLn('Total heap at end   = ',MemAvail);
  WriteLn('Largest contiguous block on heap at start = ',AvailMem);
  WriteLn('Largest contiguous block on heap at end   = ',MaxAvail);
(**)
  end.
