program TestCrc;
{
                       To test the ShCrcChk unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC
}

uses
  TpString,
  TpCrt,
  ShCrcChk;

var
  OriginalCRC,
  CopiedFileCRC,
  ChangedFileCRC: word;
  XXX           : file of byte;
  T1            : longint;
  B1            : byte;
begin
  WriteLn('Reads this program source file and calculates its CRC,');
  WriteLn('makes a true copy and calculates its CRC, then makes a');
  WriteLn('copy with one character at or near the mid-point of the');
  WriteLn('file changed and calculates its CRC. At the completion the');
  WriteLn('three CRC''s are displayed.');
  WriteLn('');
  WriteLn('Copying with CrcCopy...');
  OriginalCRC := CrcCopy('TESTCRC.PAS', 'TESTCRC.CK1');
  CopiedFileCRC := CrcCopy('TESTCRC.CK1', 'TESTCRC.CK2');
  WriteLn('Changing one character in the second copy...');
  {Now change one character in the second file, somewhere near the middle}
  Assign(XXX, 'TESTCRC.CK2');
  Reset(XXX);
  T1 := FileSize(XXX) shr 1;
  Seek(XXX, T1);
  repeat
    Read(XXX,B1);
    inc(T1);
    until (B1 >= 32); {Change only a readable character}
  dec(T1);  {Put the pointer back where it belongs}
  Write('':5,'A ''',char(B1),''' is being changed to a ''');
  inc(B1);
  WriteLn(char(B1),'''');
  Seek(XXX, T1);
  Write(XXX,B1);
  Close(XXX);
  WriteLn('Calculating CRC of modified copy with CrcCalc...');
  ChangedFileCRC := CrcCalc('TESTCRC.CK2');
  {Tests completed. Display the result.}
  WriteLn('CRC of original file = ',HexW(OriginalCRC));
  WriteLn('CRC of true copy     = ',HexW(CopiedFileCRC));
  WriteLn('CRC of changed copy  = ',HexW(ChangedFileCRC));
  WriteLn;
  Write('Delete the copied test files (Y/n)?  ');
  if not (UpCase(ReadKey) = 'N') then begin
    Erase(XXX);
    Assign(XXX, 'TESTCRC.CK1');
    Erase(XXX);
    end;
  end.
