program TestDate;
{
                        To test the ShDatPk unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC
}

uses
  ShDatPk;

var
  G               : GregType;
  T               : TimeType;
  Year,
  Month,
  Day,
  Weekday,
  JulianDate      : array[1..3] of integer;
  JulianDayNumber : array[1..2] of LongInt;
  Greg            : array[1..3] of GregType;

begin
  JDN2Greg(Today, G);
  WriteLn('Today is day number ',Today,', a ',DayStr[DoW(G)]);
  WriteLn('Today''s date (TodayStr) is ',TodayStr('='));
  WriteLn('Today''s date (JDN2Str) is ',JDN2Str(Today,'/'));
  WriteLn('   as an ANSI string (YYYYMMDD) ', Today2ANSI);
  WriteLn;
  WriteLn('The time in seconds since midnight is ',Now);
  WriteLn('    the a.m./p.m. time is ',NowStr(':',false));
  WriteLn('    the undelimited time is ',NowStr('',false));
  WriteLn;
  WriteLn('    the military time is ',NowStr('',true));
  WriteLn('    the 24-hour time is ',NowStr(':',true));
  SSM2Time(Now, T);
  WriteLn('    the 24-hour time (SSM2Time, Time2TimeStr) is ',
                                                  Time2TimeStr(T,':',true));
  Now2Time(T);
  WriteLn('    the 24-hour time (Now2Time, Time2TimeStr) is ',
                                                  Time2TimeStr(T,':',true));
  WriteLn('    the 24-hour time (Time2SSM, SSM2TimeStr) is ',
                                       SSM2TimeStr(Time2SSM(T), '.', true));
  WriteLn;
  WriteLn('The remainder of this testing program will allow you to');
  WriteLn('  experiment with dates of your own choosing, entered as');
  WriteLn('  year, month, day in response to the prompts. ');
  WriteLn;
  WriteLn(^G'  Note that the YEAR does not default to the 20th century.');
  WriteLn('<Ctrl-Break> out of this program.');
  WriteLn;
  repeat
    Write('Year    '); ReadLn(Greg[1].Year);
    Write('Month   '); ReadLn(Greg[1].Month);
    Write('Day     '); ReadLn(Greg[1].Day); WriteLn;

    WriteLn('You entered:');
    WriteLn('     ',DayStr[DoW(Greg[1])],', ',MonthStr[Greg[1].Month],
                    ' ',Greg[1].Day,', ',Greg[1].Year);
    WriteLn;

    JulianDayNumber[1] := Greg2JDN(Greg[1]);
    JDN2Greg(JulianDayNumber[1], Greg[2]);
    JulianDate[1] := Greg2JDate(Greg[2]);
    Greg[3].Year := Greg[1].Year;
    JDate2Greg(JulianDate[1], Greg[3].Year, Greg[3]);
    Weekday[1] := DoW(Greg[3]);

    with Greg[1] do
      WriteLn(Month,'/',Day,'/',Year,' is day number ',
              JulianDayNumber[1]);
    with Greg[2] do
      WriteLn(Month,'/',Day,'/',Year,' is day ',
              JulianDate[1],' of the year.');
    with Greg[3] do
      WriteLn(MonthStr[Month],' ',Day,', ',Year,' is a ',DayStr[Weekday[1]]);
    WriteLn; WriteLn;
    until false;
    end.
