program TestLstr;
{
                       To test the ShLngStr unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC

}

uses
  TpDos,
  TpCrt,
  ShCrcChk,
  ShUtilPk,
  ShLngStr;

const
  Msg : array[1..11] of string[68] =
    (('The routines in this unit process strings of characters up to 65517'),
     (' char- acters in length. All of the string manipulation features'   ),
     (' which you are used to having available for use have their analog ' ),
     ('in this unit.'   +    ' Every effort has been made to keep all call'),
     ('ing sequences as intuitive as pos- sible. '  +  'The test sequence '),
     ('about to begin tests every function and procedure in the unit. Some'),
     (' of these tests are implicit; you will not necessarily see them inv'),
     ('oked in the test, but they will have been invoked at a lower level.'),
     (    +  ' Please notify Madison & Associates at the address, phone nu'),
     ('mber, or CIS User ID given in the documentation if you have any pro'),
     ('blems or suggestions regarding ShLngStr.'                           ));

var
  A,
  B,
  C,
  D   : LongString;
  E,
  F,
  G   : text;
  OT  : text;
  W1  : word;
  S1  : string;
  TstO: string;

procedure AnyKey;
  begin
    if HandleIsConsole(1) then begin
      Write('Any key to continue...');
      if ReadKey = #0 then ;
      WriteLn;
      end;
    end;

procedure DC(A : LongString; As : String; B : LongString; Bs : String);
  begin
    WriteLn(OT);
    case lsComp(A, B) of
      LESS    : WriteLn(OT, As + ' < ' + Bs);
      EQUAL   : WriteLn(OT, As + ' = ' + Bs);
      GREATER : WriteLn(OT, As + ' > ' + Bs);
      end; {case}
    end; {DC}

procedure WrapLs(C : LongString);
  begin
    W1 := 0;
    repeat
      S1 := lsGetNextStrF(C);
      if W1 + Length(S1) >= 75 then begin
        W1 := Length(S1);
        WriteLn(OT);
        end
      else
        inc(W1, Length(S1)+1);
      Write(OT, S1, ' ');
      until lsLength(C) = 0;
    WriteLn(OT);
    end; {WrapLs}

procedure TestTrims;
  const
    X = '       +/ +/ +/ +/ +/ + /+ABCDEFG= = = = =       ';
  var
    A : LongString;
    CS: set of Char;
  begin
    WriteLn(OT, 'TESTING THE TRIM ROUTINES'); WriteLn(OT);
    CS := lsDelimSet + ['+','/','='];
    if not lsInit(A, 40) then halt;
    lsStr2LongString(X, A);
    WriteLn(OT, 'The original string is |',X,'|');
    lsWriteLn(OT, A);
    WriteLn(OT, 'Trimming the lead,');
    lsWriteLn(OT, lsTrimLeadF(A));
    WriteLn(OT, 'Trimming the tail,');
    lsWriteLn(OT, lsTrimTrailF(A));
    WriteLn(OT, 'Trimming the whole string,');
    lsWriteLn(OT, lsTrimF(A));
    WriteLn(OT);
    lsWriteLn(OT, A);
    WriteLn(OT, 'The trimmable set is [#0..#32,''+'',''/'',''='']');
    WriteLn(OT, 'Set-Trimming the lead,');
    lsWriteLn(OT, lsTrimLeadSetF(A, CS));
    WriteLn(OT, 'Set-Trimming the tail,');
    lsWriteLn(OT, lsTrimTrailSetF(A, CS));
    WriteLn(OT, 'Set-Trimming the whole string,');
    lsWriteLn(OT, lsTrimSetF(A, CS));
    WriteLn(OT); WriteLn(OT, 'END OF TRIM ROUTINES TEST');
    lsDispose(A);
    end; {TestTrims}

begin
  if not OpenStdDev(OT, 1) then begin
    WriteLn('Can''t open console device.');
    Halt(1);
    end;
  WriteLn(OT);
  lsWriteLn(OT, lsCharStrF(#205, 75));
  WriteLn
    (OT, '           ShLngStr -- A LongString Processing Unit'           );
  WriteLn(OT); WriteLn
    (OT, '                             from'                             );
  WriteLn(OT); WriteLn
    (OT, '              W. G. Madison and Associates, Ltd.'              );
  WriteLn(OT); WriteLn
    (OT, '          Copyright 1991  Madison & Associates, Ltd.'          );
  WriteLn
    (OT, '                     All rights reserved.'                     );
  WriteLn(OT);
  assign(F, 'TESTLSTR.DAT');
  Reset(F);
  TstO := UniqueFileName('',true);
  Assign(G, TstO);
  Rewrite(G);
  if not lsInit(A, 512) then WriteLn(OT, 'Bad declaration on A');
  if not lsInit(B, 600) then WriteLn(OT, 'Bad declaration on B');
  if not lsInit(C, 2048) then WriteLn(OT, 'Bad declaration on C');
  if not lsInit(D, 2048) then WriteLn(OT, 'Bad declaration on D');
  for W1 := 1 to 11 do
    lsTransfer(lsConcatStr2LsF(D, Msg[W1]), D);
  WrapLs(D);
  lsWriteLn(OT, lsCharStrF(#205, 75));
  AnyKey;
  WriteLn(OT);
  TestTrims;
  AnyKey;
  D^.Length := 0;
  lsIoff;
  WriteLn(OT, 'BEGINNING FILE COPYING TEST.');
  while not eof(F) do begin
    lsReadLn(F, A);
    if lsIoResult <> 0 then begin
      WriteLn(OT, 'OOPS on reading. ',W1);
      Halt;
      end;
    lsWriteLn(G, A);
    if lsIoResult <> 0 then begin
      WriteLn(OT, 'OOPS on writing. ',W1);
      Halt;
      end;
    end; {while}
  Close(F);
  Close(G);
  WriteLn(OT, 'Copying successful.');
  WriteLn(OT);
  WriteLn(OT, 'COMPARE THE ORIGINAL WITH THE COPIED FILE.');
  if not HandleIsConsole(1) then begin
    WriteLn(OT, 'Comparison test uses CRC check on redirected output.');
    if (CrcCalc('TESTLSTR.DAT') = CrcCalc(TstO)  ) and
       (TextFileSize(F)         = TextFileSize(G)) then begin
      WriteLn(OT, 'Files compare OK.');
      end
    end
  else begin
    WriteLn(OT, 'Comparison test uses Dos COMP check on console output.');
    assign(E, 'COMPARE.BAT');
    Rewrite(E);
    WriteLn(E, 'COMP TESTLSTR.DAT ' + TstO);
    Close(E);
    if ExecDos('COMPARE', true, nil) = 0 then ;
    Erase(E);  {The batch file}
    end;
  WriteLn(OT);
  Erase(G);  {The output file}
  lsIon;

  Reset(F);
  WriteLn(OT, 'BEGINNING RepAll, DelAll TEST.');
  lsReadLn(F, A);
  WriteLn(OT, '   The original LongString');
  lsWriteLn(OT, A);
  lsRepAllStr(A, 'abc', '12345', C);
  lsTransfer(lsRepAllStrF(A, 'abc', '12345'), B);
  WriteLn(OT, ^M^J'''abc'' replaced by ''12345''.');
  lsWriteLn(OT, B);
  DC(C, 'lsRepAllStr(A, ''abc'', ''12345'', C)',
    B, 'lsRepAllStrF(A, ''abc'', ''12345'')');
  AnyKey;

  lsRepAllStrUC(A, 'abc', '12345', C);
  WriteLn(OT, ^M^J'Case insensitive replacement of ''abc'' by ''12345''.');
  lsWriteLn(OT, C);
  DC(C, 'lsRepAllStrUC(A, ''abc'', ''12345'', C)',
    lsRepAllStrUCF(A, 'abc', '12345'), 'lsRepAllStrUCF(A, ''abc'', ''12345'')');
  AnyKey;

  lsDelAllStr(A, 'abc', B);
  WriteLn(OT, ^M^J'''abc'' deleted.');
  lsWriteLn(OT, B);
  DC(B, 'lsDelAllStr(A, ''abc'', B)', lsDelAllStrF(A, 'abc'),
    'lsDelAllStrF(A, ''abc'')');
  DC(B, 'lsDelAllStr(A, ''abc'', B)', lsDelAllF(A, lsStr2LongStringF('abc')),
    'lsDelAllF(A, lsStr2LongStringF(''abc''))');
  AnyKey;

  WriteLn(OT, ^M^J'CENTERED IN A FIELD 560 WIDE.');
  lsCenter(A, 560, B);
  lsWriteLn(OT, B);
  DC(B, 'lsCenter(A, 560, B)', lsCenterF(A, 560), 'lsCenterF(A, 560)');
  DC(B, 'lsCenter(A, 560, B)',
         lsCenterChF(A, ' ', 560), 'lsCenterChF(A, '' '', 560)');
  W1 := 560 - ((560 - lsLength(A)) shr 1);
  lsPad(lsLeftPadF(A, W1), 560, C);
  DC(B, 'lsCenter(A, 560, B)',
     C, ^M^J' lsPad(lsLeftPadF(A, 560 - ((560 - lsLength(A)) shr 1)), 560, C)');
  AnyKey;

  WriteLn(OT, ^M^J'RESTORE BY TRIMMING, PADDING.');
  lsTrimTrail(lsTrimLeadF(B), C);
  lsTrim(B, B);
  lsLeftPad(B, lsLength(A), B);
  lsLeftPad(C, lsLength(A), C);
  lsWriteLn(OT, B);
  DC(B, 'lsTrim(B, B); lsLeftPad(B, lsLength(A), B)',
        lsLeftPadF(lsTrimF(B), lsLength(A)),
        'lsLeftPadF(lsTrimF(B), lsLength(A))');
  DC(B, 'lsTrim(B, B); lsLeftPad(B, lsLength(A), B)',
     C, ^M^J' lsTrimTrail(lsTrimLeadF(B), C); lsLeftPad(C, lsLength(A), C)');
  AnyKey;

  WriteLn(OT, ^M^J'UPCASE TEST');
  lsWriteLn(OT, lsUpcaseF(B));
  lsUpcase(B, C);
  DC(lsUpcaseF(B), 'lsUpcaseF(B)', C, 'lsUpcase(B, C)');
  AnyKey;

  WriteLn(OT, ^M^J'LOCASE TEST');
  lsWriteLn(OT, lsLocaseF(B));
  lsLocase(B, C);
  DC(lsLocaseF(B), 'lsLocaseF(B)', C, 'lsLocase(B, C)');
  AnyKey;

  WriteLn(OT, ^M^J'COPY TEST');
  WriteLn(OT, 'Copy first upper case alphabet from the following string.');
  lsWriteLn(OT, A);
  lsCopy(A, lsPosStr('A', A), 26, B);
  WriteLn(OT);
  lsWriteLn(OT, lsCopyF(A, lsPosStr('A', A), 26));
  DC(B, 'lsCopy(A, lsPosStr(''A'', A), 26, B)',
    lsCopyF(A, lsPosStr('A', A), 26),
    'lsCopyF(A, lsPosStr(''A'', A), 26)');
  AnyKey;

  WriteLn(OT, ^M^J'INSERT TEST');
  WriteLn(OT, 'Insert upper case alphabet preceeding ''k'' in original LongString.');
  lsWriteLn(OT, A);
  WriteLn(OT);
  lsWriteLn(OT, B);
  WriteLn(OT);
  lsWriteLn(OT, lsInsertStrF(A, lsLongString2Str(B), lsPosStr('k', A)));
  lsInsertStr(A, lsLongString2Str(B), lsPosStr('k', A), C);
  DC(C, 'lsInsertStr(A, lsLongString2Str(B), lsPosStr(''k'', A), C)',
      lsInsertStrF(A, lsLongString2Str(B), lsPosStr('k', A)),
      ^M^J'     lsInsertStrF(A, lsLongString2Str(B), lsPosStr(''k'', A))');
  AnyKey;

  WriteLn(OT, ^M^J'DELETE TEST');
  WriteLn(OT, 'Delete the inserted upper case alphabet from the above.');
  WriteLn(OT, '   This should return the LongString to its original form.');
  lsWriteLn(OT, lsDeleteF(C, lsPosStr('A', C), 26));
  DC(A, 'A', lsDeleteF(C, lsPosStr('A', C), 26),
            'lsDeleteF(C, lsPosStr(''A'', C), 26)');
  AnyKey;

  {Prepare for concatenation, GetNext tests}
  Reset(F);
  repeat
    lsReadLn(F, A);
    until lsPosStrUC('WHEN', A) <> 0;
  lsTransfer(A, C);
  lsTransfer(A, D);
  repeat
    lsReadLn(F, A);
    lsConcat(C, A, C);
    lsTransfer(lsConcatF(D, A), D);
    until eof(F);

  WriteLn(OT, ^M^J'CONCATENATION TEST');
  lsWriteLn(OT, C);
  DC(C, 'lsConcat(C, A, C)', D, 'lsTransfer(lsConcatF(D, A), D)');
  AnyKey;

  WriteLn(OT, ^M^J'GETNEXT TEST, DOING A WORD WRAP ON THE ABOVE.');
  WrapLs(C);
  Close(F);

  WriteLn(OT, ^M^J'I/O ERROR HANDLING TEST.');
  lsIoff;
  Assign(E, 'FOO.BAZ');
  WriteLn
    (OT, 'The next line displayed should be ''104 (File not open for input)''');
  lsReadLn(E, A);
  WriteLn(OT, lsIoResult,' (File not open for input)');
  WriteLn
    (OT, 'The next event should be a runtime error and program termination.');
  Flush(OT);
  lsReadLn(E, A);
  lsReadLn(E, A);
  lsIon;

  end.
