program TestUtil;
{
                       To test the ShUtilPk unit

                  Copyright 1991 Madison & Associates
                          All Rights Reserved

         This program source file and the associated executable
         file may be  used and distributed  only in  accordance
         with the  provisions  described  on  the title page of
                  the accompanying documentation file
                              SKYHAWK.DOC
}

uses
  TpCrt,
  TpString,
  TpDos,
  ShUtilPk;

const
  S1  : string = '  Now is  the        time  for all good gorps.   ';

var
  S2,
  O1,
  O2  : string;
  T1  : LongInt;
  T2  : integer;
  W1,
  W2  : word;
  F1  : file;

procedure AnyKey;
  begin
    if HandleIsConsole(1) then begin
      Write('Any key to continue...');
      if ReadKey = #0 then ;
      WriteLn;
      end;
    end;

begin
  WriteLn('The functions BETWU and BETWS require such a large amount' );
  WriteLn('of output to test them properly that it is not feasible to');
  WriteLn('include them in this current test suite. The tests for'    );
  WriteLn('these two functions will be found in the file TESTBETW, in');
  WriteLn('both source and executable form.'                          );
  WriteLn;
  AnyKey;
  WriteLn;
  WriteLn(Center('REPALL, DELALL TEST', 75));
  S2 := 'aabcbcabcd';
  WriteLn(S2);
  WriteLn('Replacing ''abc'' by ''12345''');
  O1 := 'abc';
  O2 := '12345';
  WriteLn(RepAllF(S2, O1, O2));
  WriteLn;
  WriteLn(S2);
  WriteLn('Deleting all ''abc''');
  WriteLn(DelAllF(S2, O1));
  WriteLn('  Note: Did not delete strings caused by the DelAll process.');
  WriteLn;
  WriteLn('Deleting all (including incidental) ''abc''');
  repeat
    DelAll(S2, O1, S2);
    until Pos(O1, S2) = 0;
  WriteLn(S2);
  AnyKey;
  WriteLn;
  WriteLn;
  WriteLn(Center('GETNEXT TEST', 75));
  WriteLn('|',S1,'|');
  T1 := 0;
  repeat
    inc(T1);
    GetNext(S1, S2);
    WriteLn(T1);
    WriteLn('|',S2,'|');
    WriteLn('|',S1,'|');
    WriteLn;
    AnyKey;
    until S1 = '';
  WriteLn;
  WriteLn;
  WriteLn(Center('HEX TEST', 75));
  WriteLn('Inside a loop, you will be asked to enter a number. When you want');
  WriteLn('to break out of the loop, enter an alpha string instead.');
  WriteLn;
  repeat
    Write('Enter an integer-type number  ');
    {$I-}ReadLn(T1);{$I+}
    T2 := IoResult;
    if T2 = 0 then begin
      WriteLn('   The HEX equivalent is ',HEX(T1));
      WriteLn;
      end;
    until T2 <> 0;
  AnyKey;
  WriteLn;
  WriteLn;
  WriteLn(Center('HIWORD, LOWORD, LI TEST', 75));
  T1 := $DCBA9876;
  WriteLn(Hex(T1),',   ',T1);
  W1 := HiWord(T1);
  W2 := LoWord(T1);
  WriteLn('':3,'HiWord(T1) = ',Hex(W1));
  WriteLn('':3,'LoWord(T1) = ',Hex(W2));
  WriteLn('Re-assembling in reverse order:');
  T1 := LI(W1, W2);
  WriteLn(Hex(T1),',   ',T1);
  AnyKey;
  WriteLn;
  WriteLn;
  WriteLn(Center('PMOD TEST', 75));
  WriteLn;
  T1 := -7;
  T2 := 13;
  WriteLn('For X = ',T1,'   and M = ',T2);
  WriteLn('':5,'(X mod M) = ',(T1 mod T2));
  WriteLn('':2,'but');
  WriteLn('':5,'Pmod(X,M) = ',Pmod(T1, T2));
  AnyKey;
  WriteLn;
  WriteLn;
  WriteLn(Center('POSSET TEST', 75));
  WriteLn('Str = ''XIY2C3Z4B'',    A = [''A'', ''B'', ''C'']');
  WriteLn('     PosSet(A, Str) returns ',PosSet(['A', 'B', 'C'], 'XIY2C3Z4B'));
  AnyKey;
  WriteLn;
  WriteLn;
  WriteLn(Center('SEARCHENVIRONMENT TEST', 75));
  WriteLn(^G'You will need to set up this test yourself, since there is no');
  WriteLn('way for us to know what environment strings you have set up.');
  AnyKey;
  WriteLn;
  WriteLn;
  WriteLn(Center('STARSTRING TEST', 75));
  S2 := 'ABCDEFG';
  O1 := '*B*EFG';
  O2 := '*B*EGF';
  WriteLn('if');
  WriteLn('':3,'S2 := ''ABCDEFG''');
  WriteLn('':3,'O1 := ''*B*EFG''');
  WriteLn('':3,'O2 := ''*B*EGF''');
  WriteLn('     StarString(O1, S2) = ', StarString(O1, S2));
  WriteLn('     StarString(O2, S2) = ', StarString(O2, S2));
  AnyKey;
  WriteLn;
  WriteLn;
  WriteLn(Center('UNIQUEFILENAME TEST', 75));
  S2 := UniqueFileName('', false);
  WriteLn('A unique file name in this directory will be ',S2);
  WriteLn('    This file will be temporarily created with a $$$ extension.');
  assign(F1, S2);
  Rewrite(F1);
  Close(F1);
  S2 := UniqueFileName('', true);
  WriteLn('A unique name with an extension will be ',S2);
  Erase(F1);
  AnyKey;
  WriteLn;
  WriteLn;
  WriteLn(Center('WHOAMI TEST', 75));
  if Hi(DosVersion) >= $03 then
    WriteLn('The currently executing file is ',WhoAmI)
  else
    WriteLn('This function requires Dos version 3.0 or higher.');
  end.
