
Program Sample2;

  { Sample program to save a message to a subboard }


Uses General,Filedef,SubList,Message,Users,Post;

var msg: msgptr;
    s,subboard,filename: string;
    valid: boolean;
    header: headertype;
    inputfile: text;
    p: SubListPtr;
    result: longint;


Begin

  { Open CONFIG, NODES and USER files }
  { It is recommended to open the user file if saving messages }

  if OpenFiles([CONFIGF,NODESF]) and OpenUserFile then begin

    { Initialize subboard list }
    SubListInit(Subboards);

    { Prompt user to enter a subboard name }
    repeat
      writeln('Enter Subboard Name: ');
      readln(subboard);
      upstr(subboard);          { make all uppercase }
      stripspaces(subboard);    { strip spaces }

      p:=ListIndex(subboard);   { get list index, if valid subboard name }
      if (p=Nil) or (p^.fname<>subboard) then begin
        writeln('Invalid subboard. Try again.');
        valid:=false;
      end else valid:=true;

    until valid;

    if OpenSub(subboard,Mainsub,Allfiles) then begin     { Open subboard }

      { initialize message pointer }
      new(msg);
      clearmsg(msg);

      { input text file name and open text file }
      writeln;
      repeat
        writeln('Enter Textfile Name: ');
        readln(filename);
        assign(inputfile,filename);
        {$I-} reset(inputfile); {$I+}

        if IOResult=0 then valid:=true
        else begin
          writeln('Could not open file. Try again.');
          valid:=false;
        end;
      until valid;

      { read text from file into memory }
      while (not eof(inputfile)) and (msg^.msglen<=MaxLines) do begin
        readln(inputfile,s);
        if length(s)>MaxLinlen
          then s:=copy(s,1,maxlinlen);    { truncate if necessary }
        AddLine(msg,s);
      end;
      close(inputfile);

      { create a header }
      fillchar(header,sizeof(header),0);
      with header do begin
        from:='GUEST';
        touser:='SYSOP';
        subj:='Text of file '+filename;
        dosdate(date);
        dostime(time);
      end;

      { post the message }
      result:=MsgPost(msg,header,0,true,true);

      { discard the text in memory }
      DisposeMsg(msg);

      { close the subboard }
      CloseSub(Mainsub);

    end
    else writeln('Error opening subboard!');

    CloseUserFile;
    CloseAllFiles;
  end
  else writeln('Could not open CONFIG File!');

end.