unit DistSort;
{=============================================}
{            James L. Allison                 }
{            1703 Neptune Lane                }
{            Houston, Texas  77062            }
{            Dec 22, 1988                     }
{=============================================}

{ Please feel free to use any part of this in any of your programs.}
interface
   uses TypeSpec,Sorting;

procedure DistributionSort(var X:List; N:integer);
{  This is a real screamer, but it takes a lot of space,
   and is hard to package for inclusion in a library.  It
   requires prior knowledge of how the array and keys are structured.
   It is only feasible where there are a small number of possible
   keys.  In this example, there are only 256 different values.
   It works well, for example, where the key is sex, department
   or state.  It would be a disaster if the keys were name or
   phone number.

   The strategy is to copy the array into a save area, and count
   the number of each key present.  The original array is then
   marked off into bins of the appropriate size.  After that, the
   records are copied (like dealing cards) into the proper bin.  }
(*---------------------------------------------------------------------*)

implementation

(*---------------------------------------------------------------------*)
procedure DistributionSort(var X:List; N:integer);
var
   Bins,Start:array[byte] of integer;
   I,Pos:integer;
   Save:Screen_Buffer;
   begin
      for I:=0 to 255 do Bins[I]:=0;
      Start:=Bins;

      for I:=0 to N-1 do          {copy array to scratch area}
      begin
         Save[I]:=X[I];
         inc (Bins[X[I][Value]]); {count the number of each key value}
      end;

      Pos:=0;
      for I:=1 to 255 do
      begin
         inc(Pos,Bins[I-1]);      {compute the start position of each bin}
         Start[I]:=Pos;
      end;

      for I:=0 to N-1 do          {deal the saved array back to the original}
      begin
         X[Start[Save[I][Value]]]:=Save[I];
         inc(Start[Save[I][Value]]);
      end;

   end;

   begin
   end.
