{$A+,B-,V+}
{$M 16384,0,655360}

{.HI}

UNIT MpStrObj;

{
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Unit.....: MpStrObj                                                       *
 * Function.: Unit to create a String Object with methods for the object.    *
 * Author...: Mark C. Paxton                                                 *
 * Date.....: June 27, 1989                                                  *
 * Test File: TSTROBJ.PAS (This file executes several tests of this unit.)   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
}

(*

           Short Description of the methods in MpStrObj.PAS Unit


  MpStrObj is a  unit that implements a String  Object with several methods
  for manipulating the Object. Each of the methods is documented below.


---------------------------------------------------------------------------
FUNCTION CountOccurencesOfChar(CaseInsensitive:Boolean;C:Char):Integer;
---------------------------------------------------------------------------

  This method returns a count of the number of time it finds character C in
  the  String Object.  CaseInsensitive is  a Boolean  indicator to  control
  whether the count  is case sensitive or not.  If CaseInsensitive is TRUE,
  then both  the lower and  upper case occurrences  of a character  will be
  counted as a match.

---------------------------------------------------------------------------
FUNCTION Len:Integer;
---------------------------------------------------------------------------

  This method returns the length of the current string object.

---------------------------------------------------------------------------
FUNCTION PositionWhere(aString2:String):Integer;
---------------------------------------------------------------------------

  This  method  implements  a case insensitive POS function  for the String
  Object.

---------------------------------------------------------------------------
FUNCTION Show:String;
---------------------------------------------------------------------------

  This method simply shows or returns  the value of the string object. This
  is the counterpart to the Assign method.

---------------------------------------------------------------------------
PROCEDURE Assign(S:String);
---------------------------------------------------------------------------

  This method assigns  a new value to the string  object. See also the Show
  method.

---------------------------------------------------------------------------
PROCEDURE ConstructStringOf(C:Char; N:Integer);
---------------------------------------------------------------------------

  This method assigns the C character N times to the string object.

  For example:

        Var aString : StringObject;
        ...
        begin
          aString.ConstructStringOf('-',14);

  The above assigns 14 -'s to the string object.

---------------------------------------------------------------------------
PROCEDURE DeleteChars(P,L:Integer);
---------------------------------------------------------------------------

  This  method deletes  L characters   from the  string object  starting at
  position P.

  For example:

        Var aString : StringObject;
        ...
        begin
                         {         1     }
                         {123456789012345}
          aString.Assign('This is a test.');
          aString.DeleteChars ( 10, 5 );

  The above causes the string object to be changed to:

          "This is a."

---------------------------------------------------------------------------
PROCEDURE InsertNewChars(P:Integer; newString:String);
---------------------------------------------------------------------------

  This method inserts the newString into the String Object at position P.

---------------------------------------------------------------------------
PROCEDURE MakeUpperCase;
---------------------------------------------------------------------------

  This method turns every character in the String Object into its uppercase
  form.

---------------------------------------------------------------------------
PROCEDURE PadString(L:Byte);
---------------------------------------------------------------------------

  This method changes the length of the  String Object to Length L. If L is
  less than  the current length  of the  string,  it is truncated.  If L is
  greater than the current length of the string, it will be padded out with
  blanks.

---------------------------------------------------------------------------
PROCEDURE ReplaceAll(FromString, ToString:String);
---------------------------------------------------------------------------

  This method finds  all occurrences of the characters  in the "FromString"
  and changes them to the characters in the "ToString".

---------------------------------------------------------------------------
PROCEDURE StripLeadingSpaces;
---------------------------------------------------------------------------

  This method  strips any leading blanks  from the beginning of  the String
  Object.

---------------------------------------------------------------------------
PROCEDURE StripTrailingSpaces;
---------------------------------------------------------------------------

  This method strips any trailing blanks from the end of the String Object.

*)


{-----------------------------------------------------------------------------}

                                 INTERFACE

{-----------------------------------------------------------------------------}

TYPE


  StringObjectPointer        = ^StringObject;


  StringObject =

  OBJECT                                                 { String object type }

    St                       : String;

    PROCEDURE Assign(S:String);
    PROCEDURE PadString(L:Byte);
    PROCEDURE InsertNewChars(P:Integer; newString:String);
    PROCEDURE DeleteChars(P,L:Integer);
    PROCEDURE MakeUpperCase;
    PROCEDURE StripLeadingSpaces;
    PROCEDURE StripTrailingSpaces;
    PROCEDURE ReplaceAll(FromString, ToString:String);
    PROCEDURE ConstructStringOf(C:Char; N:Integer);

    FUNCTION CountOccurencesOfChar(CaseInsensitive:Boolean;C:Char):Integer;
    FUNCTION Len:Integer;
    FUNCTION Show:String;
    FUNCTION PositionWhere(aString2:String):Integer;

  END;                                                      { of StringObject }

{-----------------------------------------------------------------------------}

                                IMPLEMENTATION

{-----------------------------------------------------------------------------}


{=============================================================================}
{ Assign                                                                      }
{-----------------------------------------------------------------------------}
PROCEDURE StringObject.Assign(S : String);

BEGIN

  St := S;

END;                                                                 { Assign }
{=============================================================================}

{=============================================================================}
{ Len                                                                         }
{-----------------------------------------------------------------------------}
FUNCTION StringObject.Len  : Integer;

BEGIN

  Len := Length(St);

END;                                                                    { Len }
{=============================================================================}

{=============================================================================}
{ Show                                                                        }
{-----------------------------------------------------------------------------}
FUNCTION StringObject.Show : String;

BEGIN

  Show := St;

END;                                                                  { Show  }
{=============================================================================}

{=============================================================================}
{ PadString                                                                   }
{-----------------------------------------------------------------------------}
PROCEDURE StringObject.PadString(L : Byte);
 {- Pad St out to Len with blanks/spaces }

VAR
  OldLength                  : Byte;

BEGIN

  {Save the old lenght of the String}
  OldLength := StringObject.Len;

  {Force the length of the string to be the value of L.}
  {$R-}
    St[0] := Chr(L);
  {$R+}

  {Pad the string with blanks if the string is being enlarged.}
  IF OldLength < L THEN FillChar(St[OldLength + 1], L - OldLength, ' ');

END;                                                              { PadString }
{=============================================================================}

{=============================================================================}
{ InsertNewChars                                                                 }
{-----------------------------------------------------------------------------}
PROCEDURE StringObject.InsertNewChars(P : Integer; newString : String);

VAR
  aString                    : String;
  I                          : Integer;

BEGIN

  IF Length(newString) = 0 THEN Exit;
  aString := '';
  FOR I := 1 TO P - 1 DO aString := aString + St[I];
  aString := aString + newString;
  FOR I := P TO (Length(St)) DO aString := aString + St[I];
  St := aString;

END;                                                         { InsertNewChars }
{=============================================================================}

{=============================================================================}
{ DeleteChars                                                                 }
{-----------------------------------------------------------------------------}
PROCEDURE StringObject.DeleteChars(P, L : Integer);

VAR
  aString                    : String;
  I                          : Integer;

BEGIN

  IF Length(St) = 0 THEN Exit;
  aString := '';
  FOR I := 1 TO P - 1 DO aString := aString + St[I];
  FOR I := P + L TO Length(St) DO aString := aString + St[I];
  St := aString;

END;                                                            { DeleteChars }
{=============================================================================}

{=============================================================================}
{ MakeUpperCase                                                                   }
{-----------------------------------------------------------------------------}
PROCEDURE StringObject.MakeUpperCase;

VAR I                      : Integer;

BEGIN

  FOR I := 1 TO Length(St) DO St[I] := Upcase(St[I]);

END;                                                          { MakeUpperCase }
{=============================================================================}

{=============================================================================}
{ Strip Leading Spaces                                                        }
{-----------------------------------------------------------------------------}
PROCEDURE StringObject.StripLeadingSpaces;

VAR
  StLen                      : Byte;

BEGIN

   StLen := Byte(St[0]);

   WHILE (St[1] = ' ') AND (StLen > 0) DO BEGIN
     Move(St[2], St[1], Pred(StLen));
     StLen := Pred(StLen);
     St[0] := Chr(StLen);
   END;

END;                                                     { StripLeadingSpaces }
{=============================================================================}

{=============================================================================}
{
{-----------------------------------------------------------------------------}
PROCEDURE StringObject.StripTrailingSpaces;

BEGIN

  WHILE (St[Length(St)] = ' ') AND (Length(St) > 0) DO St[0] := Pred(St[0]);

END;                                                    { StripTrailingSpaces }
{=============================================================================}

{=============================================================================}
{ Count Char                                                                  }
{-----------------------------------------------------------------------------}
FUNCTION StringObject.CountOccurencesOfChar(CaseInsensitive : Boolean; C : Char) : Integer;

VAR
  I                          : Integer;
  Count                      : Integer;
  S                          : String;

BEGIN

  S := St;
  IF CaseInsensitive THEN FOR I := 1 TO Length(St) DO S[I] := Upcase(St[I]);
  Count := 0;
  FOR I := 1 TO Length(S) DO IF S[I] = C THEN Inc(Count);
  CountOccurencesOfChar := Count;

END;                                                  { CountOccurencesOfChar }
{=============================================================================}

{=============================================================================}
{ Replace All                                                                 }
{-----------------------------------------------------------------------------}
PROCEDURE StringObject.ReplaceAll(FromString, ToString : String);

VAR
  Posn                       : Integer;
  Match                      : Boolean;
  I                          : Integer;
  SaveSt                     : String;

BEGIN

  { Find all short cuts}

  IF Length(St) = 0 THEN Exit;
  IF Length(FromString)>Length(St) then Exit;
  If Length(FromString)=0 then Exit;

  If St=FromString then begin
    St:=ToString;
    Exit;
  end;

  SaveSt := St;
  Posn := 0;

  REPEAT

    Match := True;
    Inc(Posn);

    FOR I := 1 TO Length(FromString) DO BEGIN
      IF (Posn + I - 1) > 255 THEN BEGIN
        St := SaveSt;
        Exit;
      END;
      IF St[Posn + I - 1] <> FromString[I] THEN Match := False;
    END;

    IF Match THEN BEGIN
      DeleteChars(Posn, Length(FromString));
      InsertNewChars(Posn, ToString);
      Posn := Posn + Length(ToString) - 1;
    END;

  UNTIL Posn = Length(St);

END;                                                             { ReplaceAll }
{=============================================================================}

{=============================================================================}
{ ConstructStringOf                                                             }
{-----------------------------------------------------------------------------}
PROCEDURE StringObject.ConstructStringOf(C : Char; N : Integer);

VAR
  S                          : String;

BEGIN

  IF N < 0 THEN N := 0;
  S[0] := Chr(N);
  FillChar(S[1], N, C);
  St := S;

END;                                                      { ConstructStringOf }
{=============================================================================}

{=============================================================================}
{ Position Where                                                              }
{-----------------------------------------------------------------------------}
FUNCTION StringObject.PositionWhere(aString2 : String) : Integer;

VAR
  aString                    : String;

  FUNCTION UC(S : String) : String;

  VAR
    I                          : Integer;
    aString                    : String;

  BEGIN
    aString[0] := S[0];
    FOR I := 1 TO Length(S) DO aString[I] := Upcase(S[I]);
    UC := aString;
  END;

BEGIN

  aString := UC(St);
  aString2 := UC(aString2);
  PositionWhere := Pos(aString2, aString);

END;                                                          { PositionWhere }
{=============================================================================}

{=============================================================================}
BEGIN

  { Initialization }

END.
{=============================================================================}
