PROGRAM TextDemo;

{Demo of TextIO unit

   demonstration of useful text i/o features with turbo pascal:

     1. large text buffers for speedier handling when needed
     2. complete seek function for text files
     3. write formatted output to a string variable
     4. read contents of a string variable as formatted input

   language:  turbo pascal macintosh "(*MAC-  -MAC*)" comments
         or:  turbo pascal 4.0 ibm.  "(*IBM-  -IBM*)" comments

   by d.g.gilbert
   dogStar software
   po box 302, bloomington, in 47402
   compuserve  71450,1570

   Translated to a unit by Mike Babulic,  (Jan.25,1989)
                           3827 Charleswood Dr. N.W.
                           Calgary, Alberta, CANADA
                           T2L 2C7
                           compuserve: 72307,314
}

{$R-}   { Turn off range checking       }
{$I-}   { Turn off I/O error checking   }

(*IBM-*)
 USES  DOS,
(*-IBM*)
(*MAC-
 USES  memTypes, quickDraw, osIntf, toolIntf,
-MAC*)
   TextIO;

CONST
     BUFSIZE = 32000; { a big text buffer}
VAR
     ch:char;
     f: text;
     s: STRING;
     i: integer;
     r: real;
     b: boolean;
     index: longint;
BEGIN
  writeln;
  writeln('useful Turbo Pascal Text I/O features');
  writeln('by d.g.gilbert, Dec87');
  writeln;

  write('File to Open: '); readln( s);
  IF openText( f, s, forInput, BUFSIZE) THEN BEGIN
   REPEAT
    write('Seek type 0)set, 1)current, 2)end : '); readln( i);
    IF i IN [0..2] THEN BEGIN
      write('Seek index: '); readln( index);
      seekText( f, index, seekType(i));
      readln( f, s); writeln('> ',s);
      END;
   UNTIL NOT (i IN [0..2]);
   CloseText(f);
  END;

  IF OpenText(f,'TEXTDEMO.TST',forOutput, BUFSIZE) THEN BEGIN
    writeln; writeln('Testing BackLn(f)...');

    writeln('   Writing');
    writeln(f,'LINE 1');
    writeln(f,'LINE 2');
    writeln(f,'LINE 3');
    BackLn(f);
    Writeln(f,'000004');
    index := PosText(f);
    close(f);

    writeln('   Reading');
    reset(f);
    repeat
      readln(f,s);
      writeln('      ',s);
    until 'LINE'<>Copy(s,1,4);
    BackLn(f);
    read(f,index);
    writeln('      integer = ',index);

    CloseText(f);
  END;

  writeln;writeln('Testing formatted output to a string');
  i:= 99; r:= 12.34; b:= true;
  openStrIO( f, s, forOutput);
  writeln( f, i:10, r:10:3, b:5);
  closeStrIO( f, s);
  writeln('The formatted string is:');
  writeln( s);

  i:= 0; r:= 0;
  writeln('Testing string to formatted input');
  openStrIO( f, s, forInput);
  read( f, i, r);    {tp can't read booleans}
  closeStrIO( f, s);
  writeln('The read variables are:');
  writeln( i:10, r:10:3);
  write('Hit return...'); readln;
END.

