unit TextStr1;
{**************************}
{***}     Interface    {***}
{**************************}

Uses
  Crt,
  Dos;


Type
  Keys = (NullKey, F1, F2, F3, F4, F5, F6, F7, F8, F9, F10,
            CarriageReturn, Tab, ShiftTab, Bksp, UpArrow,
            DownArrow, RightArrow, LeftArrow, DeleteKey,
            InsertKey, HomeKey, Esc, EndKey, TextKey, FooBarKey,
            NumberKey, Space, PgUp, PgDn, AltA, AltB, AltC, AltD,
            AltE, AltF, AltG, AltH, AltI, AltL, AltM, AltN, AltO,
            AltP, AltU, AltV, AltR, AltS, AltT, AltW, AltX, AltZ);

Const
   BlackGray   = 0+7*16;
   CBlueCyan   = 1+3*16;
   MonoDefault = 7+0*16;
   MonoHighLight = 0+7*16;
   YellowBlue    = 14+1*16;
   YellowRed     = 14+4*16;
   LightCyanBlue = 11+1*16;
   WhiteBlack    = 15+0*16;
   CWhiteGreen   = 15+2*16;

  TheAttr = 14+1*16;

Type
  StrPtr = ^String;
  NumSetType = Set Of Char;
  ColorType = (MonoAttr,BlueCyan,WhiteGreen);


Var
 Numset : NumsetType;
 TitleStr : String;
 ch : Char;
 TitleAttr : Integer;
 Key  : Keys;

Function StrEdit(X,Y : Integer; TotalLength : Integer;
                 S : String;Title : String; CType: ColorType) : String;
Function NumEdit(X,Y : Integer; TotalLength : Integer; S : String;
                 Title : String; CType: ColorType) : String;
Function GetLong(X,Y : Integer; Title : String; StrAttr : Integer) : LongInt;
{*************************}
{***}  Implementation {***}
{*************************}

procedure WriteStr(X, Y: Integer; S: String; Attr: Integer);
var
  SaveAttr: Integer;
begin
  SaveAttr := TextAttr;
  TextAttr := Attr;
  GotoXY(X, Y);
  WriteLn(S);
  TextAttr := SaveAttr;
end;

procedure Beep(Freq, Time : Integer);
begin
  Sound(Freq);
  Delay(Time);
  NoSound;
end;

procedure CursorOff;
var
  Regs : Registers;

begin
  with Regs do begin
    AH :=$01;
    CH :=$20;
    CL :=$20;
  end;
  Intr($10, Regs);
end;

{***********************************************************}

procedure CursorSmall;

var
  Regs : Registers;

begin
  if LastMode <> CO80 then begin
    with Regs do begin
      AH := $01;
      CH := 12;
      CL := 13;
    end;
  end else
  begin
    with Regs Do begin
      AH := $01;
      CH := 6;
      CL := 7;
    end;
  end;
  Intr($10, Regs);
end;

{****************************************************}

procedure CursorBig;
Var
  Regs : Registers;

begin
  If LastMode <> CO80 then begin
    With Regs Do begin
      AH := $01;
      CH := 0;
      CL := 13;
    end;
  end else begin
    with Regs do begin
      AH := $01;
      CH := 0;
      CL := 7;
    end;
  end;
  Intr($10, Regs);
end;

procedure InKey(Var FunctionKey : Boolean;
                    Var ch : Char;
                    beginCursor,
                    endCursor : Char);


  begin
    Case beginCursor Of
      'B' : CursorBig;
      'S' : CursorSmall;
      'O' : CursorOff;
    end;

    FunctionKey := False;
    ch := Readkey;
    If (ch = #0) then
        begin
             FunctionKey := True;
             ch := Readkey;
             end;

        If FunctionKey then
           Case Ord(ch) Of
           15: key := ShiftTab;
           72: key := UpArrow;
           80: key := DownArrow;
           82: key := Insertkey;
           75: key := LeftArrow;
           77: key := RightArrow;
           73: key := PgUp;
           81: key := PgDn;
           71: key := HomeKey;
           79: key := endKey;
           83: key := DeleteKey;
           82: key := InsertKey;
           59: key := F1;
           60: key := F2;
           61: key := F3;
           62: key := F4;
           63: key := F5;
           64: key := F6;
           65: key := F7;
           66: key := F8;
           67: key := F9;
           68: key := F10;
           50: key := AltM;
           49: key := AltN;
           48: key := AltB;
           47: key := AltV;
           46: key := AltC;
           45: key := AltX;
           44: key := AltZ;
           38: key := AltL;
           35: key := AltH;
           34: key := AltG;
           33: key := AltF;
           32: key := AltD;
           31: key := AltS;
           30: key := AltA;
           25: key := AltP;
           24: key := AltO;
           23: key := AltI;
           22: key := AltU;
           20: key := AltT;
           19: key := AltR;
           18: key := AltE;
           17: key := AltW;
           end
        Else
           Case Ord(ch) Of
           8: key := Bksp;
           9: key := Tab;
           13: key := CarriageReturn;
           27: key := Esc;
           32: key := Space;
           33..34, 47, 58..254:
               key := TextKey;
           45..46, 48..57:
               key := NumberKey;
           end;

           Case endCursor Of
           'B' : CursorBig;
           'S' : CursorSmall;
           'O' : CursorOff;
           end;
        end;

function Str2Long(Str:string): Longint;
var
  code : integer;
  Temp : longint;
begin
  if length(Str) = 0 then
    Str2Long := 0
  else
    begin
      val(Str,temp,code);
      if code = 0 then
        Str2Long := temp
      else
        Str2Long := 0;
  end;
end;

Procedure SetAttr(CType: ColorType);
begin
  Case CType of
    MonoAttr: begin
      TitleAttr := MonoDefault;
      TextAttr := MonoHighLight;
    end;
    BlueCyan: begin
      TitleAttr := YellowBlue;
      TextAttr := CBlueCyan;
    end;
    WhiteGreen: begin
      TitleAttr := BlackGray;
      TextAttr := CWhiteGreen;
    end;
  end;
end;

function StrEdit(X,Y : Integer; TotalLength : Integer;
                 S : String;Title : String; CType : ColorType) : String;
var
  P: Integer;
  Ch: Char;
  FuncKey, Start, Stop: Boolean;
  SaveAttr: Integer;

begin
  SaveAttr := TextAttr;
  Key := F1;
  Ch := #1;
  P := 0;
  Start := True;
  Stop := False;
  if LastMode <> CO80 then CType := MonoAttr;
  SetAttr(CType);
  WriteStr(X,Y,Title,TitleAttr);
  X := X + Length(Title);
  repeat
    GotoXY(X, Y);
    Write(S, '': TotalLength - Length(S));
    GotoXY(X+p, Y);
    InKey(FuncKey,Ch,'S','S');
    If (Not FuncKey) and (Key <> CarriageReturn) and (Key <> BkSp) then begin
      If (ch > #31) and (ch < #122) then begin
        if Start then S := '';
        If Length(S) < TotalLength then begin
          Inc(P);
          Insert(Ch, S, P);
        end
        Else Beep(20,20);
      end
    end
    Else begin
    Case Key of
      LeftArrow : if P > 0 then Dec(P);
      RightArrow : if P < Length(S) then Inc(P) else;
      HomeKey: P := 0;
      endKEy: P := Length(S);
      DeleteKey: Delete(S, P + 1, 1);
      Bksp:        if P > 0 then
        begin
          Delete(S, P, 1);
          Dec(P);
        end;
      PgUp:
        begin
          S := '';
          P := 0;
        end;
      PgDn:
        begin
          P := 0;
        end;
      CarriageReturn :
        begin
          Stop := True;
          Beep(20,20);
          P := 0;
        end;
      Esc: Stop := True;
    else
      Beep(20,20);
    end;
    end;
    Start := False;
    if Length(S) > TotalLength then Beep(20,20);
  until Stop;
  TextAttr := SaveAttr;
  StrEdit := S;
end;

Function NumEdit(X,Y : Integer; TotalLength : Integer; S : String;
                 Title : String; CType : ColorType) : String;
{
  I put this in to edit a single field such as the field in
  CSearch procedure. It does not affect any of the existing
  records, or at least, that is my plan.
}
var
  P: Integer;
  Ch: Char;
  FuncKey, Start, Stop: Boolean;
  SaveS : String;
  SaveAttr: Integer;

begin
  SaveAttr:= TextAttr;
  if LastMode <> CO80 then CType := MonoAttr;
  SetAttr(CType);
  NumSet := ['0'..'9'];
  SaveS := S;  { In case the user choose esc }
  Key := F1;
  Ch := #1;
  P := 0;
  Start := True;
  Stop := False;
  WriteStr(X,Y,Title,TitleAttr);
  X := X + Length(Title);
  repeat
    GotoXY(X, Y);
    Write(S, '': TotalLength - Length(S));
    GotoXY(X+p, Y);
    Repeat
      InKey(FuncKey,Ch,'S','S');
    Until (Ch in NumSet) or (Ch = '.') or (Ch = '-') or
          (Ch = ',') or (FuncKey) Or (Key = CarriageReturn) Or
          (Key = Bksp) or (Key = Esc) or (Ch='/');
    If (Not FuncKey) and (Key <> CarriageReturn) and
       (Key <> BkSp) and (Key <> Esc) then begin
      If (ch > #31) and (ch < #122) then begin
        if Start then S := '';
        If Length(S) < TotalLength then begin
           Inc(P);
           Insert(Ch, S, P)
        end
        Else Beep(20,20);
      end
    end
    Else begin
    Case Key of
      LeftArrow : if P > 0 then Dec(P);
      RightArrow : if P < Length(S) then Inc(P) else;
      HomeKey: P := 0;
      endKEy: P := Length(S);
      DeleteKey: Delete(S, P + 1, 1);
      Bksp:
        if P > 0 then begin
          Delete(S, P, 1);
          Dec(P);
        end;
      PgUp:
        begin
          S := '';
          P := 0;
        end;
      PgDn:
        begin
          P := 0;
        end;
      CarriageReturn :
        begin
          Stop := True;
          Beep(20,20);
          P := 0;
        end;
      Esc:
        begin
          Stop := True;
          S := SaveS;
        end;
    else
      Beep(20,20);
    end;
    end;
    Start := False;
    if Length(S) > TotalLength then Stop := True;
  until Stop;
  NumEdit := S;
  TextAttr:= SaveAttr;
end;

Function GetLong(X,Y : Integer; Title : String; StrAttr : Integer) : LongInt;
{
  I put this in to edit a single field such as the field in
  CSearch procedure. It does not affect any of the existing
  records, or at least, that is my plan.
}
var
  P: Integer;
  Ch: Char;
  FuncKey, Start, Stop: Boolean;
  S,
  SaveS : String;

begin
  NumSet := ['0'..'9'];
  S := '';
  SaveS := S;  { In case the user choose esc }
  Key := F1;
  Ch := #1;
  P := 0;
  Start := True;
  Stop := False;
  WriteStr(X,Y,Title,StrAttr);
  X := X + Length(Title);
  repeat
    GotoXY(X, Y);
    Write(S, '': 10 - Length(S));
    GotoXY(X+p, Y);
    Repeat
      InKey(FuncKey,Ch,'S','S');
    Until (Ch in NumSet) or (Ch = '.') or (Ch = '-') or (FuncKey) Or
    (Key = CarriageReturn) Or (Key = Bksp) or (Key = Esc) or (Ch='/');

    If (Not FuncKey) and (Key <> CarriageReturn) and
       (Key <> BkSp) and (Key <> Esc) then begin
      If (ch > #31) and (ch < #122) then begin
        if Start then S := '';
        If Length(S) < 10 then begin
           Inc(P);
           Insert(Ch, S, P)
        end
        Else Beep(20,20);
      end
    end
    Else begin
    Case Key of
      LeftArrow : if P > 0 then Dec(P);
      RightArrow : if P < Length(S) then Inc(P) else;
      HomeKey: P := 0;
      endKEy: P := Length(S);
      DeleteKey: Delete(S, P + 1, 1);
      Bksp:
        if P > 0 then begin
          Delete(S, P, 1);
          Dec(P);
        end;
      PgUp:
        begin
          S := '';
          P := 0;
        end;
      PgDn:
        begin
          P := 0;
        end;
      CarriageReturn :
        begin
          Stop := True;
          Beep(20,20);
          P := 0;
        end;
      Esc:
        begin
          Stop := True;
          S := SaveS;
        end;
    else
      Beep(20,20);
    end;
    end;
    Start := False;
    if Length(S) > 40 then Stop := True;
  until Stop;
  GetLong := Str2Long(S);
end;

end.