(* Turbo Pascal 5.0 Math Functions *)
unit MATH;
{$IFDEF VER40} {$N+} {$ELSE} {$N+,E+} {$ENDIF}

interface
Function Power( base, exponent : Real ) : Real; {power of base raised
                                                  to exponent}
Function Log( argument : Real ) : Real;  { log (base10) of argument}
Function Rad( degrees : Real ) : Real;    {convert radians to degrees}
Function Deg( radians : Real ) : Real;    {convert degrees to radians}
Function Fact( x : Integer) : Double;   {factorial of x}
Function Perm( n, r : Integer) : Double; {permutations of n taken r at
                                         a time}
Function Comb( n, r : Integer) : Double; {combinations of n taken r at
                                         a time}


implementation
Function Power( base, exponent : Real) : Real;
         begin
              Power := EXP( exponent * LN( base))
         end; {Power}
Function Log( argument : Real) : Real;
         const BASE = 10;
         begin
              Log := Ln( argument ) / Ln( BASE )
         end; {Log}
Function Rad( degrees : Real) : Real;
         const DEGCONVERT = 180.0;
         begin
              Rad := Degrees * Pi / DEGCONVERT
         end; {Rad}
Function Deg( Radians : Real) : Real;
         const RADCONVERT = 180.0;
         begin
              Deg := Radians * RADCONVERT / Pi
         end; {Deg}
Function Fact( x : Integer ) : Double;
         var loop : Integer; mult : Double;
             begin
                  mult := 1;
                  For loop :=1 To x Do
                      mult := mult * loop;
                  Fact := mult
             end; {Fact}
Function Perm( n, r : Integer ) : Double;
         begin
              Perm := Fact( n ) / Fact( n - r )
         end; {Perm}
Function Comb( n, r : Integer ) : Double;
         begin
              Comb := Perm( n, r ) / Fact( r )
         end; {Comb}
end. {Math unit}

