(******************************************************************************)
(*                      Hydra Bi-directional Protocol                         *)
(*                                                   *)
(*                                                                            *)
(*                        HYDRA CONSTANT DEFINITIONS                          *)
(*                                                                            *)
(* BY: Adam Blake                                      Wandoo Valley Software *)
(*     Arjen Lentz                                         and Lentz Software *)
(* VER: 1.00                                                      Development *)
(* DATE: 5th August 1993                                   (c) Copyright 1993 *)
(* LANGUAGE: Turbo Pascal v6.0                  All Rights Reserved Worldwide *)
(******************************************************************************)

const
  (*HYDRA Specification Revision/Timestamp-----------Revision----Date--------*)
  H_REVSTAMP    = $2B1AAB00;                      (* 001         01 Dec 1992 *)
  H_REVISION    = 1;

  XON           = 17;                   (* Ctrl-Q (^Q) Xmit-On character     *)
  XOFF          = 19;                   (* Ctrl-S (^S) Xmit-Off character    *)

  H_DLE         = 24;                   (* Ctrl-X (^X) HYDRA DataLinkEscape  *)
  H_MINBLKLEN   = 64;                   (* Min. length of a HYDRA data block *)
  H_MAXBLKLEN   = 2048;                 (* Max. length of a HYDRA data block *)
  H_OVERHEAD    = 8;                    (* Max. no. control bytes in a pkt   *)
  H_MAXPKTLEN   = ((H_MAXBLKLEN + H_OVERHEAD + 5) * 3);       (* Encoded pkt *)
  H_BUFLEN      = (H_MAXPKTLEN + 16);   (* Buffer sizes: max.enc.pkt + slack *)
  H_PKTPREFIX   = 31;                   (* Max length of pkt prefix string   *)
  H_FLAGLEN     = 3;                    (* Length of a flag field            *)
  H_RETRIES     = 10;                   (* No. retries in case of an error   *)
  H_MINTIMER    = 10;                   (* Minimum timeout period            *)
  H_MAXTIMER    = 60;                   (* Maximum timeout period            *)
  H_START       = 5;                    (* Timeout for re-sending startstuff *)
  H_IDLE        = 20;                   (* Idle? TX IDLE pkt every 20 secs   *)
  H_BRAINDEAD   = 120;                  (* Braindead in 2 mins (120 secs)    *)

(*HYDRA Result Codes---------------------------------------------------------*)
  XFER_ABORT    = -1;                   (* Failed on this file & abort xfer  *)
  XFER_SKIP     = 0;                    (* Skip this file but continue xfer  *)
  XFER_OK       = 1;                    (* File was sent, continue transfer  *)

(*HYDRA Transmitter States---------------------------------------------------*)
  HTX_DONE      = 0;                    (* All over and done                 *)
  HTX_START     = 1;                    (* Send start autostr + START pkt    *)
  HTX_SWAIT     = 2;                    (* Wait for any pkt or timeout       *)
  HTX_INIT      = 3;                    (* Send INIT pkt                     *)
  HTX_INITACK   = 4;                    (* Wait for INITACK pkt              *)
  HTX_RINIT     = 5;                    (* Wait for HRX_INIT -> HRX_FINFO    *)
  HTX_FINFO     = 6;                    (* Send FINFO pkt                    *)
  HTX_FINFOACK  = 7;                    (* Wait for FINFOACK pkt             *)
  HTX_XDATA     = 8;                    (* Send next packet with file data   *)
  HTX_DATAACK   = 9;                    (* Wait for DATAACK packet           *)
  HTX_XWAIT     = 10;                   (* Wait for HRX_END                  *)
  HTX_EOF       = 11;                   (* Send EOF pkt                      *)
  HTX_EOFACK    = 12;                   (* End of file, wait for EOFACK pkt  *)
  HTX_REND      = 13;                   (* Wait for HRX_END AND HTD_DONE     *)
  HTX_END       = 14;                   (* Send END pkt (finish session)     *)
  HTX_ENDACK    = 15;                   (* Wait for END pkt from other side  *)

(*HYDRA Device Packet Transmitter States-------------------------------------*)
  HTD_DONE      = 0;                    (* No device data pkt to send        *)
  HTD_DATA      = 1;                    (* Send DEVDATA pkt                  *)
  HTD_DACK      = 2;                    (* Wait for DEVDACK pkt              *)

(*HYDRA Receiver States------------------------------------------------------*)
  HRX_DONE      = 0;                    (* All over and done                 *)
  HRX_INIT      = 1;                    (* Wait for INIT pkt                 *)
  HRX_FINFO     = 2;                    (* Wait for FINFO pkt of next file   *)
  HRX_DATA      = 3;                    (* Wait for next DATA pkt            *)

(*HYDRA Packet Types---------------------------------------------------------*)
  HPKT_START    = 'A';                  (* Startup sequence                  *)
  HPKT_INIT     = 'B';                  (* Session initialisation            *)
  HPKT_INITACK  = 'C';                  (* Response to INIT pkt              *)
  HPKT_FINFO    = 'D';                  (* File info (name, size, time)      *)
  HPKT_FINFOACK = 'E';                  (* Response to FINFO pkt             *)
  HPKT_DATA     = 'F';                  (* File data packet                  *)
  HPKT_DATAACK  = 'G';                  (* File data position ACK packet     *)
  HPKT_RPOS     = 'H';                  (* Transmitter reposition packet     *)
  HPKT_EOF      = 'I';                  (* End of file packet                *)
  HPKT_EOFACK   = 'J';                  (* Response to EOF packet            *)
  HPKT_END      = 'K';                  (* End of session                    *)
  HPKT_IDLE     = 'L';                  (* Idle - just saying I'm alive      *)
  HPKT_DEVDATA  = 'M';                  (* Data to specified device          *)
  HPKT_DEVDACK  = 'N';                  (* Response to DEVDATA pkt           *)

  HPKT_HIGHEST  = 'N';                  (* Highest known pkttype in this imp *)

(*HYDRA Internal Pseudo Packet Types-----------------------------------------*)
  H_NOPKT       =  0;                   (* No packet (yet)                   *)
  H_CANCEL      = -1;                   (* Received cancel sequence 5*Ctrl-X *)
  H_CARRIER     = -2;                   (* Lost carrier                      *)
  H_SYSABORT    = -3;                   (* Aborted by operator on this side  *)
  H_TXTIME      = -4;                   (* Transmitter timeout               *)
  H_DEVTXTIME   = -5;                   (* Device transmitter timeout        *)
  H_BRAINTIME   = -6;                   (* Braindead timeout (quite fatal)   *)

(*HYDRA Packet Format: START[<data>]<type><crc>END --------------------------*)
  HCHR_PKTEND   = 'a';                  (* End of packet (any format)        *)
  HCHR_BINPKT   = 'b';                  (* Start of binary packet            *)
  HCHR_HEXPKT   = 'c';                  (* Start of hex encoded packet       *)
  HCHR_ASCPKT   = 'd';                  (* Start of shifted 7bit encoded pkt *)
  HCHR_UUEPKT   = 'e';                  (* Start of uuencoded packet         *)

(*HYDRA Local Storage of INIT Options (Bitmapped)----------------------------*)
  HOPT_XONXOFF  = $00000001;            (* Escape XON/XOFF                   *)
  HOPT_TELENET  = $00000002;            (* Escape CR-'@'-CR (Telenet escape) *)
  HOPT_CTLCHRS  = $00000004;            (* Escape ASCII 0-31 and 127         *)
  HOPT_HIGHCTL  = $00000008;            (* Escape above 3 with 8th bit too   *)
  HOPT_HIGHBIT  = $00000010;            (* Escape ASCII 128-255 + strip high *)
  HOPT_CANBRK   = $00000020;            (* Can transmit a break signal       *)
  HOPT_CANASC   = $00000040;            (* Can transmit/handle ASC packets   *)
  HOPT_CANUUE   = $00000080;            (* Can transmit/handle UUE packets   *)
  HOPT_CRC32    = $00000100;            (* Packets with CRC-32 allowed       *)
  HOPT_DEVICE   = $00000200;            (* DEVICE packets allowed            *)
  HOPT_FPT      = $00000400;            (* Can handle filenames with paths   *)

(*What we can do*)
  HCAN_OPTIONS  = (HOPT_XONXOFF OR HOPT_TELENET OR HOPT_CTLCHRS OR HOPT_HIGHCTL
                   OR HOPT_HIGHBIT OR HOPT_CANBRK OR HOPT_CANASC OR HOPT_CANUUE
                   OR HOPT_CRC32 OR HOPT_DEVICE);

(*Vital options if we ask for any; abort if other side doesn't support them*)
  HNEC_OPTIONS  = (HOPT_XONXOFF OR HOPT_TELENET OR HOPT_CTLCHRS OR HOPT_HIGHCTL
                   OR HOPT_HIGHBIT OR HOPT_CANBRK);

(*Non-vital options; nice if other side supports them, but doesn't matter*)
  HUNN_OPTIONS  = (HOPT_CANASC OR HOPT_CANUUE OR HOPT_CRC32 OR HOPT_DEVICE);

(*Default options*)
   HDEF_OPTIONS = $0;

(*RxOptions during init (needs to handle ANY link yet unknown at that point*)
   HRXI_OPTIONS = (HOPT_XONXOFF OR HOPT_TELENET OR HOPT_CTLCHRS OR HOPT_HIGHCTL
                   OR HOPT_HIGHBIT);

(*Ditto, but this time TxOptions*)
   HTXI_OPTIONS = $0;

(*END of Hydra.inc*)
