{$A+,B-,D-,E-,F-,I-,L-,N-,O+,R-,S-,V-}
(******************************************************************************)
(*                      Hydra Bi-directional Protocol                         *)
(*                                                   *)
(*                                                                            *)
(*                         Unix Date/Time Routines                            *)
(*                                                                            *)
(* BY: Adam Blake                                      Wandoo Valley Software *)
(*     Arjen Lentz                                         and Lentz Software *)
(* VER: 1.00                                                      Development *)
(* DATE: 5th August 1993                                   (c) Copyright 1993 *)
(* LANGUAGE: Turbo Pascal v6.0                  All Rights Reserved Worldwide *)
(******************************************************************************)
Unit h_Date;
Interface

uses
  DOS;


Function h_ToUnixDate( FDate : longint ) : longint;

Function h_FromUnixDate( UnixDate : longint ) : longint;

(******************************************************************************)
Implementation

const
  C1970 = 2440588;
  D0    =    1461;
  D1    =  146097;
  D2    = 1721119;


Procedure GregorianToJulianDN( Year, Month, Day : integer;
                               var JulianDN : longint );
var
  Century,
  XYear    : longint;
begin
  If Month <= 2 then
    begin
      Year  := Pred(Year);
      Month := Month + 12;
    end;
  Month    := Month - 3;
  Century  := Year div 100;
  XYear    := Year mod 100;
  Century  := (Century * D1) shr 2;
  XYear    := (XYear * D0) shr 2;
  JulianDN := ((((Month * 153) + 2) div 5) + Day) + D2 + XYear + Century;
end;


Procedure JulianDNToGregorian( JulianDN : longint;
                               var Year, Month, Day : integer );
var
  Temp,
  XYear   : longint;
  YYear,
  YMonth,
  YDay    : integer;
begin
  Temp     := (((JulianDN - D2) shl 2) - 1);
  XYear    := (Temp mod D1) or 3;
  JulianDN := Temp div D1;
  YYear    := (XYear div D0);
  Temp     := ((((XYear mod D0) + 4) shr 2) * 5) - 3;
  YMonth   := Temp div 153;
  If YMonth >= 10 then
    begin
      YYear  := YYear + 1;
      YMonth := YMonth - 12;
    end;
  YMonth := YMonth + 3;
  YDay   := Temp mod 153;
  YDay   := (YDay + 5) div 5;
  Year   := YYear + (JulianDN * 100);
  Month  := YMonth;
  Day    := YDay;
end;


Function h_ToUnixDate( FDate : longint ) : longint;
var
  DT       : DateTime;
  DateNum,
  SecsPast,
  DaysPast : longint;
begin
  UnpackTime(FDate,DT);
  GregorianToJulianDN(DT.Year,DT.Month,DT.Day,DateNum);
  DaysPast := DateNum - c1970;
  SecsPast := DaysPast * 86400;
  SecsPast := SecsPast + DT.Hour * 3600 + DT.Min * 60 + DT.Sec;
  h_ToUnixDate := SecsPast;
end;


Function h_FromUnixDate( UnixDate : longint ) : longint;
var
  DT       : DateTime;
  DateNum  : longint;
  n        : word;
begin
  DateNum := (UnixDate div 86400) + c1970;
  JulianDNToGregorian(DateNum,integer(DT.Year),integer(DT.Month),integer(DT.Day));
  UnixDate := UnixDate mod 86400;
  DT.Hour  := UnixDate div 3600;
  UnixDate := UnixDate mod 3600;
  DT.Min   := UnixDate div 60;
  DT.Sec   := UnixDate mod 60;
  PackTime(DT,UnixDate);
  h_FromUnixDate := UnixDate;
end;

(**********************************MAINLINE************************************)

end.

