

Procedure Crc_gen( Var s; length : Integer);

(*
   This CCITT (16 bit) CRC generation routine was adapted from the
 Public Domain program FILETEST and this particular routine was
 written by David Dantowitz of DEC.  The routine has been modified
 for use with The SelfChk Unit to the point where it may be barely
 recognizable.
                                    - Mike Durkin
 *)
   

Begin

inline(

$c4/$7e/<s/                {les di,s[bp]              (es:di points to array)}
$A1/crc_ccitt/             {mov ax,crc_ccitt          (initial CRC value)    }
$8b/$8e/length/            {mov cx,length             (# bytes to compute)   }
$be/table_ccitt/           {mov si,offset table_ccitt (table address)        }


{ next:  }

$26/$32/$05/               {xor al,es:[di]          CRC = CRC XOR next byte  }
$47/                       {inc di                  (point to next byte)     }

{ intermediate steps, see comments for overall effect }

$31/$db/                   {xor bx,bx               (bx <- 0)                }
$86/$d8/                   {xchg al,bl              (bx <- ax and 0FF)       }
$86/$e0/                   {xchg al,ah              (ax <- ax shr 8)         }
$d1/$e3/                   {shl bx,1                (bx <- bx+bx)            }

$33/$00/                   {xor ax,[bx+si]          CRC = (CRC shr 8) XOR
                                                          table[CRC and 0FF] }

$e2/$f0/                   {loop next               (count <- count -1)      }

$A3/crc_ccitt);            {mov crc_ccitt,ax        (crc_ccitt := CRC)       }


(*  basic algorithm expressed above

crc_ccitt := initial_crc

For each byte Do
Begin
  crc := crc XOR next_byte;
  crc := (crc shr 8) XOR table_ccitt [crc and $FF];
End;

crc_ccitt := crc;
*)
End;
