/* Listing 2. */

#include <stdlib.h>
#include <stdio.h>

#define TEST
#include "listing4.h"

/* this function allocates a num_elem array of
   pointers to arrays of integers. it then allocates
   the arrays themselves*/
int **target(int num_elem,int elem_size)
{
  int  **master;
  int  index = 0;

  /* allocate an array of pointers */
  master = calloc(num_elem,sizeof(int *));
  if(master != NULL)
  {
     /* allocate the arrays of ints */
     do
     {
        master[index] = calloc(elem_size,sizeof(int));
        if(master[index] == NULL)
        {
           /* back out gracefully */
           return NULL;
        }
     } while(index < num_elem);
     return master;
  }
  else
     return NULL;
}

/******** beginning of test code **********/
#if defined( TEST )

int testTarget( void )
{
  int  **master;

  /* macro defined in Listing 4. This macro must
     follow all local variable declarations and
     precede any code statements. */
  StartTest( "target()" );

  /* specify failure on first allocation attempt */
  SetCalloc( 0 );
  if((master = target(10,10)) != NULL)
     ErrorMsg( 1, "Target failed out of memory test");

  /* specify failure on second allocation */
  SetCalloc( 1 );
  if((master = target(10,10)) != NULL)
     ErrorMsg( 2, "Target failed out of memory test" );

  EndTest;
}

main()
{
  if(testTarget() > 0)
     printf("\a%d errors detected in target()\n");
}
#endif /* end of test code */
