/* Listing 4

    Defines macros for accessing test versions of
    calloc and malloc and for collecting and reporting
    errors.
*/
#if defined( TEST )
  #include <stddef.h>

  /* macro to print error message */
  #define ErrorMsg(testNumber,msg) \
     (fprintf(stderr,"\n\t\a%d)%s",testNumber,msg),\
     ++errors)

  /* macro to initialize error counter and display
     start message*/
  #define StartTest(list) \
     int  errors = 0; \
     fprintf(stderr,"\nTesting %s...\n",list)

  /* macro to report results */
     #define EndTest \
        {  \
           if(errors) \
              fprintf(stderr, \
                      "\n%d errors detected\n"); \
           else \
              fprintf(stderr,"Success\n"); \
           return errors; \
        }

    /* re-direct calloc and malloc to test versions */
    #define calloc(x,y) testCalloc(x,y)
    #define malloc(x)   testMalloc(x)

    /* prototype calloc and malloc shell functions */
    void    *testCalloc( size_t numElems,
                         size_t elemSize );
    void    *testMalloc( size_t numElems );

    /* prototypes to set the number of times calloc
       and malloc will work before failing */
    void    SetCalloc( int passes );
    void    SetMalloc( int passes );

#endif
