Library MidiInfo;
{
  Copyright (c) June 1993, by Charlie Calvert
  Feel free to use this code as an adjunct to your own programs.
}

uses
  MMSystem,
  PlayInfo,
  Strings,
  WinCrt,
  WinProcs,
  WinTypes;

const
  MsgLen = 200;

procedure PauseMidi; export;
var
  Info: TMci_Generic_Parms;
  Flags: LongInt;
  S1: array[0..MsgLen] of Char;
  Result: LongInt;
begin
  Info.dwCallBack := 0;
  Flags := 0;
  Result := mciSendCommand(wDeviceID, Mci_Pause, Flags, LongInt(@Info));
  ErrorMsg(Result, S1);
end;


function GetMidiInfo(S: PChar): PChar; export;
var
  Info: TMci_Info_Parms;
  Flags: LongInt;
  S1: array[0..MsgLen] of Char;
  Result: LongInt;
begin
  Info.dwCallBack := 0;
  Info.lpstrReturn := S;
  Info.dwRetSize := MsgLen;
  Flags := Mci_Notify or Mci_Info_Product;
  Result := mciSendCommand(wDeviceID, Mci_Info, Flags, LongInt(@Info));
  ErrorMsg(Result, S1);
  GetMidiInfo := S;
end;

function CheckForMapper: Boolean; export;
const
  S:PChar = ('Midi Mapper is not available, Continue?');
var
  Flags: LongInt;
  Result: LongInt;
  StatusParms: TMci_Status_Parms;
  Sti: Integer;
begin
  CheckForMapper := False;
  StatusParms.dwItem := Mci_Seq_Status_Port;
  Flags := Mci_Status_Item;
  Result := MciSendCommand(wDeviceID, Mci_Status, Flags, LongInt(@StatusParms));
  if Result <> 0 then begin
    CloseMci;
    Exit;
  end;

  StI := LoWord(StatusParms.dwReturn);
  if (Sti <> Midi_Mapper) then begin
    if(MessageBox(0, S, 'Query', mb_YesNo) <> IDYes) then begin
      CloseMci;
      exit;
    end;
  end;
  CheckForMapper := True;
end;

exports
  ErrorMsg index 1,
  OpenMci index 2,
  CloseMci index 3,
  PlayMci index 4,
  PauseMidi index 5,
  GetMidiInfo index 6,
  CheckForMapper index 7,
  SetTimeFormatMS index 8,
  GetLocation index 9,
  StopMci index 10,
  GetInfo index 11,
  GetDeviceId index 12,
  GetLen index 13,
  GetMode index 14;

begin
end.