unit MidiPlay;

{ 
  MidiPlay                                     
  Programmer: Charlie Calvert                  
  Date: March 1993                             

  Copyright (c) June 1993, by Charlie Calvert
  Feel free to use this code as an adjunct to your own programs.

  This unit currently has the name and path of a MIDI file
  hard coded into it. Therefore, it will not play if it can't
  find the path and file on your system. Obviously this means
  there are features I still want to add to this unit. The
  file should be installed on all Windows systems, however.
}

interface

uses
  MidiUnit, MMSystem, ODialogs, OWindows, PlayDlg,
  PlayerId, Strings, WinDos, WinTypes, WinProcs;

const
  DevType:PChar = 'Sequencer';
  FileName:PChar = 'c:\windows\canyon.mid';


type
  PMidiDlg = ^TMidiDlg;
  TMidiDlg = Object(TPlayDialog)
      Location: LongInt;
      CurTime, LenText, DevInfo: PStatic;
      FileBox: PListBox;
      EdCurDir: PEdit;
    constructor Init(AParent: PWindowsObject; AName: PChar);
    destructor Done; virtual;
    procedure SetUpWindow; virtual;
    procedure ReportStatus; virtual;
    procedure GetDirectoryInfo(var Msg: TMessage);
      virtual Wm_First + Wm_FillDir;
    procedure MciNotify(var Msg: TMessage);
      virtual wm_First + mm_MciNotify;
    procedure MidiAbort(var Msg: TMessage);
      virtual id_First + idAbort;
    procedure MidiOpen(var Msg: TMessage);
      virtual id_First + id_MidiOpen;
    procedure MidiPause(var Msg: TMessage);
      virtual id_First + id_MidiPause;
    procedure MidiPlay(var Msg: TMessage);
      virtual id_First + id_MidiPlay;
    procedure WmTimer(var Msg: TMessage);
      virtual wm_First + wm_Timer;
  end;

implementation

constructor TMidiDlg.Init(AParent: PWindowsObject; AName: PChar);
begin
  inherited Init(AParent, AName);
  CurTime := New(PStatic, InitResource(@Self, id_MidiNumTracks, MinLen));
  LenText := New(PStatic, InitResource(@Self, id_MidiLenInfo, MinLen));
  DevInfo := New(PStatic, InitResource(@Self, id_MidiDevInfo, MinLen));
  FileBox := New(PListBox, InitResource(@Self, id_WaveList));
  EdCurDir := New(PEdit, InitResource(@Self, id_WaveCurDir, MaxLen));
end;

destructor TMidiDlg.Done;
begin
  if GetDeviceId <> 0 then CloseMci;
  inherited Done;
end;

procedure TMidiDlg.SetUpWindow;
begin
  inherited SetUpWindow;
  Location := 0;
  StrCopy(WildCard, '*.mid');
  GetWindowsDirectory(CurrentDirectory, MaxLen);
  SetCurDir(CurrentDirectory);
  PostMessage(HWindow, Wm_FillDir, 0, 0);
end;

procedure TMidiDlg.GetDirectoryInfo(var Msg: TMessage);
var
  S: array[0..15] of Char;
begin
  SetCurDir(CurrentDirectory);
  StrCopy(S, WildCard);
  if FileBox^.GetCount > 0 then FileBox^.ClearList;
  SendMessage(FileBox^.HWindow, LB_DIR, DDL_ARCHIVE, LongInt(@S));
  FileBox^.SetSelIndex(0);
  EdCurDir^.SetText(CurrentDirectory);
end;

procedure TMidiDlg.ReportStatus;
begin
  Mode := GetMode;
  GetStatus;
end;

procedure TMidiDlg.MciNotify(var Msg: TMessage);
begin
  KillTimer(HWindow, PlayTimer);
  ReportStatus;
  if Mode = Mci_Mode_Stop then CloseMci;
end;

procedure TMidiDlg.MidiAbort(var Msg: TMessage);
begin
  StopMCI;
  ReportStatus;
end;

procedure TMidiDlg.MidiOpen(var Msg: TMessage);
begin
  OpenMci(HWindow, FileName, DevType);
end;

procedure TMidiDlg.MidiPlay(var Msg: TMessage);
var
  Buf,
  S: array[0..MinLen] of Char;
  Result: LongInt;
begin
  Location := 0;
  if Mode <> Mci_Mode_Pause then begin
    if (FileBox^.GetSelString(Buf, MaxLen) < 0) then begin
    MessageBox(HWindow, 'No file selected in listbox', '', mb_Ok);
    exit;
    end;
    StrCopy(S, CurrentDirectory);
    StrCat(S, '\');
    StrCat(S, Buf);
    OpenMci(HWindow, S, DevType);
    ReportStatus;
    if Mode = MidiError then exit;
    CheckForMapper;
    StartTimer;
    SetTimeFormatMS;
    Result := GetLen;
    wvsPrintf(S, '%ld ms', Result);
    LenText^.SetText(S);
    DevInfo^.SetText(GetInfo(S));
  end;
  PlayMci;
  ReportStatus;
end;

procedure TMidiDlg.MidiPause(var Msg: TMessage);
begin
  PauseMidi;
  ReportStatus;
end;

procedure TMidiDlg.WmTimer(var Msg: TMessage);
var
  S: array[0..50] of Char;
begin
  Location := GetLocation;
  Str(Location, S);
  CurTime^.SetText(S);
  ReportStatus;
end;
end.