/* testc - Test adpcm coder */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

struct adpcm_state {
    short      valprev_l;        /* Previous output value */
    char       index_l;          /* Index into stepsize table */
    short      valprev_r;        /* Previous output value */
    char       index_r;          /* Index into stepsize table */
};

struct adpcm_state state;

void adpcm_coder (short [], char [], int, struct adpcm_state *);
void adpcm_decoder (char [], short [], int, struct adpcm_state *);

#define NSAMPLES 1000

char   abuf[NSAMPLES/2];
short  sbuf[NSAMPLES];

main() {
    FILE    *f, *f2;
    char    fname[64],fname2[64];

    if (_argc < 3 )
    {
        printf("Usage: %s infile outfile\r\n", _argv[0]);
        exit(1);
    }
    strcpy(fname,_argv[1]);
    strcpy(fname2,_argv[2]);

    if ( NULL == (f2=fopen(fname2,"wb")) )
    {
        printf("Error opening '%s', terminating..\r\n", fname2);
        exit(4);
    }
    if ( NULL == (f=fopen(fname,"rb")) )
    {
        printf("Error opening '%s', terminating..\r\n", fname);
        exit(4);
    }
    while( fread(&sbuf,sizeof(sbuf),1,f) )
    {
        adpcm_coder(sbuf, abuf, sizeof(sbuf)/4, &state);
        fwrite(&abuf,sizeof(abuf),1,f2);
    }
    fclose(f);
    fclose(f2);
    exit(0);
}
