#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <iostream.h>

class CD_ROM
   {
	 private:
		unsigned char* dev_name;
		unsigned playing;
		unsigned cd;
		unsigned opened;
		unsigned char continuous;

		void is_open();
		void no_cd();
		void is_playing();
	 public:
		CD_ROM();
		unsigned first_track;
		unsigned last_track;
		unsigned state;
		unsigned sector[30];
		unsigned offset[30];
		unsigned track_time[30];

		void init();
		void status();
		void reset();
		void open();
		void close();
		void play(unsigned char);
		void stop();
		void get_tracks();
		void disk_info();

	 unsigned char* name()
	    { return dev_name; }
	 unsigned first()
	    { return first_track; }
	 unsigned last()
	    { return last_track; }
   };


CD_ROM::CD_ROM()
{
   playing=cd=opened=0;
}


void CD_ROM::init()
{
   unsigned char num=0,h;

   asm{push ds
	  push di
	  mov ah,0x0048
	  mov bx,0x0001
	  int 0x0021

	  mov es,ax
	  mov bx,0
	  mov ax,0x1501
	  int 0x002f
	  lds di,es:[bx+1]
	  add di,10
	  mov cx,9
	 }
loop:
   asm{mov bh,ds:[di]
	  mov h,bh
	 }
   dev_name[num]=h;
   num++;
   asm{
	  inc di
       dec cx
	  cmp cx,0
       jne loop
	 }
   dev_name[8]=0x0000;
   asm{mov ah,0x0049
	  int 0x0021
       pop di
	  pop ds

	 }
}


void CD_ROM::get_tracks()
{
   unsigned int dev_info_low,dev_info_high;
   unsigned char* buffer=name();
   unsigned int mins,secs;
   char track,l;
   char dev_info[2];
   unsigned segm,off;

   off=FP_OFF(dev_name);
   segm=FP_SEG(dev_name);

   asm{push ds
	  push di
	  
	  mov ah,0x0048
	  mov bx,0x0001
	  int 0x0021

	  mov  es,ax
	  mov  bx,0
	  mov  ax,0x1501
	  int  0x002f

	  mov  ax,0x3c00
	  mov  cx,0x0000

	  mov  dx,segm
	  mov  ds,dx
	  mov  dx,off

	  int  0x0021

	  mov  bx,ax

	  mov  cx,0x0064
	  mov  ax,es
	  mov  ds,ax
	  mov  dx,0
	  mov  di,dx
	  mov  byte ptr ds:[di],0x000a
	  mov  ax,0x4402

	  int  0x0021
	  mov  dx,ds:[di+1]

	  mov  byte ptr dev_info[0],dl
	  mov  byte ptr dev_info[1],dh

	  mov ah,0x0049
	  int 0x0021


	  pop  di
	  pop  ds
	 }
	 first_track=dev_info[0];
	 last_track=dev_info[1];

   l=last_track;

   asm{push ds
	  push di

	  mov ah,0x0048
	  mov bx,0x0001
	  int 0x0021

	  mov es,ax

	  mov bx,0
	  mov ax,0x1501
	  int 0x002f

	  mov ax,0x3c00
	  mov cx,0x0000
	  lds dx,buffer
	  int 0x0021

	  mov bx,ax
	  }
   for (track=1;track<=l;track++)
   {

   asm{push bx
	  mov cx,0x0064
	  mov ax,es
	  mov ds,ax
	  mov dx,0
	  mov di,dx
	  mov dl,track
	  mov byte ptr ds:[di],0x000b
	  mov byte ptr ds:[di+1],dl
	  xor dx,dx
	  mov ax,0x4402
	  int 0x0021

	  mov dx,ds:[di+2]
	  mov word ptr dev_info_low,dx

	  mov dx,ds:[di+4]
	  mov word ptr dev_info_high,dx
	 }
	 offset[track-1]=dev_info_low;
	 sector[track-1]=dev_info_high;
	 asm{pop bx}
   }
   asm{mov ah,0x0049
       int 0x0021
       pop di
	  pop ds
	 }

   for (track=1;track<l;track++)
   {
   if (offset[track]<offset[track-1]) {secs=(unsigned int) (offset[track]-offset[track-1]+65535l);mins=sector[track]-sector[track-1]-1;}
		else
	 {secs=offset[track]-offset[track-1];mins=sector[track]-sector[track-1];}
   secs=secs/255;
   if (secs>200) secs=secs-200;
   track_time[track-1]=mins*4500+secs*75;
   }
   track_time[l-1]=0xffff;

}

void CD_ROM::disk_info()
{
   unsigned segm,off,sectors,sectors_1;

   off=FP_OFF(dev_name);
   segm=FP_SEG(dev_name);

   asm{push ds
	  push di

	  mov ah,0x0048
	  mov bx,0x0001
	  int 0x0021

	  mov  es,ax
	  mov  bx,0
	  mov  ax,0x1501
	  int  0x002f

	  mov  ax,0x3c00
	  mov  cx,0x0000

	  mov  dx,segm
	  mov  ds,dx
	  mov  dx,off

	  int  0x0021

	  mov  bx,ax

	  mov  cx,0x0064
	  mov  ax,es
	  mov  ds,ax
	  mov  dx,0
	  mov  di,dx
	  mov  byte ptr ds:[di],0x0008
	  mov  ax,0x4402

	  int  0x0021
	  mov  dx,ds:[di+1]

	  mov  sectors,dx
	  mov  dx,ds:[di+3]
	  mov  sectors_1,dx

	  mov ah,0x0049
	  int 0x0021


	  pop  di
	  pop  ds
	 }
}


void CD_ROM::status()
{
   unsigned char* buffer=name();
   unsigned drive_state;

   asm{push ds
	  push di

	  mov ah,0x0048
	  mov bx,0x0001
	  int 0x0021

	  mov es,ax

	  mov ax,0x3c00
	  mov cx,0x0000

	  lds dx,buffer
	  int 0x0021

	  mov bx,ax
	  mov ax,es
	  mov ds,ax

	  mov ax,0x4402
	  mov cx,5
	  mov dx,0
	  mov di,dx
	  mov byte ptr ds:[di],6
	  int 0x0021

	  mov dx,ds:[di+1]
	  mov drive_state,dx

	  mov ah,0x0049
	  int 0x0021
	  pop di
	  pop ds

	 }
   state=drive_state;
   is_open();
   no_cd();
   is_playing();
}

void CD_ROM::is_open()
{
   unsigned temp=state;

   asm{test temp,1
	  jz   closed;
	 }
   opened=1;
   cout << "CD door is open.\n";
   return;
   closed:
   opened=0;
   cout << "CD door is closed.\n";
}

void CD_ROM::no_cd()
{
   unsigned temp=state;

   asm{test temp,100000000000b
	  jnz  empty
	 }
   cd=1;
   cout << "There is a CD in the drive.\n";
   return;
   empty:
   cd=0;
   cout << "There is no CD in the drive.\n";
}

void CD_ROM::is_playing()
{
   unsigned temp=state;

   asm{test temp,10000000000b
	  jz   playing_1
	 }
   playing=0;
   cout << "The CD is not playing.\n";
   return;
   playing_1:
   playing=1;
   cout << "The CD is not playing.\n";
}


void CD_ROM::open()
{
   unsigned char* buffer=name();

   asm{push ds
	  push di

	  mov ah,0x0048
	  mov bx,0x0001
	  int 0x0021

	  mov es,ax

	  mov ax,0x3c00
	  mov cx,0x0000

	  lds dx,buffer
	  int 0x0021

	  mov bx,ax
	  mov ax,es
	  mov ds,ax

	  mov ax,0x4403
	  mov cx,1
	  mov dx,0
	  mov di,dx
	  mov byte ptr ds:[di],0
	  int 0x0021
	  mov ah,0x0049
	  int 0x0021
	  pop di
	  pop ds

	 }
}

void CD_ROM::reset()
{
   unsigned char* buffer=name();

   asm{push ds
	  push di

	  mov ah,0x0048
	  mov bx,0x0001
	  int 0x0021

	  mov es,ax

	  mov ax,0x3c00
	  mov cx,0x0000
	  lds dx,buffer
	  int 0x0021

	  mov bx,ax
	  mov ax,es
	  mov ds,ax

	  mov ax,0x4403
	  mov cx,1
	  mov dx,0
	  mov di,dx
	  mov byte ptr ds:[di],2
	  int 0x0021
	  mov ah,0x0049
	  int 0x0021
	  pop di
	  pop ds

	 }
}


void CD_ROM::close()
{
   unsigned char* buffer=name();

   asm{push ds
	  push di

	  mov ah,0x0048
	  mov bx,0x0001
	  int 0x0021

	  mov es,ax

	  mov ax,0x3c00
	  mov cx,0x0000
	  lds dx,buffer
	  int 0x0021

	  mov bx,ax
	  mov ax,es
	  mov ds,ax

	  mov ax,0x4403
	  mov cx,1
	  mov dx,0
	  mov di,dx
	  mov byte ptr ds:[di],5
	  int 0x0021
	  mov ah,0x0049
	  int 0x0021
	  pop di
	  pop ds

	 }
}

void CD_ROM::play(unsigned char track)
{
   unsigned int upper=sector[track-1],lower=offset[track-1],length;

   length=track_time[track-1];

   asm{push ds
	  push di

	  mov ah,0x0048
	  mov bx,0x0002
	  int 0x0021
 
	  mov es,ax

	  mov bx,1
	  mov ax,0x1501
	  int 0x002f

	  mov bx,0
	  mov dx,lower
	  mov byte ptr es:[bx],0x0016
	  mov byte ptr es:[bx+2],0x0084
	  mov byte ptr es:[bx+0x000d],0x0001
	  mov word ptr es:[bx+0x000e],dx
	  mov dx,upper
	  mov word ptr es:[bx+0x0010],dx
	  mov dx,length
	  mov word ptr es:[bx+0x0012],dx      //here is the length
	  mov word ptr es:[bx+0x0014],0x0000  //not sure of actual parameters
	  mov ax,0x1510
	  mov cx,0x0003
	  int 0x002f

	  mov ah,0x0049
	  int 0x0021
	  pop di
	  pop ds
	 }
}

void CD_ROM::stop()
{
   asm{push ds
	  push di

	  mov ah,0x0048
	  mov bx,0x0001
	  int 0x0021
	  
	  mov es,ax

	  mov bx,1
	  mov ax,0x1501
	  int 0x002f

	  mov bx,0
	  mov byte ptr es:[bx],0x000d
	  mov byte ptr es:[bx+2],0x0085
	  mov ax,0x1510
	  mov cx,0x0003
	  int 0x002f

	  mov ah,0x0049
	  int 0x0021
	  pop di
	  pop ds
	 }
}

