/*  exam4.c - Digital Sound Interface Kit V1.01a example code

    Copyright 1993,94 Carlos Hasan
*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "sound.h"
#include "ts.h"

/* Timer counter */
word volatile TmrCnt;

/* Timer routine called 100 times per second */
void far MyTimer(void)
{
    TmrCnt++;
    DSMPoll();
}

int main(void)
{
    DSMCard Card;
    DSM *Module;
    DSMInst *Sample;
    int Volume;
    int Secs;

    if (DSMLoadSetup(&Card)) {
        printf("Please run SETUP.EXE to configure.\n");
        return 1;
    }
    if (DSMInit(&Card)) {
        printf("Error Initializing the Sound System.\n");
        return 1;
    }
    if ((Module = DSMLoad("64MANIA.DSM",0L)) == NULL ||
        (Sample = DSMLoadSample("DING.WAV",0L)) == NULL) {
        switch (DSMStatus) {
        case ERR_NORAM:  printf("Not enough system memory.\n"); break;
        case ERR_NODRAM: printf("Not enough card memory.\n"); break;
        case ERR_NOFILE: printf("File not found.\n"); break;
        case ERR_FORMAT: printf("Invalid file format.\n"); break;
        case ERR_ACCESS: printf("File damaged.\n"); break;
        }
        DSMDone();
        return 1;
    }
    printf("Playing music.\n");

    /* Play music using channels 0,1,2 and sound effect in channel 3 */
    DSMSetupVoices(4,Module->Song.MasterVolume);
    DSMPlayMusic(Module);

    TSInit();
    TSSetRate(100);
    TSSetRoutine(MyTimer);

    for (Volume = 0; Volume < 64; Volume++) {
        DSMSetMusicVolume(Volume);
        delay(5);
    }

    Secs = 0;
    while (!kbhit()) {
        /* Play sample every second */
        if (TmrCnt >= 100) {
            TmrCnt -= 100;
            Secs++;
            DSMPlaySample(3,Sample);
            printf("Timer: %02d:%02d\r", Secs / 60, Secs % 60);
        }
    }

    for (Volume = 64; Volume > 0; Volume--) {
        DSMSetMusicVolume(Volume);
        delay(5);
    }

    DSMStopMusic();
    DSMFreeSample(Sample);
    DSMFree(Module);

    TSDone();
    TSRestoreTime();

    DSMDone();
    return 0;
}
