#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "mloader.h"
#include "munitrk.h"


// Raw 669 header struct:

typedef struct S69HEADER{
	UWORD marker;
	char  message[108];
	UBYTE nos;
	UBYTE nop;
	UBYTE looporder;
	UBYTE orders[0x80];
	UBYTE tempos[0x80];
	UBYTE breaks[0x80];
} S69HEADER;



// Raw 669 sampleinfo struct:

typedef struct S69SAMPLE{
	char  filename[13];
	long  length;
	long  loopbeg;
	long  loopend;
} S69SAMPLE;


// Raw 669 Note struct

typedef struct S69NOTE{
	UBYTE a,b,c;
} S69NOTE;




S69NOTE *s69pat;
static S69HEADER *mh;

char *S69_Version[]={
	"669",
	"Extended 669"
};



BOOL S69_Test(void)
{
	UWORD id;

	rewind(modfp);
	if(!fread(&id,2,1,modfp)) return 0;
	if(id=='if') return 1;
	if(id=='JN') return 1;
	return 0;
}



BOOL S69_Init(void)
{
	mh=NULL;
	s69pat=NULL;

	if(!(s69pat=(S69NOTE *)MyMalloc(64*8*sizeof(S69NOTE)))) return 0;
	if(!(mh=(S69HEADER *)MyCalloc(1,sizeof(S69HEADER)))) return 0;
	return 1;
}



void S69_Cleanup(void)
{
	if(s69pat!=NULL) free(s69pat);
	if(mh!=NULL) free(mh);
}




BOOL S69_LoadPatterns(void)
{
	int u,t,s,tracks=0,q;
	UBYTE note,inst,vol,a,b,c;

	if(!AllocPatterns()) return 0;
	if(!AllocTracks()) return 0;

	for(t=0;t<of.numpat;t++){

		of.pattrows[t]=mh->breaks[t]+1;

		/* Load the pattern into the temp buffer
		   and convert it into the 3-byte format */

		if(fread(s69pat,64*8*sizeof(S69NOTE),1,modfp)!=1){
			myerr=ERROR_LOADING_PATTERN;
			return 0;
		}

		for(s=0;s<8;s++){

			UniReset();

			UniPTEffect(0xf,78);
			UniPTEffect(0xf,3);

			for(q=0;q<64;q++){

				a=s69pat[(q*8)+s].a;
				b=s69pat[(q*8)+s].b;
				c=s69pat[(q*8)+s].c;

				note=a>>2;
				inst=((a&0x3)<<4)|((b&0xf0)>>4);
				vol=b&0xf;

				if(note<0x3e){
					UniInstrument(inst);
					UniNote(note+24);
				}

				if(note<0x3f){
					UniPTEffect(0xc,vol<<2);
				}

				UniNewline();
			}
			if(!(of.tracks[tracks++]=UniDup())) return 0;
		}
	}
	return 1;
}


BOOL S69_Load(void)
{
	int t,tracks;

	S69SAMPLE s;
	INSTRUMENT *d;
	SAMPLE *q;

	rewind(modfp);

	// try to read module header

	if(!fread(mh,sizeof(S69HEADER),1,modfp)){
		myerr=ERROR_LOADING_HEADER;
		return 0;
	}

	/* set module variables */

	of.initspeed=6;
	of.inittempo=125;
	of.modtype=strdup(S69_Version[mh->marker=='JN']);
	of.numchn=8;
	of.numpat=mh->nop;
	of.numins=mh->nos;
	of.numtrk=of.numchn*of.numpat;

	memcpy(of.positions,mh->orders,0x80);

	for(t=0;t<128;t++){
		if(of.positions[t]==0xff) break;
	}
	of.numpos=t;

	if(!AllocInstruments()) return 0;

	d=of.instruments;

	for(t=0;t<of.numins;t++){

		d->numsmp=1;
		if(!AllocSamples(d)) return 0;
        q=d->samples;

		// try to read sample info

		if(!fread(&s,sizeof(S69SAMPLE),1,modfp)){
			myerr=ERROR_LOADING_SAMPLEINFO;
			return 0;
		}

		d->insname=DupStr(s.filename,13);

		q->seekpos=0;
		q->c2spd=8363;
		q->length=s.length;
		q->loopstart=s.loopbeg;
		q->loopend=(s.loopend<s.length) ? s.loopend : s.length;

		q->flags=(s.loopbeg<s.loopend)?SF_LOOP:0;

		q->volume=64;
//              d->flags=(d->loopstart<d->loopend)?SF_LOOP:0;
		d++;
	}

	if(!S69_LoadPatterns()) return 0;

	return 1;
}




LOADER s69load={
	NULL,
	"669",
	"669 loader v0.1",
	S69_Init,
	S69_Test,
	S69_Load,
	S69_Cleanup
};
