/* Interrupt drive sound demo
 *
 * Last change:  10 Jul 92  JMG
 *
 * Written by:
 *
 *   Nels Anderson
 *   92 Bishop Drive
 *   Framingham, MA  01701
 *
 * Translated to (Borland) C by:
 *
 *   John Gallant
 *   1249 Cedar Creek Circle
 *   Dayton OH 45459
 *
 * Released to the public domain
 */


#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include "sounder.h"
#include "sounds.h"

void main()
{
  puts("\nSound Interrupt Demo 2");

  InitSound();				/* initialize sound parameters */
  Int1CSave = getvect(INTR);		/* save original interrupt vector */
  setvect(0x1C, New1CInt);		/* install sound interrupt */

  puts("Rudigore  (press any key to change)");
  StartSound(Ruddigore,99,1);		/* start theme song */

  getch();				/* song plays until key pressed */

  puts("Canon  (press any key to stop)");
  StartSound(Canon,99,1);

  getch();
  MakeSound = FALSE;			/* stop old sound */
  nosound();
  puts("sound stopped...press key to start next sound");
  getch();

  puts("sound started again\nscale -- regular tempo");
  StartSound(Scale,1,1);
  while (MakeSound)			/* wait for end */
    ;
  if (MakeSound == FALSE)		/* wait for finish */
  puts("scale -- slower tempo");
  StartSound(Scale,1,2);

  while (MakeSound == FALSE)		/* wait for start */
    ;

  while (MakeSound)			/* wait for end */
    ;

  puts("3 second delay");

  MyClock = 0;				/* reset timer */
  while (MyClock < 55)
    ;

  puts("times up!!");
  if (MakeSound == FALSE)		/* wait for finish */
    StartSound(WhistleSound,4,1);
  puts("press any key to quit");

  getch();

  setvect(0x1C, Int1CSave);		/* fix interrupt vector */
  nosound();				/* ensure sound is now off */
}  /* main() */
