.386c
        ;STMIK 090 - Interrupt-Driver-Interface
        ;additional code by - SPHINX - of NATIVE FORCE

        cje macro cmp1, cmp2, jumplabel
                cmp cmp1, cmp2
                je jumplabel
        endm


        include s3mplay1.inc
code16  segment para public use16
	assume cs:code16, ds:code16 , ss:codeend
        org 0h
        include s3mplay2.inc

        InstallMsg   db "STMIK 090 - Interrupt-Driver-Interface",10,13
                     db "written by - SHPHINX - of NATIVE FORCE 1994",10,13
                     db "STMIK ripped by DZD/RTT",10,13
                     db "STMIK original Copyright by Sami Tammilehto",10,13
                     db "Driver installed. (takes about 30K of mem) ",10,13,36

        ReInstallMsg db "STMIK 090 Interrupt-Driver removed from memory.",10,13,36

        Int_ID       db "STMIK090IDI"


        ;==============================================
        Func_01:;Init Soundcard
                call far ptr InitSoundCard
                jmp EndInt

        ;==============================================
        Func_02:;Play Music (in: SI=ModSeg)
                call far ptr S3M_Play_Song
                jmp EndInt

        ;==============================================
        Func_03:;Stop Music
                call far ptr S3M_Stop_Song
                jmp EndInt

        ;==============================================
        Func_04:;Fade Music on
                call far ptr S3M_FadeMusicOn
                jmp EndInt

        ;==============================================
        Func_05:;Fade Music off
                call far ptr S3M_FadeMusicOff
                jmp EndInt

        ;==============================================
        Func_06:;Set Master-Volume (in: CL=Volume)
                mov al, cl
                call far ptr S3M_SetVolume
                jmp EndInt

        ;==============================================
        Func_07:;Get Pattern (out: AL=Pattern)
                call far ptr S3M_GetPattern
                jmp EndInt

        ;==============================================
        Func_08:;Get Track  (out: AL=Track)
                call far ptr S3M_GetTrack
                jmp EndInt

        ;==============================================
        Func_09:;move seq.Idx.Ptr. (in: AH=New Position)
                call far ptr S3M_GetSequencerPos
                jmp EndInt

        ;==============================================
        Func_10:;Get VU-Meter Values (in: AH=Channel.Nr, out: AL=VU-Value)
                mov al, ah
                call far ptr S3M_GetVUMeter
                mov al, cl
                jmp EndInt

        ;==============================================
        Func_11:;Skip pattern
                call far ptr S3M_SkipPattern
                jmp EndInt

        ;==============================================
        Func_12:;Create and get Info-Block
                call far ptr S3M_GetInfoBlock
                jmp EndInt


        ;==============================================
        IntHandler proc far
                jmp     BegInt
                db      "STMIK090IDI"
                PSPSeg  dw ?
        BegInt: push    ds si
                cje     al, 12, Func_12
                cje     al, 11, Func_11
                cje     al, 10, Func_10
                cje     al, 09, Func_09
                cje     al, 08, Func_08
                cje     al, 07, Func_07
                cje     al, 06, Func_06
                cje     al, 05, Func_05
                cje     al, 04, Func_04
                cje     al, 03, Func_03
                cje     al, 02, Func_02
                cje     al, 01, Func_01
        EndInt: pop     si ds
                iret
        IntHandler endp



start:  jmp     main1


main1:
        ;check if Driver is installed
        ;get int.vec
        mov     ah, 35h
        mov     al, 0FCh
        int     21h             ;returns int.vec in ES:BX
        ;compare strings ES:DI with CS:SI (12 Bytes)
        mov     di, bx
        add     di, 3
        mov     si, offset INT_ID
        mov     cx, 12
main2:  mov     al, cs:[si]
        cmp     al, es:[di]
        jne     NotInst         ;if not equal, -> Driver is not installed
        loop    main2
        jmp     UnInst

NotInst:;Install Driver
        ;set new int.vector
        mov     ah, 25h
        mov     al, 0FCh
        push    cs
        pop     ds
        mov     dx, offset IntHandler
        int     21h
        ;get psp
        mov     ah, 62h
        int     21h
        mov     cs:[PSPSeg], bx
        ;print message
        mov     ah, 09h
        push    cs
        pop     ds
        mov     dx, offset InstallMsg
        int     21h
        ;exit program
        mov     ax, 3100h
        mov     dx, 1787
        int     21h
UnInst:;Re-Install Driver
        ;get int.vec
        mov     ah, 35h
        mov     al, 0FCh
        int     21h             ;returns int.vec in ES:BX
        mov     es, es:[bx+15]  ;get psp of Driver
	push	es
        mov     ah, 49h
        int     21h
        pop     es
        mov     ax, es
        add     ax, 16
        mov     es, ax
	mov	ah, 49h
	int	21h
        ;set int.vec
        mov     ah, 25h
        mov     al, 0FCh
        mov     dx, 0
        mov     ds, dx
        int     21h
        ;print message
        mov     ah, 09h
        push    cs
        pop     ds
        mov     dx, offset ReInstallMsg
        int     21h
        mov     ax, 4c00h
        int     21h
code16 ends

codeend segment para stack use16 'stack'
db 100*16 dup(?)
codeend ends

        end     start

