program RecPlay;
    uses
        CRT,
        SBVox;
    const
        RecordLength = 4;     {Seconds}
        SamplingRate = 22050; {HZ}
        SoundSize = RecordLength * SamplingRate;
        InterruptNum = 5;      {/ YOU WILL PROBABLY HAVE}
        BaseIOaddress = $220;  {\ TO CHANGE THESE CONSTS}
{$IFNDEF LinkDriver}
        DriverPath    = ''; {'' if the driver is in the current directory}
{$ENDIF}
    var
        Result : word;
        Sound  : PSound;
        i      : word;
    begin
        writeln; writeln; writeln;

{$IFNDEF LinkDriver}
        Result := LoadDriver(DriverPath + 'CT-VOICE.DRV');
{$ELSE}
        writeln('Driver linked into executable'); Result := LoadDrvSuccess;
{$ENDIF}
        case Result
            of
                LoadDrvSuccess:   writeln('Sound Blaster driver loaded successfully');
                LoadDrvIOerror:   writeln('IO error loading Sound Blaster driver');
                LoadDrvNoMemory:  writeln('Not enough memory to load Sound Blaster driver');
                LoadDrvBadDriver: writeln('Sound Blaster driver is corrupted');
            end;
        if Result <> 0 then Halt(255);
        writeln('CT-VOICE Driver Version: ', Hi(GetDriverVersion), '.', Lo(GetDriverVersion));
        SetInterrupt(InterruptNum);      writeln('Interrupt Number set to ', InterruptNum);
        SetBaseIOAddress(BaseIOaddress); writeln('Base IO address set');
        Result := InitSB; write('Attempting to initialize Sound Blaster:   ');
        case Result
            of
                SBInitSuccess:                writeln('SB Initialized Correctly');
                SBInitSoundCardFailure:       writeln('Sound Card Failure');
                SBInitIOFailure:              writeln('IO Failure');
                SBInitDMAorInterruptFailure:  writeln('DMA or Interrupt Failure');
            end;
        if Result <> LoadDrvSuccess then Halt(255);
        InitStatusWord;
        TurnSpeakerOn;

        GetSoundBuffer(Sound, SoundSize);

        TurnSpeakerOff; {Prevents feedback}
        writeln('Sound recording at ', SamplingRate, ' HZ begining');
        writeln('Press and key to stop recording');
        RecordSound(Sound, SoundSize, SamplingRate);
        repeat
            if KeyPressed
                then
                    begin
                        StopSound;
                        writeln('Sound recording stopped by key press');
                        Break;
                    end;
        until (StatusWord = SoundCompleted);
        writeln('Sound recording ending');
        writeln('Press any key to begin playback');
        repeat until KeyPressed; ReadKey;
        TurnSpeakerOn;
        writeln('Output of sound recording begin');
        PlaySound(Sound);
        repeat until (StatusWord = SoundCompleted);
        writeln('Output of sound recording ending');
        TurnSpeakerOff;

        FreeSoundBuffer(Sound, SoundSize);
{$IFDEF LinkDriver}
        ShutDownDriver;
{$ELSE}
        UnloadDriver;
{$ENDIF}
    end.