comment *

        Purpose:
        Macros for use in AdLib/SoundBlaster programming

        Author: Yousuf J. Khan

        *

addrdelay       macro           ;delay after writing to address port
        mov     cx, 6           ;six loops, 3.3 microsecs
        call    delay
        endm

datadelay       macro           ;delay after writing to data port
        mov     cx, 35          ;thirty-five loops, 23 microsecs
        call    delay
        endm

setreg  macro   address, data
;comment *
;
;        Purpose:
;        This macro first places the sound card's register address in its
;        address port. Then after a specified delay it then places the
;        desired value into that register from the Data port.
;
;        Entry:
;        DX: Address port of sound card
;
;        *
        ; Note: set DX to port address beforehand
        push    cx
        mov     al, address
        out     dx, al
        mov     cx, 6
        call    sbdelay
        inc     dx
        mov     al, data
        out     dx, al
        dec     dx
        mov     cx, 35
        call    sbdelay
        pop     cx
        endm

setadlib        macro   address, data
comment *

        Purpose:
        This is a special version of the SETREG macro, specifically
        suited to sending commands to the AdLib's Address port, 388h,
        and its Data port, 389h.

        *
        push    dx              ;save DX
        mov     dx, 388h
        setreg  address, data
        pop     dx              ;restore DX
        endm
