/*-------------------------------------------------------*/
/* Originally part of SOUNDHAX v1 by John M. Trindle     */
/*                 FREEWARE 12/19/91                     */
/*-------------------------------------------------------*/

#include <stdio.h>


#define  CMS_AVAILABLE  1
#define  FM_AVAILABLE   2
#define  CV_AVAILABLE   4

#define  OFF            0
#define  ON             1

#define  FALSE          0
#define  TRUE           1

extern _ct_io_addx;
extern _ct_int_num;
extern _ct_music_status;
extern _ct_voice_status;

static int StatusWord;

char *VoiceDriver;


main(int argc, char *argv[])
{
   int DriverFeatures,VersionCode,RetVal,i;

   char buffer[255];
   FILE *fp;


   _ct_io_addx = 0x220;    /* I/O Base */

   DriverFeatures = _ct_card_here();

   if (DriverFeatures & CMS_AVAILABLE)
      printf("C/MS Music Available\n");

   if (DriverFeatures & FM_AVAILABLE)
      printf("FM Music Available\n");

   if (DriverFeatures & CV_AVAILABLE)
      printf("Creative Voice Available\n");
   else
   {
      printf("Sound Blaster or Compatible NOT detected\n");
      exit(1);
   }


   VersionCode = _sbc_version();
   printf("SBV Version = %d.%d\n",VersionCode >> 8, VersionCode & 0xff);

   _sbc_scan_int();

   printf("Interrupt = %d\n",_ct_int_num);

   RetVal = _ctvd_init(6);
   printf("RetVal = %d\n",RetVal);

   fp = fopen(argv[1],"wb");

   _ctvd_speaker(OFF);
   _ctvd_input(fp->_file,250);
   while (TRUE)
   {
      if (kbhit())
      {
         if(!getch())
            getch();
         break;
      }
   }  
   _ctvd_terminate();
}
