/*  file  dec.cpp

by  Dustin Caldwell    (dustin@gse.utah.edu)

*/


#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

void helpdoc();

main()
{
        FILE *fp;

        unsigned char ch, c;

        if((fp=fopen(_argv[1], "rb"))==NULL)            /* open file to read */
        {
                printf("cannot open file %s\n",_argv[1]);
                helpdoc();
                exit(-1);
        }

        c=0;
        ch=fgetc(fp);

        while(!feof(fp))                        /* loop for whole file */
        {
                printf("%u\t", ch);             /* print every byte's decimal equiv. */
                c++;
                if(c>8)                                 /* print 8 numbers to a line */
                {
                        c=0;
                        printf("\n");
                }

                ch=fgetc(fp);
        }

        fclose(fp);                     /* close up */
}

void helpdoc()                  /* print help message */
{
        printf("\n   Binary File Decoder\n\n");

        printf("\n Syntax:  dec binary_file_name\n\n");

        printf("by Dustin Caldwell  (dustin@gse.utah.edu)\n\n");
        printf("This is a filter program that reads a binary file\n");
        printf("and prints the decimal equivalent of each byte\n");
        printf("tab-separated. This is mostly useful when piped \n");
        printf("into another file to be edited manually.  eg:\n\n");
        printf("c:\>dec sonata3.mid > son3.txt\n\n");
        printf("This will create a file called son3.txt which can\n");
        printf("be edited with any ascii editor. \n\n");
        printf("(rec.exe may also be useful, as it reencodes the \n");
        printf("ascii text file).\n\n");
        printf("Have Fun!!\n");
}

