Program Example2;
{ This example code shows you how you might use the shortened PB256 units
  that are included with 256 Paint.  These shortened units are:
      SPB256_4    Unit for use by Turbo Pascal version 4.0 users.
      SPB256_5    Unit for use by Turbo Pascal version 5.5 users.
      SPB256_6    Unit for use by Turbo Pascal version 6.0 users.

  Note: I do not have version 5.0, one of the above may or may not work
        with 5.0.

  You are welcomed to use the shortened versions of the units in your
  Turbo Pascal programs.  If you have a sincere desire to avoid the
  device drivers (hence, saving .EXE or disk space), we recommend that
  you order the full counterparts of these shortened units.  For a
  more detailed description of what these units include, please refer to
  page 20 of the 256Paint.Doc documentaion file.}

{
Here are the current declarations in the INTERFACE section of the
shortened PB256 drivers.  The full versions will contain many more.

Type
    ColorRec = record
        r,g,b: byte;
    end;
    PalType = array[0..255] of ColorRec;
    PalFileType = file of PalType;

Var
    Pal: PalType;

procedure SetupVGAMode;
procedure ReturnToTextMode;
procedure Pixel(x,y: integer; color: byte);
procedure SetPalette256;

function ImageSize(ux,uy,lx,ly: integer): word;
procedure LoadImage256(var p:pointer; FName: string; var VGAImageSize: word; var HasPalette: boolean);
Procedure PutImage256(ux,uy: integer; VarSegment,VarOffset: word);
}


Uses crt,SPB256_6;   { Insert correct .TPU version here!  }

Var
    ch: char;
    HadPalette: boolean;
    VGAImageSize: word;
    i: integer;
    p: pointer;
    FileName: String;

begin
    FileName := '256Demo.vga';
    SetUpVGAMode;
    LoadImage256(p,FileName,VGAImageSize,HadPalette);
    If HadPalette then
        SetPalette256;
    PutImage256(0,0,Seg(p^),Ofs(p^));
    ch := readkey;
    ReturnToTextMode;
    If VGAImageSize > 6 then
        FreeMem(p,VGAImageSize)
    else
        Writeln('Error (',VGAImageSize,') loading file: ',FileName);
end.