// Program to convert ####.geo files to ####._3d files
//version number
#define VERSION "1.0"

#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>


//floating point structure
struct f_point
{
 float x, y, z;
};

//integer point structure
struct i_point
{
 int x, y, z;
};


void help(void);
float calculate_adjustment_factor(int no_verts, f_point coords[]);

main(int argc, char *argv[])
{
 cout << "\nConverts OFF datafiles to ._3D files for the viewer 3d_2.exe\n";
 cout << "Version " << VERSION << " by K.Ironside\n";

 if (argc==1)
 {
  help();
  exit(0);
 }

 if (argc > 4)
 {
  help();
  exit(1);
 }

 ifstream in(argv[1]);
 if(!in)
 {
  cout << "\nCannot open file" << argv[1];
  exit(1);
 }

 ofstream out(argv[2]);
 if(!out)
 {
  cout << "\nCannot open file " << argv[2];
  exit(1);
 }


 int verts, surfs, total;

 in >> verts;
 in >> surfs;
 in >> total;

 cout << "Reading file " << argv[1] << "\n";
 cout << "Writing file " << argv[2] << "\n";

 out << verts << "\n";
 out << surfs << "\n";
 out << total << "\n";


 f_point *input_coords;
 i_point *output_coords;

 input_coords = new f_point[verts];
 output_coords = new i_point[verts];
 if ((!input_coords) || (!output_coords))
 {
  cout << "\nAllocation error\n";
  return 1;
 }


 // read in the coordinates
 for(int i=0; i<verts; i++)
 {
  in >> input_coords[i].x;
  in >> input_coords[i].y;
  in >> input_coords[i].z;
 }

 float adjust;

 //if there is an adjustment factor from the command line then use that one
 if (argc == 4)
 {
  adjust = atof(argv[3]);
  if (!adjust)
  {
   cout << "\nAdjustment factor must not be zero\n";
   exit(1);
  }
 }
  //calculate the adjustment factor
 else
 {
  adjust = calculate_adjustment_factor(verts, input_coords);
 }

 cout << "Adjustment factor :" << adjust << "\n";


 //adjust the coords and write to the out file
 for(i=0; i<verts; i++)
 {
  output_coords[i].x = input_coords[i].x * adjust;
  output_coords[i].y = input_coords[i].y * adjust;
  output_coords[i].z = input_coords[i].z * adjust;
  out << output_coords[i].x << "\t" << output_coords[i].y << "\t" << output_coords[i].z << "\n";
  cout << ".";
 }

 int no_verts, *vertex, *new_vertex, num;
 for(i=0; i<surfs; i++)
 {
  in >> no_verts;
  out << no_verts << "\t";

  vertex = new int[no_verts];
  new_vertex = new int[no_verts];
  if (!vertex || !new_vertex)
  {
   cout << "Allocation error\n";
  }

  for(int j=0; j<no_verts; j++)
  {
   in >> vertex[j];
   vertex[j]--;
  }

  new_vertex[0] = vertex[0];
  for(j=1; j<no_verts; j++)  new_vertex[j] = vertex[no_verts - j];
  for(j=0; j<no_verts; j++)
  {
   //out << new_vertex[j];	//writes the surfaces backwards
   out << vertex[j];
   if(j != (no_verts-1)) out << "\t";
  }
  out << "\n";
  cout << ".";
  delete [no_verts] vertex;
  delete [no_verts] new_vertex;
 }

 in.close();
 out.close();
 cout << "\nFinished\n";
 return 0;
}


void help(void)
{
 cout << "\nPlease enter the name of the data files.\n";
 cout << "FILTER2 <input filename> <output filename>  <adjustment factor>\n";
}


float calculate_adjustment_factor(int no_verts, f_point coords[])
{
 f_point min, max;
 max.x = max.y = max.z = -1e-8;
 min.x = min.y = min.z = 1e-8;


 //find the highest and lowest values
 for(int i=0; i<no_verts; i++)
 {
  if (coords[i].x > max.x) max.x = coords[i].x;
  if (coords[i].y > max.y) max.y = coords[i].y;
  if (coords[i].z > max.z) max.z = coords[i].z;

  if (coords[i].x < min.x) min.x = coords[i].x;
  if (coords[i].y < min.y) min.y = coords[i].y;
  if (coords[i].z < min.z) min.z = coords[i].z;
 }

 //the object coordinates must not vary be more than 200 units
 //therefore adjust the coords to fall into this range
 int screen_size = 200;
 float adjustment;
 f_point difference;
 float overall_difference = 0;

 difference.x = max.x - min.x;
 difference.y = max.y - min.y;
 difference.z = max.z - min.z;

 // find the greatest difference for either the x,y or z coords
 if ((difference.x >= difference.y) && (difference.x >= difference.z))
  { overall_difference = difference.x; }
 if ((difference.y >= difference.x) && (difference.y >= difference.z))
  { overall_difference = difference.y; }
 if ((difference.z > difference.x) && (difference.z > difference.y))
  { overall_difference = difference.z; }
 //if overall_difference is zero then all coords are zero
 if (!overall_difference)
 {
  cout << "\nAll the coordinates are zero !!!\n";
  exit(1);
 }

 //calculate the adjustment factor
 adjustment = screen_size / overall_difference;
 return adjustment;
}