/* ---------------------------------------------------- */
/* SPRITE CUTTER UTILITY v2.0                           */
/* by gaggi@cs.unibo.it                                 */
/* ---------------------------------------------------- */
/* CUTMAIN.C                                            */
/* Main module                                          */
/* ---------------------------------------------------- */

#include <stdio.h>
#include <conio.h>
#include <alloc.h>
#include <io.h>
#include <fcntl.h>
#include <dos.h>
#include <string.h>

#include "mouse.h"
#include "graph13h.h"

unsigned _heaplen= 8*1024;    /* 8Kb of near heap */
unsigned _stklen=  5*1024;    /* 5Kb of stack     */

/* ---------------------------------------------------- */

#define MOUSE_COLOR     0x04    /* mouse pointer color */

#define CRSR_UP         72
#define CRSR_DOWN       80
#define CRSR_RIGHT      77
#define CRSR_LEFT       75

#define SAVE_SIZE       42*8*16 + 2*sizeof(unsigned)

#include "interfac.h"
#include "cut_menu.h"
#include "cutlst.h"
#include "picview.h"

/* ---------- prototypes of generic functions --------- */

extern void xor_rect(unsigned, unsigned, unsigned, unsigned, unsigned);
/* Xors a rectangle on the screen */

extern void put_arrow(unsigned, unsigned);
/* Puts the mouse pointer (an arrow) on the screen */

extern void animate();


/* ---------- static datas ---------------------------- */

static char greetings[]=
		"Thank you for using my software, hope you enjoyed it!\n"
		"Feel free to send any comment to: gaggi@cs.unibo.it";

static char logo[]= " Sprite Cutter v2.0 \r"
			  " by gaggi@cs.unibo.it ";

static char *error_msg[]= {
				   "Memory allocation fault\r",
				   "Sorry, can't find:\r%s",
				   "Error while loading ...\r",
				   "Source picture\rnot loaded",
				   "Mouse not found."
				  };

/* ---------- Functions ------------------------------- */

void Arrow_cursor()
/* Function for the drawing of the mouse pointer during */
/* the menu and the choice of animation frames.         */
{
 static unsigned char first_time= 1;
 static unsigned char cursor_area[68];
 register unsigned MouseX= Mouse.PointX >> 1,
			 MouseY= Mouse.PointY;

 asm push bx
 asm push cx
 asm push dx

 if (first_time) {
			save_area(MouseX, MouseY, 8, 8, cursor_area);
			put_arrow(MouseX, MouseY);
			first_time--;
		     }
 else {
	 put_area(MouseX, MouseY, cursor_area);
	 first_time++;
	};

 asm pop  dx
 asm pop  cx
 asm pop  bx
}


void cut_cursor()
/* Function for the drawing of the mouse cursor */
{
 asm push bx
 asm push cx
 asm push dx

 xor_rect(Mouse.PointX >> 1, Mouse.PointY, cut_x_size, cut_y_size, 0x0f);

 asm pop  dx
 asm pop  cx
 asm pop  bx
}


void error(unsigned err_no, char *info)
{
 char *buffer_1;

 if ( info && (buffer_1= (char *)malloc(50)) )
    {
     sprintf(buffer_1, error_msg[err_no - 1], info);
     Message_box(buffer_1, 40, 80, 0);
     free(buffer_1);
    }
 else Message_box(error_msg[err_no - 1], 40, 80, 0);
}

static void Load_font(char *filename)
{
 char buffer[80];
 register int handle;
 register char *Font;

 strcpy(buffer, filename);
 if ( Font= strrchr(buffer, '\\') ) Font++;
 else Font= buffer;

 *Font= 0;
 strcat(buffer, "cutter.fnt");

 if ( (handle= open(buffer, O_RDONLY | O_BINARY)) == -1 ||
     !(Font= (char *)malloc(1024)) ) return;

 read(handle, Font, 1024);
 close(handle);

 CurFont= (char far *)Font;
}


void user_def_size()
/* Function for changing the size of the cut */
{
 register unsigned done= 0;
 char temp[23];
 static char msg1[]= "Arrows to change size, ENTER when done.";
 static char status[]= "x: %03d y: %03d";

 Curcol= 0;
 Draw_box(0, 0, 320, 130);

 Curcol= 15;
 Draw_rect(0, 0, 320, 130);

 Curcol= 7;
 OutText(2, 2, msg1);
 xor_rect(20, 20, cut_x_size, cut_y_size, 0x07);

 do
 {
  sprintf(temp, status, cut_x_size, cut_y_size);

  Curcol= 7;
  OutText(2, 10, temp);

  if ( kbhit() )
     {
	switch ( getch() )
	{
	 case 0:
		  xor_rect(20, 20, cut_x_size, cut_y_size, 0x07);

		  switch ( getch() )
		  {
		   case CRSR_UP:
			  if (--cut_y_size < 3) cut_y_size++;
			  break;

		   case CRSR_DOWN:
			  if (++cut_y_size > 100) cut_y_size--;
			  break;

		   case CRSR_LEFT:
			  if (--cut_x_size < 3) cut_x_size++;
			  break;

		   case CRSR_RIGHT:
			  if (++cut_x_size > 100) cut_x_size--;
		  };

		  xor_rect(20, 20, cut_x_size, cut_y_size, 0x07);
		  Curcol= 0;
		  Draw_box(2, 10, 200, 8);
		  break;

	 case '\r':
		  done++;
	};

     };

 } while (!done);

 if (*source_name) {
			  Show_picture(&source_pic, 0);
			  Draw_cuts();
			 }
 else {
	 Curcol= 0;
	 Draw_box(0, 0, 320, 130);
	};

 setlocation(0, 0);
}

/* ---------- Principale ----------------------------- */

int main(unsigned argc, char *argv[])
{
 register unsigned done= 0;

 /* Initial settings */
 if ( init_PIC(&source_pic) ) {
					 puts(*error_msg);
					 return -1;
					};
 set_video(MODE_13H);

 if ( !resetmouse() ) {
			     set_video(TEXT_MODE);
			     puts(error_msg[4]);
			     return -1;
			    };

 Install_mouse();
 set_Xrange(0, (320 - cut_x_size) << 1); /* Redefining the range of  mouse */
 set_Yrange(0, (200 - cut_y_size) );

 Load_font(*argv);

 SetDrawProc((void *)cut_cursor);      /* Mouse cursor drawing procedure */
 mouse_cursor(ON);

 Message_box(logo, 50, 80, 0);

 if ( argc > 1 ) load_source(argv[1]); /* Load source picture if present */
					 /* its name is given as command   */
						   /* line parameter.                */
 do
 {
  switch ( Mouse.Button ) /* Looking at mouse control structure */
  {
   case LEFT_BUTTON:      /* if left button is pressed cut a sprite */
	  if ( done= cut_sprite(Mouse.EventX >> 1, Mouse.EventY) )
	     error(done, NULL);
	  done= 0;
	  break;

   case RIGHT_BUTTON:     /* if right button is pressed perform main menu */
	  set_Xrange(0, 639);
	  set_Yrange(0, 199);
	  switch ( Do_menu(&main_menu, Mouse.EventX >> 1, Mouse.EventY) )
	  {
	   case CMD_SOURCE:
		  load_source(NULL);
		  break;

	   case CMD_SPRITE:
		  switch (Do_menu(&sprite_menu, Mouse.EventX >> 1, Mouse.EventY))
		  {
		   case CMD_LOADLIST:
			  load_LST();
			  break;

		   case CMD_SAVELIST:
			  save_LST(0);
			  break;

		   case CMD_ANIMATE :
			  if ( cut_list ) animate();
			  break;

		   case CMD_SAVESPR :
			  save_SPR();
		  };
		  break;

	   case CMD_SIZE  :
		  switch (done= Do_menu(&size_menu, Mouse.EventX >> 1, Mouse.EventY))
		  {
		   case CMD_USERDEF:
			  user_def_size();
		   case CMD_NULL:
			  break;
		   default:
		    cut_x_size= done;
		    cut_y_size= done;
		  };
		  done= 0;
		  break;

	   case CMD_QUIT  :
		  save_LST(1);  /* Save list if it has been modified */
		  done++;
	  };
	  set_Xrange(0, (320 - cut_x_size) << 1);
	  set_Yrange(0, 200 - cut_y_size);
	  SetDrawProc((void *)cut_cursor);
	  mouse_cursor(ON);
  };

 } while(!done);

 /* Final housekeeping ... and goodbye! */
 resetmouse();
 if (CurFont != DEFAULT_FONT) free((char *)CurFont);
 PIC_free(&source_pic);
 set_video(TEXT_MODE);
 puts(greetings);

 return 0;
}
