ECHO OFF

IF NOT "%1"=="" GOTO START
ECHO 
ECHO MAKEQLB:  Takes TheDraw QuickBasic object files and incorporates them into
ECHO a Quick Library (for use in the integrated environment) and a parallel .LIB
ECHO library file.  Additional non-TheDraw object files and libraries can also
ECHO be included if you desire.
ECHO 
ECHO The following files must be present in the same directory:
ECHO   LINK.EXE, LIB.EXE, BQLB40.LIB or BQLB45.LIB, and object files to
ECHO   incorporate into the libraries.
ECHO 
ECHO Usage:  MAKEQLB library [file1] [file2] [file3] etc...
ECHO 
ECHO Do not place any file extension in the "library" parameter, as the
ECHO extensions .QLB and .LIB are assumed.  ie:
ECHO 
ECHO   MAKEQLB TEST IMAGE1.OBJ IMAGE2.OBJ IMAGE3.OBJ MYCODE.LIB
ECHO 
ECHO ...produces TEST.LIB -and- TEST.QLB containing the three object files
ECHO    plus the information from the specified library file.
ECHO 
ECHO 
GOTO DONE

:START
ECHO Processing TheDraw Quick Library...
SET libname=%1
IF NOT EXIST %libname%.LIB GOTO NEWLIB
ECHO Updating:  %libname%.LIB
GOTO LIBLOOP

:NEWLIB
IF "%2"=="" GOTO LIBDONE
IF EXIST %2 GOTO LIBCREATE
IF EXIST %2.OBJ GOTO LIBCREATE
IF EXIST %2.LIB GOTO LIBCREATE
GOTO INVALIDPARAM
:LIBCREATE
ECHO Creating:  %libname%.LIB
ECHO   Adding:  %2
LIB %libname%.LIB+QB4UTIL.LIB+%2; >NUL
SHIFT

:LIBLOOP
IF "%2"=="" GOTO LIBDONE
IF EXIST %2 GOTO LIBADD
IF EXIST %2.OBJ GOTO LIBADD
IF EXIST %2.LIB GOTO LIBADD
GOTO INVALIDPARAM
:LIBADD
ECHO   Adding:  %2
LIB %libname%.LIB+%2; >NUL
SHIFT
GOTO LIBLOOP

:INVALIDPARAM
ECHO Aborting.  Unable to find any object file or library named: %2
GOTO Done

:LIBDONE
REM Make the QLB file
IF EXIST BQLB40.LIB GOTO QLBMAKE
IF EXIST BQLB45.LIB GOTO QLBMAKE
ECHO File BQLB40.LIB or BQLB45.LIB not found in directory.  Aborting.
GOTO Done

:QLBMAKE
ECHO 
ECHO Creating:  %libname%.QLB
IF EXIST BQLB40.LIB LINK /Q /NOE /NOD %libname%.LIB, %libname%.QLB,,BQLB40.LIB; >NUL
IF EXIST BQLB45.LIB LINK /Q /NOE /NOD %libname%.LIB, %libname%.QLB,,BQLB45.LIB; >NUL
IF EXIST %libname%.BAK DEL %libname%.BAK
SET LIBNAME=

:DONE
