/*_ format83.c   Thu Sep 17 1987   Modified by: Erik Lindberg */
/*
	This program is released to the public domain. It can be
	used for any purpose whatsoever. If you can get some poor
	sucker to pay money for it, tell me your secret.

	Prints a file to stdout in Intel HEX 83 format. I wrote this
	to be easy to understand, modify, and *portable*. If you want
	elegant, you can get there from here.
*/

#include <stdio.h>

#define REC	0x10		/* Size of a record. */

char *line, buffer[128];
FILE *infile;

extern char hex();

main(argc,argv)
int argc;
char *argv[];
{
	int c=1, address=0;
	int sum, i;
	i=0;
	if (!(infile = fopen(argv[++i],"rb"))) {
		fprintf(stderr, "Error on open of file %s\n",argv[i]);
		exit(1);
	}

	while (c != EOF) {
		sum = 0;
		line = buffer;
		for (i=0; i<REC && (c=getc(infile)) != EOF; i++) {
			*line++ = hex(c>>4);
			*line++ = hex(c);
			sum += c;		/* Checksum each character. */
		}
		if (i) {
			sum += address >> 8;	/* Checksum high address byte.*/
			sum += address & 0xff;	/* Checksum low address byte.*/
			sum += i;		/* Checksum record byte count.*/
			line = buffer;		/* Now output the line! */
			putchar(':');
			puthex(i,2);		/* Byte count. */
			puthex(address,4);	/* Do address and increment */
			address += i;		/*    by bytes in record.   */
			puthex(0,2);		/* Record type.		   */
			for(i*=2;i;i--)		/* Then the actual data.   */
				putchar(*line++);
			puthex(0-sum,2);	/* Checksum is 1byte 2's comp.*/
			printf("\n");
		}
	}
	printf(":00000001FF\n");		/* End record. */
}

/* Return ASCII hex character for binary value. */

char hex(c)
int c;
{
	if((c &= 0x000f)<10)
		c += '0';
	else
		c += 'A'-10;
	return((char) c);
}

/* Put specified number of digits in ASCII hex. */

puthex(val,digits)
int val,digits;
{
	if (--digits)
		puthex(val>>4,digits);
	putchar(hex(val & 0x0f));
}
