/*****************************************************************************
**  Listing :   APAL2BIN.C                                                  **
**  Funtion :   Convert ASCII .PAL file to binary palette file.             **
**  Author  :   JuHu (cn1.serv2.inf.tu-dresden.de)                          **
**                                                                          **
**  (C) 27/9/1993 ViNaSoft ***************************************************/


#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

char  inname[80];
char  outname[80];
FILE   *in, *out;

void process_args (int argc, char *argv[]);
void split(char *satz);

void main(int argc, char *argv[])
{   char   string[256];
    char   *temp;
    int    i=0;

    process_args (argc, argv);   /* Handle the command line args */

    if ((in = fopen (inname, "rt")) == NULL) {
	printf ("Cannot open input file %s!\n", inname);
	exit (1);
    }

    if ((out = fopen (outname, "wb")) == NULL) {
	printf ("Cannot open output file %s!\n", outname);
	exit (1);
    }
    fgets(string, 256, in);
    if(!strstr(string,"PAL")){
    printf("%s is'nt .PAL file !\n",inname);
	exit(1);
    }
    fgets(string, 256, in);
    printf("Input  :   %s\n",inname);
    printf("Output :   %s\n",outname);
    printf("Colors :   %d\n\n",atoi(string));
    printf("Please wait...\n");

    while (fgets (string, 256, in) != NULL) {
      temp = string;
      for(i=0;i<3;i++){
        split(temp);
        fputc(atoi(temp)/4,out);
        temp+=strlen(temp)+1;
      }
    }

   fclose(in);
   fclose(out);
   printf("Done.\n");
}

void process_args (int argc, char *argv[])
{
    int i;
    printf("APAL2BIN 1.1 (C) 27.09.93 ViNaSoft by JuHu:-)\n");
    printf("ASCII .PAL file -> binary palette file. \n\n");

    if (argc < 2) {
        printf("Usage  : APAL2BIN <infile> <outfile>\n");
        exit(1);
    }

    strcpy (inname, argv[1]);
    strcpy (outname,argv[2]);
}

void split(char *satz)
{
  while(*satz==' ') satz++;
  while(*satz)
  { if(*satz==' ')
      *satz = '\0';
    else
     satz++;
  }
}

