/*****************************************************************************
**  Listing :   IFF2PBM.C                                                   **
**  Funtion :   Convert ILBM-Picts (.LBM or .BBM) to PBM- and PAL-files.    **
**  Notes   :   XLib && ACK needed !!!                                      **
**  Author  :   JuHu (cn1.serv2.inf.tu-dresden.de)                          **
**                                                                          **
**  (C) 01/1994 ViNaSoft *****************************************************/

#include <stdio.h>
#include <dos.h>
#include <mem.h>
#include <ctype.h>
#include <alloc.h>
#include "xlib_all.h"       /* from XLib    */
#include "ackiff.h"         /* from ACK3D   */


extern unsigned char far  colordat[768];  /* globale PAL-array from ACKIFF.C */

int widthFour(int width)
{ return    (width + (((4-(width % 4)) == 4) ?
            0 : (4-(width%4))));             /* smallest mult of 4 > width! */
}

int main(int argc,char *argv[])
{
    int i,j,handle;
    int height,width;
    int width4,widthdiv4;
    unsigned char ch;
    long miscNumber = 0;
    long bufferIndex = 0;
    long bytesLeft;
    long planSize;
    unsigned char far *Picture;
    unsigned char far *pbm;

    printf("IFF2PBM 1.0 (C) ViNaSoft by JuHu:-)\n");

    if(argc < 3)
    { printf("Usage: IFF2SPR <ILBM file> <PBM file> [PAL file]\n");
      printf("Note :\n");
      printf("  -ILBM file is a .LBM or .BBM file. ( from DPaintII )\n");
      printf("  -PBM  file is a planar bitmap file.( from XLib     )\n");
      printf("  -PAL  file is a palette file.\n");
      exit(0);
    }
    printf("Please wait...\n");
    Picture = AckReadIff(argv[1]);   /* Load a Deluxe Paint picture  */

    if (Picture == NULL)             /* Whoops, got a problem    */
    { printf("IFF2PBM: Not enought memory to load input file or\n");
      printf("         input file isn't ILBM-file !\n");
      exit(0);
    }

    width   =   *((int *)&Picture[0]);
    height  =   *((int *)&Picture[2]);
    width4      = widthFour(width);

    if((pbm = farcalloc((long)width4 * (long)height + 2,1))==NULL)
    {   printf("IFF2PBM: Not enought memory to convert !\n");
        exit(0);
    }
    pbm[0]      = width4/4;
    pbm[1]      = height;
    planSize    = (long)width*(long)height/4;

    for(i=0;i<height;i++)
      for(j=0;j<width;j++)
      { ch = *(Picture+4+(long)i*(long)width+j);
        *(pbm+2+(((long)i*(long)width+j)%4)*(long)planSize+((long)i*(long)width+j)/4) = ch;
      }

    if((handle=f_open(argv[2],F_WRONLY))==FILE_ERR)
    {   printf("IFF2PBM: Unable to open output PBM-file.\n");
        exit(0);
    }

/**** for YAK-file from YakIcon! :-) ********
    f_writefar(handle,"YARFILE   ",10);
    f_writefar(handle,Picture,4);
*********************************************/

    
    for (bytesLeft = (long)width4 * (long)height+2 ; bytesLeft > 0;)
      {
        miscNumber = (bytesLeft < 32000) ? bytesLeft : 32000;
        f_writefar(handle,pbm + bufferIndex, (int)miscNumber);
        bytesLeft -= miscNumber;
        bufferIndex += miscNumber;
      }
    f_close(handle);
    printf("IFF2PBM:    PBM-file -> %s........OK\n",argv[2]);

    if(argc >3)
    {  if((handle=f_open(argv[3],F_WRONLY))==FILE_ERR)
       {    printf("IFF2PBM: Unable to open output PAL-file .");
            exit(0);
       }
       f_writefar(handle,colordat,768);
       f_close(handle);
       printf("IFF2PBM:    PAL-file -> %s........OK\n",argv[3]);
    }
    printf("Done.\n");
    exit(0);
}

  

