#include <stdio.h>
#include <math.h>
/* The following include file can be found in the xwd source directory */
#include "XWDFile.h"

/* This program converts X window dump files created by xwd into */
 /* postscript code to image the window on paper.  Tony Della Fera had */
 /* a program to do this in an early X release, but I lost track of */
 /* that program and attempted to recreate it using an old output file */
 /* from it.  Apologies to Tony... */
 /*  --- plj@charon.mit.edu */

XWDFileHeader infile;

char *malloc();

unsigned char revbits[] = {
0x0,	0x8,	0x4,	0xc,	0x2,	0xa,	0x6,	0xe,
0x1,	0x9,	0x5,	0xd,	0x3,	0xb,	0x7,	0xf};


char preheader[] = "%!%% PostScript Prelude.\n\
%%%% X Window System xps raster format.\n\
\n\
%%%% Type definitions.\n\
/inch {72 mul} def\n\
/inches {72 mul} def\n\
\n\
%%%% Xps format header definitions.\n\
";

char postheader[] = "\n\
%%%% Compute bits per pixel\n\
/bits_per_pixel display_panes def\n\
\n\
%%%% X dump imaging proceedure.\n\
/image_string string_size string def\n\
/image_xps {\n\
    pixmap_width pixmap_height bits_per_pixel\n\
    [\n\
        pixmap_width 0 0\n\
        pixmap_height neg 0 pixmap_height\n\
    ]\n\
    {currentfile image_string readhexstring pop}\n\
    image\n\
} def\n\
\n\
%%%% Stroke image.\n\
";

char *whoami;

usage()
{
  fprintf(stderr,"Usage: %s -x{XOFF} -y{YOFF} -w{WIDTH} -h{HEIGHT} [-r] [-n]\n\
The -r option rotates the image 90 degrees\n\
 (Default orientation is portrait.)\n\
The -n option disables the 'showpage' at the end.\n\
 (use this option to insert output into other postscript files)\n\
All values in inches, stdin is xwd file, stdout is postscript file\n\
Offsets are from the lower left corner of the page.\n",
	  whoami);
  exit(1);
}

main(argc, argv)
     int argc;
     char **argv;
{
  char *winname;
  int winnamesz;
  float rlstrsize;
  int strsize;
  int numbytes;
  int argctr, rotate;
  char *curarg, *valptr;
  float xoff, yoff, rlwidth, rlheight;
  int printit;

  printit = 1;
  rotate = 0;
  xoff = yoff = rlwidth = rlheight = 0;
  whoami = argv[0];
  if (argc < 5) usage();
  for (argctr = 1; argctr < argc; argctr++) {
    curarg = argv[argctr];
    valptr = &(curarg[2]);
    switch (curarg[1]) {
    case 'n':
      printit = 0;
      break;
    case 'r':
      rotate = 1;
      break;
    case 'x':
      xoff = atof(valptr);
      break;
    case 'y':
      yoff = atof(valptr);
      break;
    case 'w':
      rlwidth = atof(valptr);
      break;
    case 'h':
      rlheight = atof(valptr);
      break;
    default:
      fprintf(stderr, "Unrecognized option: %c\n", curarg[1]);
      exit(1);
    }
  }
  if (!xoff || !yoff || !rlwidth || !rlheight) usage();




  printf("%s",preheader);
  read(fileno(stdin), &infile, sizeof(XWDFileHeader));

  numbytes = infile.pixmap_width/8;
  if (infile.pixmap_width & 0x7) numbytes++;

  rlstrsize = ((float)infile.pixmap_width)/(16.0);
  strsize = (int)(floor((double)rlstrsize));
  if (rlstrsize - (float)strsize) strsize++;
  strsize <<= 1;
  printf("/string_size %d def \n", numbytes);

  winnamesz = infile.header_size - sizeof(XWDFileHeader);
  winname = malloc(winnamesz);
  read(fileno(stdin), winname, winnamesz);
  printf("/header_size %d def\n", infile.header_size);
  printf("/display_type %d def\n", infile.display_type);
  printf("/display_panes %d def\n", infile.display_planes);
  printf("/pixmap_format %d def\n", infile.pixmap_format);
  printf("/pixmap_width %d def\n", infile.pixmap_width);
  printf("/pixmap_height %d def\n", infile.pixmap_height);
  printf("/window_width %d def\n", infile.window_width);
  printf("/window_height %d def\n", infile.window_height);
  printf("/window_x %d def\n", infile.window_x);
  printf("/window_y %d def\n", infile.window_y);
  printf("/window_border %d def\n", infile.window_bdrwidth);
  printf("/window_name (%s) def\n", winname);
  printf("%s", postheader);
  printf("gsave\n");
  printf("matrix defaultmatrix setmatrix\n");
  /* go back to default matrix */
  
  if (rotate) printf("\t90 rotate 0 -8.5 inches translate\n");

  printf("\t%f inches %f inches translate\n\
\t%f inches %f inches scale\n\
\timage_xps\n", xoff, yoff, rlwidth, rlheight);
  dump_bitmap(numbytes, infile.pixmap_height, strsize);
  printf("grestore\n");
  if (printit) printf("showpage\n");
}

  
dump_bitmap(numbytes, numlines, strsize)
     int numbytes, numlines, strsize;
{
  int num_on_line = 0;
  int i, j, picsize;
  unsigned char area;
  char *thebits, *theswappedbits;

  picsize = numlines * strsize;
  thebits = malloc(picsize);
  theswappedbits = malloc(picsize);
  if (read(fileno(stdin), thebits, picsize) < picsize) {
    fprintf(stderr, "Couldn't read picture\n");
    exit(1);
  }
  swab(thebits, theswappedbits, picsize);
  for (j = 0; j < numlines; j++) {
    printf("    ");
    for (i = 0; i < numbytes; i++) {
      register unsigned char thechar;
      thechar = *(theswappedbits + i + (j*strsize));
      thechar = (revbits[(thechar & 0xf)] << 4) |
	(revbits[(thechar >> 4)]);
      printf("%02x", thechar);
      if ((++num_on_line) == 40) {
	num_on_line = 0;
	printf("\n    ");
      }
    }
    num_on_line = 0;
    printf("\n");
  }
  
}
