DEFINT A-Z

'=================================================================
'
'    Name:       Demo_Prn. Bas   Copyright 1988-1994, Rob W. Smetana
'
'Requires:       Printer.Cfg.  BEFORE running this, you MUST run Printer.Exe,
'                select a printer, and press F2 to SAVE Printer.Cfg.  THIS
'                program displays the contents of Printer.Cfg.
'
'                The_Prn.Bas, an include file.
'
' Purpose:       * Demonstrate reading printer records.
'
'                * Demonstrate using printer code TYPEs (and when not to).
'
'                * Show how one might display printer codes.
'
'                  Something like this might be used inside a
'                  program to show users which codes are
'                  available (ie., not blank) and perhaps what
'                  they should do to invoke each option.
'
'    NOTE:       Some printer codes may contain control codes which
'                will screw up the display.  Try a different printer.
'                And in your own programs you might want to use an ASM
'                "quickprint" routine to overcome this problem.
'
'=================================================================


'...include two TYPES useful for reading printer codes.

'$INCLUDE: 'The_Prn.Bas'        '<<--- for Microsoft BASICS

''$INCLUDE "The_Prn.Bas"          '<<--- UN-REM for PowerBASIC 3.x

'...NOTE:  Although we loaded a TYPE called Printer, we won't use it!
'   For what we're about to do, it's more code efficient to read stuff
'   using some simple 980-byte strings.

Labels$ = SPACE$(980)
Codes$ = Labels$


OPEN "Printer.Cfg" FOR BINARY AS #1         '...this MUST already exist!!!

	GET #1, , PrnHeader                     '...we WILL use the header
	GET #1, , Labels$                       '...so we can print descriptions

	GET #1, , PrnHeader                     '...Get again so we're in position
											'   to read codes.
											 
	GET #1, , Codes$                        '...so we can print printer codes

CLOSE

'...Now display 'em

COLOR , 1: CLS

PRINT "   You chose a printer made by :  "; PrnHeader.Manufacturer;
PRINT "                  The Model is :  "; PrnHeader.Model


IF LEN(RTRIM$(PrnHeader.EmMode)) THEN       '...if it's emulating another ...

	PRINT "     This printer is emulating :  "; RTRIM$(PrnHeader.EmMode); " printer."
	It.Is.Emulating = -1

END IF
PRINT "                  Placeholders :  '' is a 'placeholder (see Printer.Doc)"

PRINT : PRINT

'...Now for the codes

FOR x = 1 TO 70

	'...Starting at column 1, print 70, 14-byte fields.

	Where = 1 + ((x - 1) * 14)

	'...Printing this way is simpler than printing separate TYPE members.

	PRINT "     "; MID$(Labels$, Where, 14); "   "; MID$(Codes$, Where, 14),


	'...They won't all fit on 1 screen, so pause, then display the rest.

	IF CSRLIN > 23 AND x < 70 THEN

	   LOCATE 25, 20: PRINT "Press any key to see the rest . . .";
	   d$ = INPUT$(1)

	   LOCATE 6, 1
	   IF It.Is.Emulating = False THEN PRINT

	END IF

NEXT

