/*************************************************************************
 *** AllDirs.cmd - Perform the given command in the current directory  ***
 *** ver.1         and in all subdirectories of the current directory. ***
 ***               perform in directories top-down.                    ***
 *************************************************************************/
'@echo OFF'
SETLOCAL
VALUE(ALLDIRS_CMD,ARG(1),'OS2ENVIRONMENT')
'CEnvi2.exe %0.cmd'
SIGNAL CENVI_EXIT

main(argc,argv)
{
   if ( !defined(ALLDIRS_CMD)  ||  !strcmp(ALLDIRS_CMD,"/?") )
      Instructions();
   else {
      // build a tree of all directories from the current point downward
      list = Directory(FullPath("*"),TRUE,FATTR_RDONLY|FATTR_HIDDEN|FATTR_SYSTEM|FATTR_SUBDIR|FATTR_ARCHIVE,FATTR_SUBDIR)
      // first perform command in current directory
      RememberDir = FullPath(".")
      PerformCommand()
      if ( NULL != list ) {
         listCount = 1 + GetArraySpan(list)
         for ( i = 0; i < listCount; i++ ) {
            // change to each subdirectory and perform command there
            ChangeToDirectory(list[i].name)
            PerformCommand()
         }
         ChangeToDirectory(RememberDir)
      }
   }
}

PerformCommand()
{
   printf("%s",ALLDIRS_CMD)
   system(ALLDIRS_CMD);
}

ChangeToDirectory(DirName)
{
   printf("\n%s: ",DirName)
   #define ORD_DOS32SETCURRENTDIR   255
   DynamicLink("doscalls",ORD_DOS32SETCURRENTDIR,BIT32,CDECL,DirName)
}

Instructions()
{
   printf("\n")
   printf("AllDirs - Perform a command in this directory and all subdirectories\n")
   printf("\n")
   printf("SYNTAX: AllDirs commands...\n")
   printf("\n")
   printf("Where: commands is any commands to perform in each directory\n")
   printf("\n")
   printf("Examples: This example deletes all *.bak files in this directory and in\n")
   printf("          directories below this one:\n")
   printf("            AllDirs del *.bak\n")
   printf("\n")
}

CENVI_EXIT:
ENDLOCAL
