EXTPROC CEnvi2
/**********************************************************************
 *** DoFiles.cmd - Perform the given command on all files selected  ***
 *** ver.1         through file dialog, where the special command   ***
 ***               fields $DIR, $ROOT, $EXT, and $FILE are replaced ***
 ***               by the directory, root, extension, and full      ***
 ***               filename of the matching files chosen.           ***
 **********************************************************************/

#include <FileDlg.lib>

main(argc,argv)
{
   if ( argc < 3  ||  !strcmp(argv[1],"/?")  ||  !stricmp(argv[1],"/help") ) {
      Instructions();
   } else {
      FileSpec = argv[1];
      // build output command, which is all the other input args
      Command = argv[2];
      for ( i = 3; i < argc; i++ ) {
         strcat(strcat(Command," "),argv[i]);
      }
      // build list of matching files
      FileList = FileDialog(FileSpec,"Select files for command.",
                            FDS_OPEN_DIALOG | FDS_CENTER | FDS_MULTIPLESEL,
                            "Do it!");
      if ( NULL != FileList ) {
         for( i = 0; i <= GetArraySpan(FileList); i++ ) {
            PerformCommandOnFile(Command,FileList[i]);
         }
      }
   }
}

SubstituteNamesInCommand(Command,Find,Replace)
{
   FindLen = strlen(Find);
   ReplaceLen = strlen(Replace);
   for ( c = Command; NULL != (c = strchr(c,'$')); c++ ) {
      if ( !strnicmp(c+1,Find,FindLen) ) {
         // replace the Find string with the Replace string
         strcpy(c+ReplaceLen,c+1+FindLen);
         memcpy(c,Replace,ReplaceLen);
         c += ReplaceLen - 1;
      }
   }
}

PerformCommandOnFile(VirginCommand,File)
{
   NameParts = SplitFileName(File);
   // substitute all the $DIR, $ROOT, $EXT, and $FILE commands for that part in NameParts
   strcpy(NewCommand,VirginCommand);
   SubstituteNamesInCommand(NewCommand,"DIR",NameParts.dir);
   SubstituteNamesInCommand(NewCommand,"ROOT",NameParts.name);
   SubstituteNamesInCommand(NewCommand,"EXT",NameParts.ext);
   SubstituteNamesInCommand(NewCommand,"FILE",File);
   // set the environment variables to the new values
   $DIR = NameParts.dir
   $ROOT = NameParts.name
   $EXT = NameParts.ext
   $FILE = File
   // print the command, and send it to the system
   printf("%s\n",NewCommand);
   system(NewCommand);
}

Instructions()
{
   printf("\n")
   printf("DoFiles.cmd - Execute a command on all files selected from a dialog box.  The\n")
   printf("              command may include these strings:\n")
   printf("                $DIR    - directory portion of matching file\n")
   printf("                $ROOT   - root name of the matching file\n")
   printf("                $EXT    - extension name of the matching file\n")
   printf("                $FILE   - full name of the matching file\n")
   printf("               These names, $DIR, $ROOT, $EXT, and $FILE will also be set as\n")
   printf("               environment variables when the command is executed.\n")
   printf("\n")
   printf("SYNTAX: DoFiles FileSpec [Command]\n")
   printf("Where:  FileSpec  - any file specification ith wildcards included\n")
   printf("        Command   - any command line specification\n")
   printf("\n")
   printf("EXAMPLE: To copy selected *.TXT files to *.bak files in the C:\\Temp directory,\n")
   printf("         but only if the C:\\Temp\\*.bak file does not already exist:\n")
   printf("     DOFILES *.TXT IF NOT EXIST C:\\Temp\\$ROOT.bak copy $FILE C:\\Temp\\$ROOT.bak\n")
   printf("\n")
}

